/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamOptions;
import io.nats.client.Message;
import io.nats.client.PurgeOptions;
import io.nats.client.api.AccountStatistics;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.ConsumerPauseRequest;
import io.nats.client.api.ConsumerPauseResponse;
import io.nats.client.api.Error;
import io.nats.client.api.MessageDeleteRequest;
import io.nats.client.api.MessageGetRequest;
import io.nats.client.api.MessageInfo;
import io.nats.client.api.PurgeResponse;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.api.StreamInfo;
import io.nats.client.api.StreamInfoOptions;
import io.nats.client.api.SuccessApiResponse;
import io.nats.client.impl.ConsumerListReader;
import io.nats.client.impl.ConsumerNamesReader;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamImpl;
import io.nats.client.impl.StreamListReader;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;

public class NatsJetStreamManagement
extends NatsJetStreamImpl
implements JetStreamManagement {
    private NatsJetStream js;

    public NatsJetStreamManagement(NatsConnection connection, JetStreamOptions jsOptions) throws IOException {
        super(connection, jsOptions);
    }

    @Override
    public AccountStatistics getAccountStatistics() throws IOException, JetStreamApiException {
        Message resp = this.makeRequestResponseRequired("INFO", null, this.jso.getRequestTimeout());
        return (AccountStatistics)new AccountStatistics(resp).throwOnHasError();
    }

    @Override
    public StreamInfo addStream(StreamConfiguration config) throws IOException, JetStreamApiException {
        return this.addOrUpdateStream(config, "STREAM.CREATE.%s");
    }

    @Override
    public StreamInfo updateStream(StreamConfiguration config) throws IOException, JetStreamApiException {
        return this.addOrUpdateStream(config, "STREAM.UPDATE.%s");
    }

    private StreamInfo addOrUpdateStream(StreamConfiguration config, String template) throws IOException, JetStreamApiException {
        Validator.validateNotNull(config, "Configuration");
        String streamName = config.getName();
        if (Validator.nullOrEmpty(streamName)) {
            throw new IllegalArgumentException("Configuration must have a valid stream name");
        }
        String subj = String.format(template, streamName);
        Message resp = this.makeRequestResponseRequired(subj, config.toJson().getBytes(StandardCharsets.UTF_8), this.jso.getRequestTimeout());
        return this.createAndCacheStreamInfoThrowOnError(streamName, resp);
    }

    @Override
    public boolean deleteStream(String streamName) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        String subj = String.format("STREAM.DELETE.%s", streamName);
        Message resp = this.makeRequestResponseRequired(subj, null, this.jso.getRequestTimeout());
        return ((SuccessApiResponse)new SuccessApiResponse(resp).throwOnHasError()).getSuccess();
    }

    @Override
    public StreamInfo getStreamInfo(String streamName) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        return this._getStreamInfo(streamName, null);
    }

    @Override
    public StreamInfo getStreamInfo(String streamName, StreamInfoOptions options) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        return this._getStreamInfo(streamName, options);
    }

    @Override
    public PurgeResponse purgeStream(String streamName) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        String subj = String.format("STREAM.PURGE.%s", streamName);
        Message resp = this.makeRequestResponseRequired(subj, null, this.jso.getRequestTimeout());
        return (PurgeResponse)new PurgeResponse(resp).throwOnHasError();
    }

    @Override
    public PurgeResponse purgeStream(String streamName, PurgeOptions options) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        Validator.validateNotNull(options, "Purge Options");
        String subj = String.format("STREAM.PURGE.%s", streamName);
        byte[] body = options.toJson().getBytes(StandardCharsets.UTF_8);
        Message resp = this.makeRequestResponseRequired(subj, body, this.jso.getRequestTimeout());
        return (PurgeResponse)new PurgeResponse(resp).throwOnHasError();
    }

    @Override
    public ConsumerInfo addOrUpdateConsumer(String streamName, ConsumerConfiguration config) throws IOException, JetStreamApiException {
        Validator.validateStreamName(streamName, true);
        Validator.validateNotNull(config, "Config");
        return this._createConsumer(streamName, config);
    }

    @Override
    public boolean deleteConsumer(String streamName, String consumerName) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        Validator.validateNotNull(consumerName, "Consumer Name");
        String subj = String.format("CONSUMER.DELETE.%s.%s", streamName, consumerName);
        Message resp = this.makeRequestResponseRequired(subj, null, this.jso.getRequestTimeout());
        return ((SuccessApiResponse)new SuccessApiResponse(resp).throwOnHasError()).getSuccess();
    }

    @Override
    public ConsumerPauseResponse pauseConsumer(String streamName, String consumerName, ZonedDateTime pauseUntil) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        Validator.validateNotNull(consumerName, "Consumer Name");
        String subj = String.format("CONSUMER.PAUSE.%s.%s", streamName, consumerName);
        ConsumerPauseRequest pauseRequest = new ConsumerPauseRequest(pauseUntil);
        Message resp = this.makeRequestResponseRequired(subj, pauseRequest.serialize(), this.jso.getRequestTimeout());
        return (ConsumerPauseResponse)new ConsumerPauseResponse(resp).throwOnHasError();
    }

    @Override
    public boolean resumeConsumer(String streamName, String consumerName) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        Validator.validateNotNull(consumerName, "Consumer Name");
        String subj = String.format("CONSUMER.PAUSE.%s.%s", streamName, consumerName);
        Message resp = this.makeRequestResponseRequired(subj, null, this.jso.getRequestTimeout());
        ConsumerPauseResponse response = (ConsumerPauseResponse)new ConsumerPauseResponse(resp).throwOnHasError();
        return !response.isPaused();
    }

    @Override
    public ConsumerInfo getConsumerInfo(String streamName, String consumerName) throws IOException, JetStreamApiException {
        return super._getConsumerInfo(streamName, consumerName);
    }

    @Override
    public List<String> getConsumerNames(String streamName) throws IOException, JetStreamApiException {
        return this.getConsumerNames(streamName, null);
    }

    private List<String> getConsumerNames(String streamName, String filter) throws IOException, JetStreamApiException {
        String subj = String.format("CONSUMER.NAMES.%s", streamName);
        ConsumerNamesReader cnr = new ConsumerNamesReader();
        while (cnr.hasMore()) {
            Message resp = this.makeRequestResponseRequired(subj, cnr.nextJson(filter), this.jso.getRequestTimeout());
            cnr.process(resp);
        }
        return cnr.getStrings();
    }

    @Override
    public List<ConsumerInfo> getConsumers(String streamName) throws IOException, JetStreamApiException {
        String subj = String.format("CONSUMER.LIST.%s", streamName);
        ConsumerListReader clg = new ConsumerListReader();
        while (clg.hasMore()) {
            Message resp = this.makeRequestResponseRequired(subj, clg.nextJson(), this.jso.getRequestTimeout());
            clg.process(resp);
        }
        return clg.getConsumers();
    }

    @Override
    public List<String> getStreamNames() throws IOException, JetStreamApiException {
        return this._getStreamNames(null);
    }

    @Override
    public List<String> getStreamNames(String subjectFilter) throws IOException, JetStreamApiException {
        return this._getStreamNames(subjectFilter);
    }

    @Override
    public List<StreamInfo> getStreams() throws IOException, JetStreamApiException {
        return this.getStreams(null);
    }

    @Override
    public List<StreamInfo> getStreams(String subjectFilter) throws IOException, JetStreamApiException {
        StreamListReader slr = new StreamListReader();
        while (slr.hasMore()) {
            Message resp = this.makeRequestResponseRequired("STREAM.LIST", slr.nextJson(subjectFilter), this.jso.getRequestTimeout());
            slr.process(resp);
        }
        return this.cacheStreamInfo(slr.getStreams());
    }

    @Override
    public MessageInfo getMessage(String streamName, long seq) throws IOException, JetStreamApiException {
        return this._getMessage(streamName, MessageGetRequest.forSequence(seq));
    }

    @Override
    public MessageInfo getLastMessage(String streamName, String subject) throws IOException, JetStreamApiException {
        return this._getMessage(streamName, MessageGetRequest.lastForSubject(subject));
    }

    @Override
    public MessageInfo getFirstMessage(String streamName, String subject) throws IOException, JetStreamApiException {
        return this._getMessage(streamName, MessageGetRequest.firstForSubject(subject));
    }

    @Override
    public MessageInfo getNextMessage(String streamName, long seq, String subject) throws IOException, JetStreamApiException {
        return this._getMessage(streamName, MessageGetRequest.nextForSubject(seq, subject));
    }

    private MessageInfo _getMessage(String streamName, MessageGetRequest messageGetRequest) throws IOException, JetStreamApiException {
        Validator.validateNotNull(messageGetRequest, "Message Get Request");
        NatsJetStreamImpl.CachedStreamInfo csi = this.getCachedStreamInfo(streamName);
        if (csi.allowDirect) {
            byte[] payload;
            String subject;
            if (messageGetRequest.isLastBySubject()) {
                subject = String.format("DIRECT.GET.%s.%s", streamName, messageGetRequest.getLastBySubject());
                payload = null;
            } else {
                subject = String.format("DIRECT.GET.%s", streamName);
                payload = messageGetRequest.serialize();
            }
            Message resp = this.makeRequestResponseRequired(subject, payload, this.jso.getRequestTimeout());
            if (resp.isStatusMessage()) {
                throw new JetStreamApiException(Error.convert(resp.getStatus()));
            }
            return new MessageInfo(resp, streamName, true);
        }
        String getSubject = String.format("STREAM.MSG.GET.%s", streamName);
        Message resp = this.makeRequestResponseRequired(getSubject, messageGetRequest.serialize(), this.jso.getRequestTimeout());
        return (MessageInfo)new MessageInfo(resp, streamName, false).throwOnHasError();
    }

    @Override
    public boolean deleteMessage(String streamName, long seq) throws IOException, JetStreamApiException {
        return this.deleteMessage(streamName, seq, true);
    }

    @Override
    public boolean deleteMessage(String streamName, long seq, boolean erase) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        String subj = String.format("STREAM.MSG.DELETE.%s", streamName);
        MessageDeleteRequest mdr = new MessageDeleteRequest(seq, erase);
        Message resp = this.makeRequestResponseRequired(subj, mdr.serialize(), this.jso.getRequestTimeout());
        return ((SuccessApiResponse)new SuccessApiResponse(resp).throwOnHasError()).getSuccess();
    }

    @Override
    public JetStream jetStream() {
        if (this.js == null) {
            this.js = new NatsJetStream(this);
        }
        return this.js;
    }
}

