/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.impl.Headers;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.IncomingHeadersProcessor;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.NatsJetStreamConstants;
import java.time.ZonedDateTime;

public class MessageInfo
extends ApiResponse<MessageInfo> {
    private final boolean direct;
    private final String subject;
    private final long seq;
    private final byte[] data;
    private final ZonedDateTime time;
    private final Headers headers;
    private final String stream;
    private final long lastSeq;

    @Deprecated
    public MessageInfo(Message msg) {
        this(msg, null, false);
    }

    public MessageInfo(Message msg, String streamName, boolean direct) {
        super(direct ? null : msg);
        this.direct = direct;
        if (direct) {
            Headers msgHeaders = msg.getHeaders();
            this.subject = msgHeaders.getLast("Nats-Subject");
            this.data = msg.getData();
            this.seq = Long.parseLong(msgHeaders.getLast("Nats-Sequence"));
            this.time = DateTimeUtils.parseDateTime(msgHeaders.getLast("Nats-Time-Stamp"));
            this.stream = msgHeaders.getLast("Nats-Stream");
            String temp = msgHeaders.getLast("Nats-Last-Sequence");
            this.lastSeq = temp == null ? -1L : JsonUtils.safeParseLong(temp, -1L);
            this.headers = new Headers(msgHeaders, true, NatsJetStreamConstants.MESSAGE_INFO_HEADERS);
        } else if (this.hasError()) {
            this.subject = null;
            this.data = null;
            this.seq = -1L;
            this.time = null;
            this.headers = null;
            this.stream = null;
            this.lastSeq = -1L;
        } else {
            JsonValue mjv = JsonValueUtils.readValue(this.jv, "message");
            this.subject = JsonValueUtils.readString(mjv, "subject");
            this.data = JsonValueUtils.readBase64(mjv, "data");
            this.seq = JsonValueUtils.readLong(mjv, "seq", 0L);
            this.time = JsonValueUtils.readDate(mjv, "time");
            byte[] hdrBytes = JsonValueUtils.readBase64(mjv, "hdrs");
            this.headers = hdrBytes == null ? null : new IncomingHeadersProcessor(hdrBytes).getHeaders();
            this.stream = streamName;
            this.lastSeq = -1L;
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public long getSeq() {
        return this.seq;
    }

    public byte[] getData() {
        return this.data;
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getStream() {
        return this.stream;
    }

    public long getLastSeq() {
        return this.lastSeq;
    }

    @Override
    public String toString() {
        StringBuilder sb = JsonUtils.beginJsonPrefixed("\"MessageInfo\":");
        JsonUtils.addField(sb, "direct", this.direct);
        JsonUtils.addField(sb, "error", this.getError());
        JsonUtils.addField(sb, "subject", this.subject);
        JsonUtils.addField(sb, "seq", this.seq);
        if (this.data == null) {
            JsonUtils.addRawJson(sb, "data", "null");
        } else {
            JsonUtils.addField(sb, "data_length", this.data.length);
        }
        JsonUtils.addField(sb, "time", this.time);
        JsonUtils.addField(sb, "stream", this.stream);
        JsonUtils.addField(sb, "last_seq", this.lastSeq);
        JsonUtils.addField(sb, "subject", this.subject);
        JsonUtils.addField(sb, "hdrs", this.headers);
        return JsonUtils.endJson(sb).toString();
    }
}

