/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.FeatureOptions;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.MessageInfo;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamManagement;
import java.io.IOException;
import java.time.Duration;

public class NatsFeatureBase {
    protected final NatsJetStream js;
    protected final JetStreamManagement jsm;
    protected String streamName;

    NatsFeatureBase(NatsConnection connection, FeatureOptions fo) throws IOException {
        if (fo == null) {
            this.js = new NatsJetStream(connection, null);
            this.jsm = new NatsJetStreamManagement(connection, null);
        } else {
            this.js = new NatsJetStream(connection, fo.getJetStreamOptions());
            this.jsm = new NatsJetStreamManagement(connection, fo.getJetStreamOptions());
        }
    }

    String getStreamName() {
        return this.streamName;
    }

    protected MessageInfo _getLast(String subject) throws IOException, JetStreamApiException {
        try {
            return this.jsm.getLastMessage(this.streamName, subject);
        }
        catch (JetStreamApiException jsae) {
            if (jsae.getApiErrorCode() == 10037) {
                return null;
            }
            throw jsae;
        }
    }

    protected MessageInfo _getBySeq(long seq) throws IOException, JetStreamApiException {
        try {
            return this.jsm.getMessage(this.streamName, seq);
        }
        catch (JetStreamApiException jsae) {
            if (jsae.getApiErrorCode() == 10037) {
                return null;
            }
            throw jsae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitSubject(String subject, DeliverPolicy deliverPolicy, boolean headersOnly, boolean ordered, MessageHandler handler) throws IOException, JetStreamApiException, InterruptedException {
        PushSubscribeOptions pso = ((PushSubscribeOptions.Builder)((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().stream(this.streamName)).ordered(ordered).configuration(ConsumerConfiguration.builder().ackPolicy(AckPolicy.None).deliverPolicy(deliverPolicy).headersOnly(headersOnly).build())).build();
        Duration timeout = this.js.jso.getRequestTimeout();
        JetStreamSubscription sub = this.js.subscribe(subject, pso);
        try {
            boolean lastWasNull = false;
            long pending = sub.getConsumerInfo().getCalculatedPending();
            while (pending > 0L) {
                Message m = sub.nextMessage(timeout);
                if (m == null) {
                    if (lastWasNull) {
                        return;
                    }
                    lastWasNull = true;
                    continue;
                }
                handler.onMessage(m);
                if (--pending == 0L) {
                    return;
                }
                lastWasNull = false;
            }
        }
        finally {
            sub.unsubscribe();
        }
    }
}

