/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ConsumeOptions;
import io.nats.client.IterableConsumer;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamStatusCheckedException;
import io.nats.client.JetStreamStatusException;
import io.nats.client.Message;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.NatsMessageConsumer;
import io.nats.client.impl.SimplifiedSubscriptionMaker;
import java.io.IOException;
import java.time.Duration;

class NatsIterableConsumer
extends NatsMessageConsumer
implements IterableConsumer {
    NatsIterableConsumer(SimplifiedSubscriptionMaker subscriptionMaker, ConsumerInfo cachedConsumerInfo, ConsumeOptions opts) throws IOException, JetStreamApiException {
        super(subscriptionMaker, cachedConsumerInfo, opts, null, null);
    }

    @Override
    public Message nextMessage(Duration timeout) throws InterruptedException, JetStreamStatusCheckedException {
        try {
            Message msg = this.sub.nextMessage(timeout);
            if (msg != null && this.stopped.get() && this.pmm.noMorePending()) {
                this.finished.set(true);
            }
            return msg;
        }
        catch (JetStreamStatusException e) {
            throw new JetStreamStatusCheckedException(e);
        }
        catch (IllegalStateException i) {
            return null;
        }
    }

    @Override
    public Message nextMessage(long timeoutMillis) throws InterruptedException, JetStreamStatusCheckedException {
        return this.nextMessage(Duration.ofMillis(timeoutMillis));
    }
}

