/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ForceReconnectOptions;
import io.nats.client.Options;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.SocketDataPort;
import io.nats.client.support.NatsUri;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class SocketDataPortWithWriteTimeout
extends SocketDataPort {
    private long writeTimeoutNanos;
    private long delayPeriodMillis;
    private Timer writeWatcherTimer;
    private WriteWatcherTask writeWatcherTask;
    private volatile long writeMustBeDoneBy = Long.MAX_VALUE;

    @Override
    public void afterConstruct(Options options) {
        super.afterConstruct(options);
        long writeTimeoutMillis = options.getSocketWriteTimeout() == null ? Options.DEFAULT_SOCKET_WRITE_TIMEOUT.toMillis() : options.getSocketWriteTimeout().toMillis();
        this.delayPeriodMillis = writeTimeoutMillis * 51L / 100L;
        this.writeTimeoutNanos = writeTimeoutMillis * 1000000L;
    }

    @Override
    public void connect(NatsConnection conn, NatsUri nuri, long timeoutNanos) throws IOException {
        super.connect(conn, nuri, timeoutNanos);
        this.writeWatcherTimer = new Timer();
        this.writeWatcherTask = new WriteWatcherTask();
        this.writeWatcherTimer.schedule((TimerTask)this.writeWatcherTask, this.delayPeriodMillis, this.delayPeriodMillis);
    }

    @Override
    public void write(byte[] src, int toWrite) throws IOException {
        this.writeMustBeDoneBy = System.nanoTime() + this.writeTimeoutNanos;
        this.out.write(src, 0, toWrite);
        this.writeMustBeDoneBy = Long.MAX_VALUE;
    }

    @Override
    public void close() throws IOException {
        try {
            this.writeWatcherTask.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.writeWatcherTimer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }

    class WriteWatcherTask
    extends TimerTask {
        WriteWatcherTask() {
        }

        @Override
        public void run() {
            if (System.nanoTime() > SocketDataPortWithWriteTimeout.this.writeMustBeDoneBy) {
                SocketDataPortWithWriteTimeout.this.writeWatcherTimer.cancel();
                SocketDataPortWithWriteTimeout.this.connection.executeCallback((c, el) -> el.socketWriteTimeout(c));
                try {
                    SocketDataPortWithWriteTimeout.this.connection.forceReconnect(ForceReconnectOptions.FORCE_CLOSE_INSTANCE);
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

