/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.AccountLimits;
import io.nats.client.api.AccountTier;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.ApiStats;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AccountStatistics
extends ApiResponse<AccountStatistics> {
    private final AccountTier rollupTier;
    private final String domain;
    private final ApiStats api;
    private final Map<String, AccountTier> tiers;

    public AccountStatistics(Message msg) {
        super(msg);
        this.rollupTier = new AccountTier(this.jv);
        this.domain = JsonValueUtils.readString(this.jv, "domain");
        this.api = new ApiStats(JsonValueUtils.readObject(this.jv, "api"));
        JsonValue vTiers = JsonValueUtils.readObject(this.jv, "tiers");
        this.tiers = new HashMap<String, AccountTier>();
        if (vTiers.map != null) {
            for (String key : vTiers.map.keySet()) {
                this.tiers.put(key, new AccountTier(vTiers.map.get(key)));
            }
        }
    }

    public long getMemory() {
        return this.rollupTier.getMemoryBytes();
    }

    public long getStorage() {
        return this.rollupTier.getStorageBytes();
    }

    public long getReservedMemory() {
        return this.rollupTier.getReservedMemoryBytes();
    }

    public long getReservedStorage() {
        return this.rollupTier.getReservedStorageBytes();
    }

    public long getStreams() {
        return this.rollupTier.getStreams();
    }

    public long getConsumers() {
        return this.rollupTier.getConsumers();
    }

    public AccountLimits getLimits() {
        return this.rollupTier.getLimits();
    }

    public @Nullable String getDomain() {
        return this.domain;
    }

    public @NonNull ApiStats getApi() {
        return this.api;
    }

    public @NonNull Map<String, AccountTier> getTiers() {
        return this.tiers;
    }
}

