/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.AccountLimits;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import org.jspecify.annotations.NonNull;

public class AccountTier {
    private final long memory;
    private final long storage;
    private final long reservedMemory;
    private final long reservedStorage;
    private final int streams;
    private final int consumers;
    private final AccountLimits limits;

    AccountTier(JsonValue vAccountTier) {
        this.memory = JsonValueUtils.readInteger(vAccountTier, "memory", 0);
        this.storage = JsonValueUtils.readInteger(vAccountTier, "storage", 0);
        this.reservedMemory = JsonValueUtils.readInteger(vAccountTier, "reserved_memory", 0);
        this.reservedStorage = JsonValueUtils.readInteger(vAccountTier, "reserved_storage", 0);
        this.streams = JsonValueUtils.readInteger(vAccountTier, "streams", 0);
        this.consumers = JsonValueUtils.readInteger(vAccountTier, "consumers", 0);
        this.limits = new AccountLimits(JsonValueUtils.readObject(vAccountTier, "limits"));
    }

    public long getMemoryBytes() {
        return this.memory;
    }

    public long getStorageBytes() {
        return this.storage;
    }

    public long getReservedMemory() {
        return (int)this.reservedMemory;
    }

    public long getReservedStorage() {
        return this.reservedStorage;
    }

    public long getReservedMemoryBytes() {
        return this.reservedMemory;
    }

    public long getReservedStorageBytes() {
        return this.reservedStorage;
    }

    public int getStreams() {
        return this.streams;
    }

    public int getConsumers() {
        return this.consumers;
    }

    public @NonNull AccountLimits getLimits() {
        return this.limits;
    }

    @Deprecated
    public int getMemory() {
        return (int)this.memory;
    }

    @Deprecated
    public int getStorage() {
        return (int)this.storage;
    }
}

