/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Connection;

public interface ConnectionListener {
    @Deprecated
    public void connectionEvent(Connection var1, Events var2);

    default public void connectionEvent(Connection conn, Events type, Long time, String uriDetails) {
        this.connectionEvent(conn, type);
    }

    public static enum Events {
        CONNECTED(true, "opened"),
        CLOSED(true, "closed"),
        DISCONNECTED(true, "disconnected"),
        RECONNECTED(true, "reconnected"),
        RESUBSCRIBED(false, "subscriptions re-established"),
        DISCOVERED_SERVERS(false, "discovered servers"),
        LAME_DUCK(false, "lame duck mode");

        private final boolean connectionEvent;
        private final String event;
        private final String natsEvent;

        private Events(boolean connectionEvent, String event) {
            this.connectionEvent = connectionEvent;
            this.event = event;
            this.natsEvent = connectionEvent ? "nats: connection " + event : "nats: " + event;
        }

        public boolean isConnectionEvent() {
            return this.connectionEvent;
        }

        public String getEvent() {
            return this.event;
        }

        public String getNatsEvent() {
            return this.natsEvent;
        }

        public String toString() {
            return this.natsEvent;
        }
    }
}

