/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples;

import io.nats.client.AuthHandler;
import io.nats.client.NKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public class ExampleAuthHandler
implements AuthHandler {
    private final NKey nkey;

    public ExampleAuthHandler(String path) throws Exception {
        File f = new File(path);
        int numBytes = (int)f.length();
        try (BufferedReader in = new BufferedReader(new FileReader(f));){
            char[] buffer = new char[numBytes];
            int numChars = in.read(buffer);
            if (numChars < numBytes) {
                char[] seed = new char[numChars];
                System.arraycopy(buffer, 0, seed, 0, numChars);
                this.nkey = NKey.fromSeed(seed);
                Arrays.fill(seed, '\u0000');
            } else {
                this.nkey = NKey.fromSeed(buffer);
            }
            Arrays.fill(buffer, '\u0000');
        }
    }

    public NKey getNKey() {
        return this.nkey;
    }

    @Override
    public char[] getID() {
        try {
            return this.nkey.getPublicKey();
        }
        catch (IOException | NullPointerException | GeneralSecurityException ex) {
            return null;
        }
    }

    @Override
    public byte[] sign(byte[] nonce) {
        try {
            return this.nkey.sign(nonce);
        }
        catch (IOException | NullPointerException | GeneralSecurityException ex) {
            return null;
        }
    }

    @Override
    public char[] getJWT() {
        return null;
    }
}

