/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.autobench;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.examples.autobench.AutoBenchmark;
import io.nats.examples.autobench.JsPubBenchmark;
import java.io.IOException;
import java.time.Duration;

public class JsSubBenchmark
extends AutoBenchmark {
    public JsSubBenchmark(String name, long messageCount, long messageSize) {
        super(name, messageCount, messageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Options connectOptions) throws InterruptedException {
        String subject = JsPubBenchmark.getSubject(this.getMessageCount(), this.getMessageSize());
        try {
            Connection nc = Nats.connect(connectOptions);
            JetStream js = nc.jetStream();
            ConsumerConfiguration c = ConsumerConfiguration.builder().ackPolicy(AckPolicy.None).build();
            PushSubscribeOptions pso = ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().configuration(c)).build();
            JetStreamSubscription jsSub = js.subscribe(subject, pso);
            try {
                this.startTiming();
                int i = 0;
                while ((long)i < this.getMessageCount()) {
                    jsSub.nextMessage(Duration.ofSeconds(1L));
                    ++i;
                }
                this.defaultFlush(nc);
                this.endTiming();
            }
            finally {
                try {
                    nc.jetStreamManagement().deleteStream(JsPubBenchmark.getStream(this.getMessageCount(), this.getMessageSize()));
                }
                catch (JetStreamApiException | IOException ex) {
                    this.setException(ex);
                }
                finally {
                    nc.close();
                }
            }
        }
        catch (JetStreamApiException | IOException ex) {
            this.setException(ex);
        }
    }
}

