/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.autobench;

import io.nats.client.Connection;
import io.nats.client.Options;
import io.nats.examples.autobench.AutoBenchmark;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public abstract class ThrottledBenchmark
extends AutoBenchmark {
    private long targetPubRate = 0L;
    private boolean pubFailed = false;
    private AtomicLong sent = new AtomicLong();

    public ThrottledBenchmark(String name, long messageCount, long messageSize) {
        super(name, messageCount, messageSize);
    }

    void pubFailed() {
        this.pubFailed = true;
    }

    abstract void executeWithLimiter(Options var1) throws InterruptedException;

    @Override
    public void execute(Options connectOptions) throws InterruptedException {
        do {
            this.pubFailed = false;
            this.sent.set(0L);
            this.reset();
            this.executeWithLimiter(connectOptions);
            if (this.getException() == null || this.pubFailed) break;
            long currentPubRate = (long)(1.0E9 * (double)this.sent.get() / (double)this.getRuntimeNanos());
            if (this.targetPubRate == 0L) {
                this.targetPubRate = 2L * currentPubRate;
            }
            this.targetPubRate -= this.targetPubRate / 10L;
        } while (this.targetPubRate >= 500L);
    }

    void adjustAndSleep(Connection nc) throws InterruptedException {
        long count = this.sent.incrementAndGet();
        if (this.targetPubRate <= 0L) {
            return;
        }
        if (count % 1000L != 0L) {
            return;
        }
        long now = System.nanoTime();
        long start = this.getStart();
        double rate = 1.0E9 * (double)count / (double)(now - start);
        double delay = 1.0 / (double)this.targetPubRate;
        double adjust = delay / 20.0;
        if (adjust == 0.0) {
            adjust = 1.0E-9;
        }
        if (rate < (double)this.targetPubRate) {
            delay -= adjust;
        } else if (rate > (double)this.targetPubRate) {
            delay += adjust;
        }
        if (delay < 0.0) {
            delay = 0.0;
        }
        long nanos = (long)((delay *= 1000.0) * 1.0E9);
        LockSupport.parkNanos(nanos);
        if (this.getMessageSize() < 64L && count != 0L && count % 100000L == 0L) {
            try {
                nc.flush(Duration.ofSeconds(5L));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

