/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.benchmark;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RawTCPLatencyTest {
    static boolean isServer;
    static String host;
    static int port;
    static int warmIters;
    static int runIters;
    static InputStream in;
    static OutputStream out;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Parameters: server/client host port");
            return;
        }
        isServer = args[0].startsWith("s");
        if (args.length > 1) {
            host = args[1];
        }
        if (args.length > 2) {
            port = Integer.parseInt(args[2]);
        }
        try {
            if (isServer) {
                RawTCPLatencyTest.runServer();
            } else {
                RawTCPLatencyTest.runClient();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(RawTCPLatencyTest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void runServer() throws IOException {
        ServerSocket serverSocket = new ServerSocket(port);
        Throwable throwable = null;
        try {
            try {
                while (true) {
                    Socket socket = serverSocket.accept();
                    System.out.println("Connected");
                    socket.setTcpNoDelay(true);
                    socket.setReceiveBufferSize(0x200000);
                    socket.setSendBufferSize(0x200000);
                    in = socket.getInputStream();
                    out = socket.getOutputStream();
                    try {
                        while (true) {
                            int rq = in.read();
                            out.write(rq);
                        }
                    }
                    catch (IOException e) {
                        System.out.println("Disconnected");
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (serverSocket != null) {
                if (throwable != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    serverSocket.close();
                }
            }
            throw throwable3;
        }
    }

    private static void runClient() throws SocketException, IOException {
        Socket socket = new Socket();
        socket.setTcpNoDelay(true);
        socket.setReceiveBufferSize(0x200000);
        socket.setSendBufferSize(0x200000);
        socket.connect(new InetSocketAddress(host, port), 1000);
        in = socket.getInputStream();
        out = socket.getOutputStream();
        System.out.println("Connected");
        for (int i = 0; i < warmIters; ++i) {
            RawTCPLatencyTest.sendRecv();
        }
        System.out.println("Warmed");
        long t0 = System.nanoTime();
        for (int i = 0; i < runIters; ++i) {
            RawTCPLatencyTest.sendRecv();
        }
        long t1 = System.nanoTime();
        System.out.println("Average latency " + 1.0 * (double)(t1 - t0) / (1000000.0 * (double)runIters) + " ms");
        socket.close();
    }

    private static void sendRecv() throws IOException {
        out.write(11);
        in.read();
    }

    static {
        host = "localhost";
        port = 1234;
        warmIters = 1000;
        runIters = 10000;
    }
}

