/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.chaosTestApp;

import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.NUID;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.DeliverPolicy;
import io.nats.examples.chaosTestApp.Output;
import io.nats.examples.chaosTestApp.OutputErrorListener;
import io.nats.examples.chaosTestApp.support.CommandLine;
import io.nats.examples.chaosTestApp.support.ConsumerKind;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public abstract class ConnectableConsumer
implements ConnectionListener {
    protected final Connection nc;
    protected final JetStream js;
    protected final OutputErrorListener errorListener;
    protected final AtomicLong lastReceivedSequence;
    protected final MessageHandler handler;
    protected final ConsumerKind consumerKind;
    protected final CommandLine cmd;
    protected String initials;
    protected String name;
    protected String durableName;
    protected String label;

    public ConnectableConsumer(CommandLine cmd, String initials, ConsumerKind consumerKind) throws IOException, InterruptedException, JetStreamApiException {
        this.cmd = cmd;
        this.lastReceivedSequence = new AtomicLong(0L);
        this.consumerKind = consumerKind;
        switch (consumerKind) {
            case Durable: {
                this.name = this.durableName = initials + "-dur-" + new NUID().nextSequence();
                break;
            }
            case Ephemeral: {
                this.durableName = null;
                this.name = initials + "-eph-" + new NUID().nextSequence();
                break;
            }
            case Ordered: {
                this.durableName = null;
                this.name = initials + "-ord-" + new NUID().nextSequence();
            }
        }
        this.initials = initials;
        this.label = this.name + " (" + consumerKind.name() + ")";
        this.errorListener = new OutputErrorListener(this.label);
        Options options = cmd.makeOptions(this, this.errorListener);
        this.nc = Nats.connect(options);
        this.js = this.nc.jetStream();
        this.handler = this::onMessage;
    }

    public void onMessage(Message m) throws InterruptedException {
        m.ack();
        long seq = m.metaData().streamSequence();
        long lastSeq = this.lastReceivedSequence.get();
        this.lastReceivedSequence.set(seq);
        Output.workMessage(this.label, "Last Received Seq: " + seq + "(" + lastSeq + ")");
    }

    public abstract void refreshInfo();

    @Override
    public void connectionEvent(Connection conn, ConnectionListener.Events type) {
        Output.controlMessage(this.label, "Connection: " + conn.getServerInfo().getPort() + " " + type.name().toLowerCase());
        this.refreshInfo();
    }

    protected void updateLabel(String conName) {
        if (!this.name.contains(conName)) {
            int at = this.name.lastIndexOf("-");
            this.name = this.name.substring(0, at + 1) + conName;
            this.label = this.name + " (" + this.consumerKind.name() + ")";
        }
    }

    public long getLastReceivedSequence() {
        return this.lastReceivedSequence.get();
    }

    protected ConsumerConfiguration.Builder newCreateConsumer() {
        return this.recreateConsumer(0L);
    }

    private ConsumerConfiguration.Builder recreateConsumer(long last) {
        return ConsumerConfiguration.builder().name(this.consumerKind == ConsumerKind.Ordered ? null : this.name).durable(this.durableName).deliverPolicy(last == 0L ? DeliverPolicy.All : DeliverPolicy.ByStartSequence).startSequence(last == 0L ? -1L : last + 1L).filterSubject(this.cmd.subject);
    }
}

