/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.AuthHandler;
import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.client.Nats;
import io.nats.client.ReadListener;
import io.nats.client.ReconnectDelayHandler;
import io.nats.client.ServerPool;
import io.nats.client.StatisticsCollector;
import io.nats.client.TimeTraceLogger;
import io.nats.client.impl.DataPort;
import io.nats.client.impl.DispatcherFactory;
import io.nats.client.impl.ErrorListenerLoggerImpl;
import io.nats.client.impl.SSLContextFactory;
import io.nats.client.impl.SSLContextFactoryProperties;
import io.nats.client.impl.SocketDataPort;
import io.nats.client.impl.SocketDataPortWithWriteTimeout;
import io.nats.client.support.Encoding;
import io.nats.client.support.HttpRequest;
import io.nats.client.support.NatsUri;
import io.nats.client.support.SSLUtils;
import io.nats.client.support.Validator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jspecify.annotations.NonNull;

public class Options {
    public static final String DEFAULT_URL = "nats://localhost:4222";
    public static final int DEFAULT_PORT = 4222;
    public static final int DEFAULT_MAX_RECONNECT = 60;
    public static final Duration DEFAULT_RECONNECT_WAIT = Duration.ofMillis(2000L);
    public static final Duration DEFAULT_RECONNECT_JITTER = Duration.ofMillis(100L);
    public static final Duration DEFAULT_RECONNECT_JITTER_TLS = Duration.ofMillis(1000L);
    public static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(2L);
    public static final Duration DEFAULT_SOCKET_WRITE_TIMEOUT = Duration.ofMinutes(1L);
    @Deprecated
    public static final long MINIMUM_SOCKET_WRITE_TIMEOUT_GT_CONNECTION_TIMEOUT = 100L;
    public static final long MINIMUM_SOCKET_WRITE_TIMEOUT_NANOS = 100L;
    @Deprecated
    public static final long MINIMUM_SOCKET_READ_TIMEOUT_GT_CONNECTION_TIMEOUT = 100L;
    public static final Duration DEFAULT_PING_INTERVAL = Duration.ofMinutes(2L);
    public static final Duration DEFAULT_REQUEST_CLEANUP_INTERVAL = Duration.ofSeconds(5L);
    public static final Duration DEFAULT_WRITE_QUEUE_PUSH_TIMEOUT = Duration.ofSeconds(2L);
    public static final Duration MINIMUM_WRITE_QUEUE_PUSH_TIMEOUT = Duration.ofMillis(50L);
    public static final int DEFAULT_MAX_PINGS_OUT = 2;
    public static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    public static final int DEFAULT_RECONNECT_BUF_SIZE = 0x800000;
    public static final int DEFAULT_MAX_CONTROL_LINE = 4096;
    public static final String DEFAULT_DATA_PORT_TYPE = SocketDataPort.class.getCanonicalName();
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final String DEFAULT_THREAD_NAME_PREFIX = "nats";
    public static final String DEFAULT_INBOX_PREFIX = "_INBOX.";
    public static final int MAX_MESSAGES_IN_NETWORK_BUFFER = 1000;
    public static final int DEFAULT_MAX_MESSAGES_IN_OUTGOING_QUEUE = 5000;
    public static final boolean DEFAULT_DISCARD_MESSAGES_WHEN_OUTGOING_QUEUE_FULL = false;
    public static final Supplier<ExecutorService> DEFAULT_SINGLE_THREAD_EXECUTOR = Executors::newSingleThreadExecutor;
    static final String PFX = "io.nats.client.";
    static final int PFX_LEN = "io.nats.client.".length();
    public static final String PROP_CONNECTION_CB = "io.nats.client.callback.connection";
    public static final String PROP_DATA_PORT_TYPE = "io.nats.client.dataport.type";
    public static final String PROP_ERROR_LISTENER = "io.nats.client.callback.error";
    public static final String PROP_TIME_TRACE_LOGGER = "io.nats.client.time.trace";
    public static final String PROP_STATISTICS_COLLECTOR = "io.nats.client.statisticscollector";
    public static final String PROP_MAX_PINGS = "io.nats.client.maxpings";
    public static final String PROP_PING_INTERVAL = "io.nats.client.pinginterval";
    public static final String PROP_CLEANUP_INTERVAL = "io.nats.client.cleanupinterval";
    public static final String PROP_WRITE_QUEUE_PUSH_TIMEOUT = "io.nats.client.writeQueuePushTimeout";
    public static final String PROP_CONNECTION_TIMEOUT = "io.nats.client.timeout";
    public static final String PROP_SOCKET_READ_TIMEOUT_MS = "io.nats.client.socket.read.timeout.ms";
    public static final String PROP_SOCKET_WRITE_TIMEOUT = "io.nats.client.socket.write.timeout";
    public static final String PROP_SOCKET_SO_LINGER = "io.nats.client.socket.so.linger";
    public static final String PROP_SOCKET_RECEIVE_BUFFER_SIZE = "io.nats.client.socket.receive.buffer.size";
    public static final String PROP_SOCKET_SEND_BUFFER_SIZE = "io.nats.client.socket.send.buffer.size";
    public static final String PROP_RECONNECT_BUF_SIZE = "io.nats.client.reconnect.buffer.size";
    public static final String PROP_RECONNECT_WAIT = "io.nats.client.reconnect.wait";
    public static final String PROP_MAX_RECONNECT = "io.nats.client.reconnect.max";
    public static final String PROP_RECONNECT_JITTER = "io.nats.client.reconnect.jitter";
    public static final String PROP_RECONNECT_JITTER_TLS = "io.nats.client.reconnect.jitter.tls";
    public static final String PROP_PEDANTIC = "io.nats.client.pedantic";
    public static final String PROP_VERBOSE = "io.nats.client.verbose";
    public static final String PROP_NO_ECHO = "io.nats.client.noecho";
    public static final String PROP_NO_HEADERS = "io.nats.client.noheaders";
    public static final String PROP_CONNECTION_NAME = "io.nats.client.name";
    public static final String PROP_NO_NORESPONDERS = "io.nats.client.nonoresponders";
    public static final String PROP_NORANDOMIZE = "io.nats.client.norandomize";
    public static final String PROP_NO_RESOLVE_HOSTNAMES = "io.nats.client.noResolveHostnames";
    public static final String PROP_NO_SUBJECT_VALIDATION = "io.nats.client.noSubjectValidation";
    public static final String PROP_STRICT_SUBJECT_VALIDATION = "io.nats.client.strictSubjectValidation";
    public static final String PROP_REPORT_NO_RESPONDERS = "io.nats.client.reportNoResponders";
    public static final String PROP_CLIENT_SIDE_LIMIT_CHECKS = "io.nats.client.clientsidelimitchecks";
    public static final String PROP_SERVERS = "io.nats.client.servers";
    public static final String PROP_PASSWORD = "io.nats.client.password";
    public static final String PROP_USERNAME = "io.nats.client.username";
    public static final String PROP_TOKEN = "io.nats.client.token";
    public static final String PROP_TOKEN_SUPPLIER = "io.nats.client.token.supplier";
    public static final String PROP_URL = "io.nats.client.url";
    public static final String PROP_SECURE = "io.nats.client.secure";
    public static final String PROP_OPENTLS = "io.nats.client.opentls";
    public static final String PROP_MAX_MESSAGES_IN_OUTGOING_QUEUE = "io.nats.client.outgoingqueue.maxmessages";
    public static final String PROP_DISCARD_MESSAGES_WHEN_OUTGOING_QUEUE_FULL = "io.nats.client.outgoingqueue.discardwhenfull";
    public static final String PROP_USE_OLD_REQUEST_STYLE = "use.old.request.style";
    public static final String PROP_MAX_CONTROL_LINE = "max.control.line";
    public static final String PROP_INBOX_PREFIX = "inbox.prefix";
    public static final String PROP_IGNORE_DISCOVERED_SERVERS = "ignore_discovered_servers";
    public static final String PROP_IGNORE_DISCOVERED_SERVERS_PREFERRED = "ignore.discovered.servers";
    public static final String PROP_SERVERS_POOL_IMPLEMENTATION_CLASS = "servers_pool_implementation_class";
    public static final String PROP_SERVERS_POOL_IMPLEMENTATION_CLASS_PREFERRED = "servers.pool.implementation.class";
    public static final String PROP_DISPATCHER_FACTORY_CLASS = "dispatcher.factory.class";
    public static final String PROP_SSL_CONTEXT_FACTORY_CLASS = "ssl.context.factory.class";
    public static final String PROP_KEYSTORE = "io.nats.client.keyStore";
    public static final String PROP_KEYSTORE_PASSWORD = "io.nats.client.keyStorePassword";
    public static final String PROP_TRUSTSTORE = "io.nats.client.trustStore";
    public static final String PROP_TRUSTSTORE_PASSWORD = "io.nats.client.trustStorePassword";
    public static final String PROP_TLS_ALGORITHM = "io.nats.client.tls.algorithm";
    public static final String PROP_CREDENTIAL_PATH = "io.nats.client.credential.path";
    public static final String PROP_TLS_FIRST = "io.nats.client.tls.first";
    public static final String PROP_UTF8_SUBJECTS = "allow.utf8.subjects";
    public static final String PROP_USE_TIMEOUT_EXCEPTION = "io.nats.client.use.timeout.exception";
    public static final String PROP_USE_DISPATCHER_WITH_EXECUTOR = "io.nats.client.use.dispatcher.with.executor";
    public static final String PROP_FORCE_FLUSH_ON_REQUEST = "io.nats.client.force.flush.on.request";
    public static final String PROP_EXECUTOR_SERVICE_CLASS = "executor.service.class";
    public static final String PROP_SCHEDULED_EXECUTOR_SERVICE_CLASS = "scheduled.executor.service.class";
    public static final String PROP_CONNECT_EXECUTOR_SERVICE_CLASS = "connect.executor.service.class";
    public static final String PROP_CALLBACK_EXECUTOR_SERVICE_CLASS = "callback.executor.service.class";
    public static final String PROP_CONNECT_THREAD_FACTORY_CLASS = "connect.thread.factory.class";
    public static final String PROP_CALLBACK_THREAD_FACTORY_CLASS = "callback.thread.factory.class";
    public static final String PROP_READ_LISTENER_CLASS = "read.listener.class";
    public static final String PROP_FAST_FALLBACK = "io.nats.client.fast.fallback";
    static final String OPTION_VERBOSE = "verbose";
    static final String OPTION_PEDANTIC = "pedantic";
    static final String OPTION_TLS_REQUIRED = "tls_required";
    static final String OPTION_AUTH_TOKEN = "auth_token";
    static final String OPTION_USER = "user";
    static final String OPTION_PASSWORD = "pass";
    static final String OPTION_NAME = "name";
    static final String OPTION_LANG = "lang";
    static final String OPTION_VERSION = "version";
    static final String OPTION_PROTOCOL = "protocol";
    static final String OPTION_ECHO = "echo";
    static final String OPTION_NKEY = "nkey";
    static final String OPTION_SIG = "sig";
    static final String OPTION_JWT = "jwt";
    static final String OPTION_HEADERS = "headers";
    static final String OPTION_NORESPONDERS = "no_responders";
    private final List<NatsUri> natsServerUris;
    private final List<String> unprocessedServers;
    private final boolean noRandomize;
    private final boolean noResolveHostnames;
    private final SubjectValidationType subjectValidationType;
    private final boolean reportNoResponders;
    private final String connectionName;
    private final boolean verbose;
    private final boolean pedantic;
    private final SSLContext sslContext;
    private final int maxReconnect;
    private final int maxControlLine;
    private final Duration reconnectWait;
    private final Duration reconnectJitter;
    private final Duration reconnectJitterTls;
    private final Duration connectionTimeout;
    private final int socketReadTimeoutMillis;
    private final Duration socketWriteTimeout;
    private final int socketSoLinger;
    private final int receiveBufferSize;
    private final int sendBufferSize;
    private final Duration pingInterval;
    private final Duration requestCleanupInterval;
    private final Duration writeQueuePushTimeout;
    private final int maxPingsOut;
    private final long reconnectBufferSize;
    private final char[] username;
    private final char[] password;
    private final Supplier<char[]> tokenSupplier;
    private final String inboxPrefix;
    private boolean useOldRequestStyle;
    private final int bufferSize;
    private final boolean noEcho;
    private final boolean noHeaders;
    private final boolean noNoResponders;
    private final boolean clientSideLimitChecks;
    private final boolean supportUTF8Subjects;
    private final int maxMessagesInOutgoingQueue;
    private final boolean discardMessagesWhenOutgoingQueueFull;
    private final boolean ignoreDiscoveredServers;
    private final boolean tlsFirst;
    private final boolean useTimeoutException;
    private final boolean useDispatcherWithExecutor;
    private final boolean forceFlushOnRequest;
    private final AuthHandler authHandler;
    private final ReconnectDelayHandler reconnectDelayHandler;
    private final ErrorListener errorListener;
    private final TimeTraceLogger timeTraceLogger;
    private final ConnectionListener connectionListener;
    private final ReadListener readListener;
    private final StatisticsCollector statisticsCollector;
    private final String dataPortType;
    private final boolean trackAdvancedStats;
    private final boolean traceConnection;
    private final ReentrantLock executorsLock;
    private final ExecutorService userExecutor;
    private final ScheduledExecutorService userScheduledExecutor;
    private final ThreadFactory userConnectThreadFactory;
    private final ThreadFactory userCallbackThreadFactory;
    private final ExecutorService userConnectExecutor;
    private final ExecutorService userCallbackExecutor;
    private ExecutorService resolvedExecutor;
    private ScheduledExecutorService resolvedScheduledExecutor;
    private ExecutorService resolvedConnectExecutor;
    private ExecutorService resolvedCallbackExecutor;
    private final ServerPool serverPool;
    private final DispatcherFactory dispatcherFactory;
    private final List<Consumer<HttpRequest>> httpRequestInterceptors;
    private final Proxy proxy;
    private final boolean enableFastFallback;

    @Deprecated
    public void setOldRequestStyle(boolean value) {
        this.useOldRequestStyle = value;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Options(Builder b) {
        this.natsServerUris = Collections.unmodifiableList(b.natsServerUris);
        this.unprocessedServers = Collections.unmodifiableList(b.unprocessedServers);
        this.noRandomize = b.noRandomize;
        this.noResolveHostnames = b.noResolveHostnames;
        this.subjectValidationType = b.subjectValidationType;
        this.reportNoResponders = b.reportNoResponders;
        this.connectionName = b.connectionName;
        this.verbose = b.verbose;
        this.pedantic = b.pedantic;
        this.sslContext = b.sslContext;
        this.maxReconnect = b.maxReconnect;
        this.reconnectWait = b.reconnectWait;
        this.reconnectJitter = b.reconnectJitter;
        this.reconnectJitterTls = b.reconnectJitterTls;
        this.connectionTimeout = b.connectionTimeout;
        this.socketReadTimeoutMillis = b.socketReadTimeoutMillis;
        this.socketWriteTimeout = b.socketWriteTimeout;
        this.socketSoLinger = b.socketSoLinger;
        this.receiveBufferSize = b.receiveBufferSize;
        this.sendBufferSize = b.sendBufferSize;
        this.pingInterval = b.pingInterval;
        this.requestCleanupInterval = b.requestCleanupInterval;
        this.writeQueuePushTimeout = b.writeQueuePushTimeout;
        this.maxPingsOut = b.maxPingsOut;
        this.reconnectBufferSize = b.reconnectBufferSize;
        this.username = b.username;
        this.password = b.password;
        this.tokenSupplier = b.tokenSupplier;
        this.useOldRequestStyle = b.useOldRequestStyle;
        this.maxControlLine = b.maxControlLine;
        this.bufferSize = b.bufferSize;
        this.noEcho = b.noEcho;
        this.noHeaders = b.noHeaders;
        this.noNoResponders = b.noNoResponders;
        this.clientSideLimitChecks = b.clientSideLimitChecks;
        this.supportUTF8Subjects = b.supportUTF8Subjects;
        this.inboxPrefix = b.inboxPrefix;
        this.traceConnection = b.traceConnection;
        this.maxMessagesInOutgoingQueue = b.maxMessagesInOutgoingQueue;
        this.discardMessagesWhenOutgoingQueueFull = b.discardMessagesWhenOutgoingQueueFull;
        this.authHandler = b.authHandler;
        this.reconnectDelayHandler = b.reconnectDelayHandler;
        this.errorListener = b.errorListener;
        this.timeTraceLogger = b.timeTraceLogger;
        this.connectionListener = b.connectionListener;
        this.readListener = b.readListener;
        this.statisticsCollector = b.statisticsCollector;
        this.dataPortType = b.dataPortType;
        this.trackAdvancedStats = b.trackAdvancedStats;
        this.executorsLock = new ReentrantLock();
        this.userExecutor = b.userExecutor;
        this.userScheduledExecutor = b.userScheduledExecutor;
        this.userConnectExecutor = b.userConnectExecutor;
        this.userCallbackExecutor = b.userCallbackExecutor;
        this.userCallbackThreadFactory = b.userCallbackThreadFactory;
        this.userConnectThreadFactory = b.userConnectThreadFactory;
        this.httpRequestInterceptors = b.httpRequestInterceptors;
        this.proxy = b.proxy;
        this.ignoreDiscoveredServers = b.ignoreDiscoveredServers;
        this.tlsFirst = b.tlsFirst;
        this.useTimeoutException = b.useTimeoutException;
        this.useDispatcherWithExecutor = b.useDispatcherWithExecutor;
        this.forceFlushOnRequest = b.forceFlushOnRequest;
        this.serverPool = b.serverPool;
        this.dispatcherFactory = b.dispatcherFactory;
        this.enableFastFallback = b.enableFastFallback;
    }

    public ExecutorService getExecutor() {
        this.executorsLock.lock();
        try {
            if (this.resolvedExecutor == null || this.resolvedExecutor.isShutdown()) {
                this.resolvedExecutor = this.userExecutor == null ? this._getInternalExecutor() : this.userExecutor;
            }
            ExecutorService executorService = this.resolvedExecutor;
            return executorService;
        }
        finally {
            this.executorsLock.unlock();
        }
    }

    private ExecutorService _getInternalExecutor() {
        String threadPrefix = Validator.nullOrEmpty(this.connectionName) ? DEFAULT_THREAD_NAME_PREFIX : this.connectionName;
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 500L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory(threadPrefix));
    }

    public ScheduledExecutorService getScheduledExecutor() {
        this.executorsLock.lock();
        try {
            if (this.resolvedScheduledExecutor == null || this.resolvedScheduledExecutor.isShutdown()) {
                this.resolvedScheduledExecutor = this.userScheduledExecutor == null ? this._getInternalScheduledExecutor() : this.userScheduledExecutor;
            }
            ScheduledExecutorService scheduledExecutorService = this.resolvedScheduledExecutor;
            return scheduledExecutorService;
        }
        finally {
            this.executorsLock.unlock();
        }
    }

    private ScheduledExecutorService _getInternalScheduledExecutor() {
        String threadPrefix = Validator.nullOrEmpty(this.connectionName) ? DEFAULT_THREAD_NAME_PREFIX : this.connectionName;
        ScheduledThreadPoolExecutor stpe = new ScheduledThreadPoolExecutor(3, new DefaultThreadFactory(threadPrefix));
        stpe.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        stpe.setRemoveOnCancelPolicy(true);
        return stpe;
    }

    public ExecutorService getCallbackExecutor() {
        this.executorsLock.lock();
        try {
            if (this.resolvedCallbackExecutor == null || this.resolvedCallbackExecutor.isShutdown()) {
                this.resolvedCallbackExecutor = this.userCallbackExecutor != null ? this.userCallbackExecutor : (this.userCallbackThreadFactory != null ? Executors.newSingleThreadExecutor(this.userCallbackThreadFactory) : DEFAULT_SINGLE_THREAD_EXECUTOR.get());
            }
            ExecutorService executorService = this.resolvedCallbackExecutor;
            return executorService;
        }
        finally {
            this.executorsLock.unlock();
        }
    }

    public ExecutorService getConnectExecutor() {
        this.executorsLock.lock();
        try {
            if (this.resolvedConnectExecutor == null || this.resolvedConnectExecutor.isShutdown()) {
                this.resolvedConnectExecutor = this.userConnectExecutor != null ? this.userConnectExecutor : (this.userConnectThreadFactory != null ? Executors.newSingleThreadExecutor(this.userConnectThreadFactory) : DEFAULT_SINGLE_THREAD_EXECUTOR.get());
            }
            ExecutorService executorService = this.resolvedConnectExecutor;
            return executorService;
        }
        finally {
            this.executorsLock.unlock();
        }
    }

    public boolean executorIsInternal() {
        return this.userExecutor == null;
    }

    public boolean scheduledExecutorIsInternal() {
        return this.userScheduledExecutor == null;
    }

    public boolean callbackExecutorIsInternal() {
        return this.userCallbackExecutor == null && this.userCallbackThreadFactory == null;
    }

    public boolean connectExecutorIsInternal() {
        return this.userConnectExecutor == null && this.userConnectThreadFactory == null;
    }

    public void shutdownExecutors() throws InterruptedException {
        this.executorsLock.lock();
        try {
            ExecutorService es;
            if (this.resolvedCallbackExecutor != null && this.callbackExecutorIsInternal()) {
                es = this.resolvedCallbackExecutor;
                this.resolvedCallbackExecutor = null;
                es.shutdown();
                try {
                    es.awaitTermination(this.getConnectionTimeout().toNanos(), TimeUnit.NANOSECONDS);
                }
                finally {
                    es.shutdownNow();
                }
            }
            if (this.resolvedConnectExecutor != null && this.connectExecutorIsInternal()) {
                es = this.resolvedConnectExecutor;
                this.resolvedConnectExecutor = null;
                es.shutdownNow();
            }
            if (this.resolvedExecutor != null && this.executorIsInternal()) {
                es = this.resolvedExecutor;
                this.resolvedExecutor = null;
                es.shutdownNow();
            }
            if (this.resolvedScheduledExecutor != null && this.scheduledExecutorIsInternal()) {
                ScheduledExecutorService ses = this.resolvedScheduledExecutor;
                this.resolvedScheduledExecutor = null;
                ses.shutdownNow();
            }
        }
        finally {
            this.executorsLock.unlock();
        }
    }

    public List<Consumer<HttpRequest>> getHttpRequestInterceptors() {
        return null == this.httpRequestInterceptors ? Collections.emptyList() : Collections.unmodifiableList(this.httpRequestInterceptors);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public TimeTraceLogger getTimeTraceLogger() {
        return this.timeTraceLogger;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public ReadListener getReadListener() {
        return this.readListener;
    }

    public StatisticsCollector getStatisticsCollector() {
        return this.statisticsCollector;
    }

    public AuthHandler getAuthHandler() {
        return this.authHandler;
    }

    public ReconnectDelayHandler getReconnectDelayHandler() {
        return this.reconnectDelayHandler;
    }

    public String getDataPortType() {
        return this.dataPortType;
    }

    public DataPort buildDataPort() {
        DataPort dp = this.dataPortType.equals(DEFAULT_DATA_PORT_TYPE) ? (this.socketWriteTimeout == null ? new SocketDataPort() : new SocketDataPortWithWriteTimeout()) : (DataPort)Options.createInstanceOf(this.dataPortType);
        dp.afterConstruct(this);
        return dp;
    }

    public List<URI> getServers() {
        ArrayList<URI> list = new ArrayList<URI>();
        for (NatsUri nuri : this.natsServerUris) {
            list.add(nuri.getUri());
        }
        return list;
    }

    public List<NatsUri> getNatsServerUris() {
        return this.natsServerUris;
    }

    public List<String> getUnprocessedServers() {
        return this.unprocessedServers;
    }

    public boolean isNoRandomize() {
        return this.noRandomize;
    }

    public boolean isNoResolveHostnames() {
        return this.noResolveHostnames;
    }

    public SubjectValidationType subjectValidationType() {
        return this.subjectValidationType;
    }

    public boolean isReportNoResponders() {
        return this.reportNoResponders;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isNoEcho() {
        return this.noEcho;
    }

    public boolean isNoHeaders() {
        return this.noHeaders;
    }

    public boolean isNoNoResponders() {
        return this.noNoResponders;
    }

    public boolean clientSideLimitChecks() {
        return this.clientSideLimitChecks;
    }

    public boolean supportUTF8Subjects() {
        return this.supportUTF8Subjects;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public boolean isTrackAdvancedStats() {
        return this.trackAdvancedStats;
    }

    public boolean isTraceConnection() {
        return this.traceConnection;
    }

    public int getMaxControlLine() {
        return this.maxControlLine;
    }

    public boolean isTLSRequired() {
        return this.sslContext != null;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public int getMaxReconnect() {
        return this.maxReconnect;
    }

    public Duration getReconnectWait() {
        return this.reconnectWait;
    }

    public Duration getReconnectJitter() {
        return this.reconnectJitter;
    }

    public Duration getReconnectJitterTls() {
        return this.reconnectJitterTls;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSocketReadTimeoutMillis() {
        return this.socketReadTimeoutMillis;
    }

    public Duration getSocketWriteTimeout() {
        return this.socketWriteTimeout;
    }

    public int getSocketSoLinger() {
        return this.socketSoLinger;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public Duration getPingInterval() {
        return this.pingInterval;
    }

    public Duration getRequestCleanupInterval() {
        return this.requestCleanupInterval;
    }

    public Duration getWriteQueuePushTimeout() {
        return this.writeQueuePushTimeout;
    }

    public int getMaxPingsOut() {
        return this.maxPingsOut;
    }

    public long getReconnectBufferSize() {
        return this.reconnectBufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Deprecated
    public String getUsername() {
        return this.username == null ? null : new String(this.username);
    }

    public char[] getUsernameChars() {
        return this.username;
    }

    @Deprecated
    public String getPassword() {
        return this.password == null ? null : new String(this.password);
    }

    public char[] getPasswordChars() {
        return this.password;
    }

    @Deprecated
    public String getToken() {
        char[] token = this.tokenSupplier.get();
        return token == null ? null : new String(token);
    }

    public char[] getTokenChars() {
        return this.tokenSupplier.get();
    }

    public boolean isOldRequestStyle() {
        return this.useOldRequestStyle;
    }

    public String getInboxPrefix() {
        return this.inboxPrefix;
    }

    public int getMaxMessagesInOutgoingQueue() {
        return this.maxMessagesInOutgoingQueue;
    }

    public boolean isDiscardMessagesWhenOutgoingQueueFull() {
        return this.discardMessagesWhenOutgoingQueueFull;
    }

    public boolean isIgnoreDiscoveredServers() {
        return this.ignoreDiscoveredServers;
    }

    public boolean isTlsFirst() {
        return this.tlsFirst;
    }

    public boolean useTimeoutException() {
        return this.useTimeoutException;
    }

    public boolean useDispatcherWithExecutor() {
        return this.useDispatcherWithExecutor;
    }

    public boolean forceFlushOnRequest() {
        return this.forceFlushOnRequest;
    }

    public ServerPool getServerPool() {
        return this.serverPool;
    }

    public DispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public boolean isEnableFastFallback() {
        return this.enableFastFallback;
    }

    public URI createURIForServer(String serverURI) throws URISyntaxException {
        return new NatsUri(serverURI).getUri();
    }

    public CharBuffer buildProtocolConnectOptionsString(String serverURI, boolean includeAuth, byte[] nonce) {
        CharBuffer connectString = CharBuffer.allocate(this.maxControlLine);
        connectString.append("{");
        Options.appendOption(connectString, OPTION_LANG, "java", true, false);
        Options.appendOption(connectString, OPTION_VERSION, Nats.CLIENT_VERSION, true, true);
        if (this.connectionName != null) {
            Options.appendOption(connectString, OPTION_NAME, this.connectionName, true, true);
        }
        Options.appendOption(connectString, OPTION_PROTOCOL, "1", false, true);
        Options.appendOption(connectString, OPTION_VERBOSE, String.valueOf(this.isVerbose()), false, true);
        Options.appendOption(connectString, OPTION_PEDANTIC, String.valueOf(this.isPedantic()), false, true);
        Options.appendOption(connectString, OPTION_TLS_REQUIRED, String.valueOf(this.isTLSRequired()), false, true);
        Options.appendOption(connectString, OPTION_ECHO, String.valueOf(!this.isNoEcho()), false, true);
        Options.appendOption(connectString, OPTION_HEADERS, String.valueOf(!this.isNoHeaders()), false, true);
        Options.appendOption(connectString, OPTION_NORESPONDERS, String.valueOf(!this.isNoNoResponders()), false, true);
        if (includeAuth) {
            if (nonce != null && this.getAuthHandler() != null) {
                char[] nkey = this.getAuthHandler().getID();
                byte[] sig = this.getAuthHandler().sign(nonce);
                char[] jwt = this.getAuthHandler().getJWT();
                if (sig == null) {
                    sig = new byte[]{};
                }
                if (jwt == null) {
                    jwt = new char[]{};
                }
                if (nkey == null) {
                    nkey = new char[]{};
                }
                String encodedSig = Encoding.base64UrlEncodeToString(sig);
                Options.appendOption(connectString, OPTION_NKEY, nkey, true);
                Options.appendOption(connectString, OPTION_SIG, encodedSig, true, true);
                Options.appendOption(connectString, OPTION_JWT, jwt, true);
            }
            String uriUser = null;
            String uriPass = null;
            String uriToken = null;
            try {
                URI uri = this.createURIForServer(serverURI);
                String userInfo = uri.getRawUserInfo();
                if (userInfo != null) {
                    int at = userInfo.indexOf(":");
                    if (at == -1) {
                        uriToken = Encoding.uriDecode(userInfo);
                    } else {
                        uriUser = Encoding.uriDecode(userInfo.substring(0, at));
                        uriPass = Encoding.uriDecode(userInfo.substring(at + 1));
                    }
                }
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
            if (uriUser != null) {
                Options.appendOption(connectString, OPTION_USER, Encoding.jsonEncode(uriUser), true, true);
            } else if (this.username != null) {
                Options.appendOption(connectString, OPTION_USER, Encoding.jsonEncode(this.username), true, true);
            }
            if (uriPass != null) {
                Options.appendOption(connectString, OPTION_PASSWORD, Encoding.jsonEncode(uriPass), true, true);
            } else if (this.password != null) {
                Options.appendOption(connectString, OPTION_PASSWORD, Encoding.jsonEncode(this.password), true, true);
            }
            if (uriToken != null) {
                Options.appendOption(connectString, OPTION_AUTH_TOKEN, uriToken, true, true);
            } else {
                char[] token = this.tokenSupplier.get();
                if (token != null) {
                    Options.appendOption(connectString, OPTION_AUTH_TOKEN, token, true);
                }
            }
        }
        connectString.append("}");
        connectString.flip();
        return connectString;
    }

    private static void appendOption(CharBuffer builder, String key, String value, boolean quotes, boolean comma) {
        Options._appendStart(builder, key, quotes, comma);
        builder.append(value);
        Options._appendOptionEnd(builder, quotes);
    }

    private static void appendOption(CharBuffer builder, String key, char[] value, boolean comma) {
        Options._appendStart(builder, key, true, comma);
        builder.put(value);
        Options._appendOptionEnd(builder, true);
    }

    private static void _appendStart(CharBuffer builder, String key, boolean quotes, boolean comma) {
        if (comma) {
            builder.append(',');
        }
        builder.append('\"');
        builder.append(key);
        builder.append('\"');
        builder.append(':');
        Options._appendOptionEnd(builder, quotes);
    }

    private static void _appendOptionEnd(CharBuffer builder, boolean quotes) {
        if (quotes) {
            builder.append('\"');
        }
    }

    private static String getPropertyValue(Properties props, String key) {
        String value = Validator.emptyAsNull(props.getProperty(key));
        if (value != null) {
            return value;
        }
        if (key.startsWith(PFX)) {
            return Validator.emptyAsNull(props.getProperty(key.substring(PFX_LEN)));
        }
        value = Validator.emptyAsNull(props.getProperty(PFX + key));
        if (value == null && key.contains("_")) {
            return Options.getPropertyValue(props, key.replace("_", "."));
        }
        return value;
    }

    private static void stringProperty(Properties props, String key, Consumer<String> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value != null) {
            consumer.accept(value);
        }
    }

    private static void charArrayProperty(Properties props, String key, Consumer<char[]> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value != null) {
            consumer.accept(value.toCharArray());
        }
    }

    private static void booleanProperty(Properties props, String key, Consumer<Boolean> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value != null) {
            consumer.accept(Boolean.parseBoolean(value));
        }
    }

    private static void booleanPropertyIfTrue(Properties props, String key, Consumer<Boolean> consumer) {
        if (Boolean.parseBoolean(Options.getPropertyValue(props, key))) {
            consumer.accept(true);
        }
    }

    private static void intProperty(Properties props, String key, Consumer<Integer> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value != null) {
            consumer.accept(Integer.parseInt(value));
        }
    }

    private static void intGtEqZeroProperty(Properties props, String key, Consumer<Integer> consumer) {
        int i;
        String value = Options.getPropertyValue(props, key);
        if (value != null && (i = Integer.parseInt(value)) >= 0) {
            consumer.accept(i);
        }
    }

    private static void longProperty(Properties props, String key, Consumer<Long> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value != null) {
            consumer.accept(Long.parseLong(value));
        }
    }

    private static void durationProperty(Properties props, String key, Consumer<Duration> consumer) {
        block4: {
            String value = Options.getPropertyValue(props, key);
            if (value != null) {
                try {
                    Duration d = Duration.parse(value);
                    if (d.toNanos() >= 0L) {
                        consumer.accept(d);
                    }
                }
                catch (DateTimeParseException pe) {
                    int ms = Integer.parseInt(value);
                    if (ms < 0) break block4;
                    consumer.accept(Duration.ofMillis(ms));
                }
            }
        }
    }

    private static void classnameProperty(Properties props, String key, Consumer<Object> consumer) {
        Options.stringProperty(props, key, className -> consumer.accept(Options.createInstanceOf(className)));
    }

    private static Object createInstanceOf(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class Builder {
        private final List<NatsUri> natsServerUris = new ArrayList<NatsUri>();
        private final List<String> unprocessedServers = new ArrayList<String>();
        private boolean noRandomize = false;
        private boolean noResolveHostnames = false;
        private SubjectValidationType subjectValidationType = SubjectValidationType.Lenient;
        private boolean reportNoResponders = false;
        private String connectionName = null;
        private boolean verbose = false;
        private boolean pedantic = false;
        private SSLContext sslContext = null;
        private SSLContextFactory sslContextFactory = null;
        private int maxControlLine = 4096;
        private int maxReconnect = 60;
        private Duration reconnectWait = DEFAULT_RECONNECT_WAIT;
        private Duration reconnectJitter = DEFAULT_RECONNECT_JITTER;
        private Duration reconnectJitterTls = DEFAULT_RECONNECT_JITTER_TLS;
        private Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
        private int socketReadTimeoutMillis = 0;
        private Duration socketWriteTimeout = DEFAULT_SOCKET_WRITE_TIMEOUT;
        private int socketSoLinger = -1;
        private int receiveBufferSize = -1;
        private int sendBufferSize = -1;
        private Duration pingInterval = DEFAULT_PING_INTERVAL;
        private Duration requestCleanupInterval = DEFAULT_REQUEST_CLEANUP_INTERVAL;
        private Duration writeQueuePushTimeout = DEFAULT_WRITE_QUEUE_PUSH_TIMEOUT;
        private int maxPingsOut = 2;
        private long reconnectBufferSize = 0x800000L;
        private char[] username = null;
        private char[] password = null;
        private Supplier<char[]> tokenSupplier = new DefaultTokenSupplier();
        private boolean useOldRequestStyle = false;
        private int bufferSize = 65536;
        private boolean trackAdvancedStats = false;
        private boolean traceConnection = false;
        private boolean noEcho = false;
        private boolean noHeaders = false;
        private boolean noNoResponders = false;
        private boolean clientSideLimitChecks = true;
        private boolean supportUTF8Subjects = false;
        private String inboxPrefix = "_INBOX.";
        private int maxMessagesInOutgoingQueue = 5000;
        private boolean discardMessagesWhenOutgoingQueueFull = false;
        private boolean ignoreDiscoveredServers = false;
        private boolean tlsFirst = false;
        private boolean useTimeoutException = false;
        private boolean useDispatcherWithExecutor = false;
        private boolean forceFlushOnRequest = true;
        private ServerPool serverPool = null;
        private DispatcherFactory dispatcherFactory = null;
        private AuthHandler authHandler;
        private ReconnectDelayHandler reconnectDelayHandler;
        private ErrorListener errorListener = null;
        private TimeTraceLogger timeTraceLogger = null;
        private ConnectionListener connectionListener = null;
        private ReadListener readListener = null;
        private StatisticsCollector statisticsCollector = null;
        private String dataPortType = DEFAULT_DATA_PORT_TYPE;
        private ExecutorService userExecutor;
        private ScheduledExecutorService userScheduledExecutor;
        private ExecutorService userConnectExecutor;
        private ExecutorService userCallbackExecutor;
        private ThreadFactory userConnectThreadFactory;
        private ThreadFactory userCallbackThreadFactory;
        private List<Consumer<HttpRequest>> httpRequestInterceptors;
        private Proxy proxy;
        private boolean useDefaultTls;
        private boolean useTrustAllTls;
        private String keystore;
        private char[] keystorePassword;
        private String truststore;
        private char[] truststorePassword;
        private String tlsAlgorithm = "SunX509";
        private String credentialPath;
        private boolean enableFastFallback = false;

        public Builder() {
        }

        public Builder(Properties props) throws IllegalArgumentException {
            this.properties(props);
        }

        public Builder(String propertiesFilePath) throws IOException {
            Properties props = new Properties();
            props.load(Files.newInputStream(Paths.get(propertiesFilePath, new String[0]), new OpenOption[0]));
            this.properties(props);
        }

        public Builder properties(Properties props) {
            if (props == null) {
                throw new IllegalArgumentException("Properties cannot be null");
            }
            Options.stringProperty(props, Options.PROP_URL, this::server);
            Options.stringProperty(props, Options.PROP_SERVERS, str -> {
                String[] servers = str.trim().split(",\\s*");
                this.servers(servers);
            });
            Options.charArrayProperty(props, Options.PROP_USERNAME, ca -> {
                this.username = ca;
            });
            Options.charArrayProperty(props, Options.PROP_PASSWORD, ca -> {
                this.password = ca;
            });
            Options.charArrayProperty(props, Options.PROP_TOKEN, ca -> {
                this.tokenSupplier = new DefaultTokenSupplier((char[])ca);
            });
            Options.classnameProperty(props, Options.PROP_TOKEN_SUPPLIER, o -> {
                this.tokenSupplier = (Supplier)o;
            });
            Options.booleanProperty(props, Options.PROP_SECURE, b -> {
                this.useDefaultTls = b;
            });
            Options.booleanProperty(props, Options.PROP_OPENTLS, b -> {
                this.useTrustAllTls = b;
            });
            Options.classnameProperty(props, Options.PROP_SSL_CONTEXT_FACTORY_CLASS, o -> {
                this.sslContextFactory = (SSLContextFactory)o;
            });
            Options.stringProperty(props, Options.PROP_KEYSTORE, s -> {
                this.keystore = s;
            });
            Options.charArrayProperty(props, Options.PROP_KEYSTORE_PASSWORD, ca -> {
                this.keystorePassword = ca;
            });
            Options.stringProperty(props, Options.PROP_TRUSTSTORE, s -> {
                this.truststore = s;
            });
            Options.charArrayProperty(props, Options.PROP_TRUSTSTORE_PASSWORD, ca -> {
                this.truststorePassword = ca;
            });
            Options.stringProperty(props, Options.PROP_TLS_ALGORITHM, s -> {
                this.tlsAlgorithm = s;
            });
            Options.stringProperty(props, Options.PROP_CREDENTIAL_PATH, s -> {
                this.credentialPath = s;
            });
            Options.stringProperty(props, Options.PROP_CONNECTION_NAME, s -> {
                this.connectionName = s;
            });
            Options.booleanProperty(props, Options.PROP_NORANDOMIZE, b -> {
                this.noRandomize = b;
            });
            Options.booleanProperty(props, Options.PROP_NO_RESOLVE_HOSTNAMES, b -> {
                this.noResolveHostnames = b;
            });
            Options.booleanPropertyIfTrue(props, Options.PROP_NO_SUBJECT_VALIDATION, b -> {
                this.subjectValidationType = SubjectValidationType.None;
            });
            Options.booleanPropertyIfTrue(props, Options.PROP_STRICT_SUBJECT_VALIDATION, b -> {
                this.subjectValidationType = SubjectValidationType.Strict;
            });
            Options.booleanProperty(props, Options.PROP_REPORT_NO_RESPONDERS, b -> {
                this.reportNoResponders = b;
            });
            Options.stringProperty(props, Options.PROP_CONNECTION_NAME, s -> {
                this.connectionName = s;
            });
            Options.booleanProperty(props, Options.PROP_VERBOSE, b -> {
                this.verbose = b;
            });
            Options.booleanProperty(props, Options.PROP_NO_ECHO, b -> {
                this.noEcho = b;
            });
            Options.booleanProperty(props, Options.PROP_NO_HEADERS, b -> {
                this.noHeaders = b;
            });
            Options.booleanProperty(props, Options.PROP_NO_NORESPONDERS, b -> {
                this.noNoResponders = b;
            });
            Options.booleanProperty(props, Options.PROP_CLIENT_SIDE_LIMIT_CHECKS, b -> {
                this.clientSideLimitChecks = b;
            });
            Options.booleanProperty(props, Options.PROP_UTF8_SUBJECTS, b -> {
                this.supportUTF8Subjects = b;
            });
            Options.booleanProperty(props, Options.PROP_PEDANTIC, b -> {
                this.pedantic = b;
            });
            Options.intProperty(props, Options.PROP_MAX_RECONNECT, i -> {
                this.maxReconnect = i;
            });
            Options.durationProperty(props, Options.PROP_RECONNECT_WAIT, d -> {
                this.reconnectWait = d;
            });
            Options.durationProperty(props, Options.PROP_RECONNECT_JITTER, d -> {
                this.reconnectJitter = d;
            });
            Options.durationProperty(props, Options.PROP_RECONNECT_JITTER_TLS, d -> {
                this.reconnectJitterTls = d;
            });
            Options.longProperty(props, Options.PROP_RECONNECT_BUF_SIZE, l -> {
                this.reconnectBufferSize = l;
            });
            Options.durationProperty(props, Options.PROP_CONNECTION_TIMEOUT, d -> {
                this.connectionTimeout = d;
            });
            Options.intProperty(props, Options.PROP_SOCKET_READ_TIMEOUT_MS, i -> {
                this.socketReadTimeoutMillis = i;
            });
            Options.durationProperty(props, Options.PROP_SOCKET_WRITE_TIMEOUT, d -> {
                this.socketWriteTimeout = d;
            });
            Options.intProperty(props, Options.PROP_SOCKET_SO_LINGER, i -> {
                this.socketSoLinger = i;
            });
            Options.intProperty(props, Options.PROP_SOCKET_RECEIVE_BUFFER_SIZE, i -> {
                this.receiveBufferSize = i;
            });
            Options.intProperty(props, Options.PROP_SOCKET_SEND_BUFFER_SIZE, i -> {
                this.sendBufferSize = i;
            });
            Options.intGtEqZeroProperty(props, Options.PROP_MAX_CONTROL_LINE, i -> {
                this.maxControlLine = i;
            });
            Options.durationProperty(props, Options.PROP_PING_INTERVAL, d -> {
                this.pingInterval = d;
            });
            Options.durationProperty(props, Options.PROP_CLEANUP_INTERVAL, d -> {
                this.requestCleanupInterval = d;
            });
            Options.durationProperty(props, Options.PROP_WRITE_QUEUE_PUSH_TIMEOUT, d -> {
                this.writeQueuePushTimeout = d;
            });
            Options.intProperty(props, Options.PROP_MAX_PINGS, i -> {
                this.maxPingsOut = i;
            });
            Options.booleanProperty(props, Options.PROP_USE_OLD_REQUEST_STYLE, b -> {
                this.useOldRequestStyle = b;
            });
            Options.classnameProperty(props, Options.PROP_ERROR_LISTENER, o -> {
                this.errorListener = (ErrorListener)o;
            });
            Options.classnameProperty(props, Options.PROP_TIME_TRACE_LOGGER, o -> {
                this.timeTraceLogger = (TimeTraceLogger)o;
            });
            Options.classnameProperty(props, Options.PROP_CONNECTION_CB, o -> {
                this.connectionListener = (ConnectionListener)o;
            });
            Options.classnameProperty(props, Options.PROP_READ_LISTENER_CLASS, o -> {
                this.readListener = (ReadListener)o;
            });
            Options.classnameProperty(props, Options.PROP_STATISTICS_COLLECTOR, o -> {
                this.statisticsCollector = (StatisticsCollector)o;
            });
            Options.stringProperty(props, Options.PROP_DATA_PORT_TYPE, s -> {
                this.dataPortType = s;
            });
            Options.stringProperty(props, Options.PROP_INBOX_PREFIX, this::inboxPrefix);
            Options.intGtEqZeroProperty(props, Options.PROP_MAX_MESSAGES_IN_OUTGOING_QUEUE, i -> {
                this.maxMessagesInOutgoingQueue = i;
            });
            Options.booleanProperty(props, Options.PROP_DISCARD_MESSAGES_WHEN_OUTGOING_QUEUE_FULL, b -> {
                this.discardMessagesWhenOutgoingQueueFull = b;
            });
            Options.booleanProperty(props, Options.PROP_IGNORE_DISCOVERED_SERVERS, b -> {
                this.ignoreDiscoveredServers = b;
            });
            Options.booleanProperty(props, Options.PROP_TLS_FIRST, b -> {
                this.tlsFirst = b;
            });
            Options.booleanProperty(props, Options.PROP_USE_TIMEOUT_EXCEPTION, b -> {
                this.useTimeoutException = b;
            });
            Options.booleanProperty(props, Options.PROP_USE_DISPATCHER_WITH_EXECUTOR, b -> {
                this.useDispatcherWithExecutor = b;
            });
            Options.booleanProperty(props, Options.PROP_FORCE_FLUSH_ON_REQUEST, b -> {
                this.forceFlushOnRequest = b;
            });
            Options.booleanProperty(props, Options.PROP_FAST_FALLBACK, b -> {
                this.enableFastFallback = b;
            });
            Options.classnameProperty(props, Options.PROP_SERVERS_POOL_IMPLEMENTATION_CLASS, o -> {
                this.serverPool = (ServerPool)o;
            });
            Options.classnameProperty(props, Options.PROP_DISPATCHER_FACTORY_CLASS, o -> {
                this.dispatcherFactory = (DispatcherFactory)o;
            });
            Options.classnameProperty(props, Options.PROP_EXECUTOR_SERVICE_CLASS, o -> {
                this.userExecutor = (ExecutorService)o;
            });
            Options.classnameProperty(props, Options.PROP_CONNECT_EXECUTOR_SERVICE_CLASS, o -> {
                this.userConnectExecutor = (ExecutorService)o;
            });
            Options.classnameProperty(props, Options.PROP_CALLBACK_EXECUTOR_SERVICE_CLASS, o -> {
                this.userCallbackExecutor = (ExecutorService)o;
            });
            Options.classnameProperty(props, Options.PROP_SCHEDULED_EXECUTOR_SERVICE_CLASS, o -> {
                this.userScheduledExecutor = (ScheduledExecutorService)o;
            });
            Options.classnameProperty(props, Options.PROP_CONNECT_THREAD_FACTORY_CLASS, o -> {
                this.userConnectThreadFactory = (ThreadFactory)o;
            });
            Options.classnameProperty(props, Options.PROP_CALLBACK_THREAD_FACTORY_CLASS, o -> {
                this.userCallbackThreadFactory = (ThreadFactory)o;
            });
            return this;
        }

        public Builder server(String serverURL) {
            return this.servers(serverURL.trim().split(","));
        }

        public Builder servers(String[] servers) {
            for (String s : servers) {
                if (s == null || s.isEmpty()) continue;
                try {
                    String unprocessed = s.trim();
                    NatsUri nuri = new NatsUri(unprocessed);
                    if (this.natsServerUris.contains(nuri)) continue;
                    this.natsServerUris.add(nuri);
                    this.unprocessedServers.add(unprocessed);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return this;
        }

        public Builder oldRequestStyle() {
            this.useOldRequestStyle = true;
            return this;
        }

        public Builder noRandomize() {
            this.noRandomize = true;
            return this;
        }

        public Builder noResolveHostnames() {
            this.noResolveHostnames = true;
            return this;
        }

        public Builder noSubjectValidation() {
            this.subjectValidationType = SubjectValidationType.None;
            return this;
        }

        public Builder strictSubjectValidation() {
            this.subjectValidationType = SubjectValidationType.Strict;
            return this;
        }

        public Builder subjectValidationType(SubjectValidationType subjectValidationType) {
            this.subjectValidationType = subjectValidationType == null ? SubjectValidationType.Lenient : subjectValidationType;
            return this;
        }

        public Builder reportNoResponders() {
            this.reportNoResponders = true;
            return this;
        }

        public Builder noEcho() {
            this.noEcho = true;
            return this;
        }

        public Builder noHeaders() {
            this.noHeaders = true;
            return this;
        }

        public Builder noNoResponders() {
            this.noNoResponders = true;
            return this;
        }

        public Builder clientSideLimitChecks(boolean checks) {
            this.clientSideLimitChecks = checks;
            return this;
        }

        public Builder supportUTF8Subjects() {
            this.supportUTF8Subjects = true;
            return this;
        }

        public Builder connectionName(String name) {
            this.connectionName = name;
            return this;
        }

        public Builder inboxPrefix(String prefix) {
            this.inboxPrefix = prefix;
            if (!this.inboxPrefix.endsWith(".")) {
                this.inboxPrefix = this.inboxPrefix + ".";
            }
            return this;
        }

        public Builder verbose() {
            this.verbose = true;
            return this;
        }

        public Builder pedantic() {
            this.pedantic = true;
            return this;
        }

        public Builder turnOnAdvancedStats() {
            this.trackAdvancedStats = true;
            return this;
        }

        public Builder traceConnection() {
            this.traceConnection = true;
            return this;
        }

        public Builder secure() throws NoSuchAlgorithmException {
            this.useDefaultTls = true;
            return this;
        }

        public Builder opentls() throws NoSuchAlgorithmException {
            this.useTrustAllTls = true;
            return this;
        }

        public Builder sslContext(SSLContext ctx) {
            this.sslContext = ctx;
            return this;
        }

        public Builder sslContextFactory(SSLContextFactory sslContextFactory) {
            this.sslContextFactory = sslContextFactory;
            return this;
        }

        public Builder keystorePath(String keystore) {
            this.keystore = Validator.emptyAsNull(keystore);
            return this;
        }

        public Builder keystorePassword(char[] keystorePassword) {
            this.keystorePassword = keystorePassword == null || keystorePassword.length == 0 ? null : keystorePassword;
            return this;
        }

        public Builder truststorePath(String truststore) {
            this.truststore = Validator.emptyAsNull(truststore);
            return this;
        }

        public Builder truststorePassword(char[] truststorePassword) {
            this.truststorePassword = truststorePassword == null || truststorePassword.length == 0 ? null : truststorePassword;
            return this;
        }

        public Builder tlsAlgorithm(String tlsAlgorithm) {
            this.tlsAlgorithm = Validator.emptyOrNullAs(tlsAlgorithm, "SunX509");
            return this;
        }

        public Builder credentialPath(String credentialPath) {
            this.credentialPath = Validator.emptyAsNull(credentialPath);
            return this;
        }

        public Builder noReconnect() {
            this.maxReconnect = 0;
            return this;
        }

        public Builder maxReconnects(int max) {
            this.maxReconnect = max;
            return this;
        }

        public Builder reconnectWait(Duration time) {
            this.reconnectWait = time;
            return this;
        }

        public Builder reconnectJitter(Duration time) {
            this.reconnectJitter = time;
            return this;
        }

        public Builder reconnectJitterTls(Duration time) {
            this.reconnectJitterTls = time;
            return this;
        }

        public Builder maxControlLine(int bytes) {
            this.maxControlLine = bytes < 0 ? 4096 : bytes;
            return this;
        }

        public Builder connectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder connectionTimeout(long connectionTimeoutMillis) {
            this.connectionTimeout = Duration.ofMillis(connectionTimeoutMillis);
            return this;
        }

        public Builder socketReadTimeoutMillis(int socketReadTimeoutMillis) {
            this.socketReadTimeoutMillis = socketReadTimeoutMillis;
            return this;
        }

        public Builder socketWriteTimeout(long socketWriteTimeoutMillis) {
            this.socketWriteTimeout = Duration.ofMillis(socketWriteTimeoutMillis);
            return this;
        }

        public Builder socketWriteTimeout(Duration socketWriteTimeout) {
            this.socketWriteTimeout = socketWriteTimeout;
            return this;
        }

        public Builder socketSoLinger(int socketSoLinger) {
            this.socketSoLinger = socketSoLinger;
            return this;
        }

        public Builder receiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return this;
        }

        public Builder sendBufferSize(int sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
            return this;
        }

        public Builder pingInterval(Duration time) {
            this.pingInterval = time == null ? DEFAULT_PING_INTERVAL : time;
            return this;
        }

        public Builder requestCleanupInterval(Duration time) {
            this.requestCleanupInterval = time;
            return this;
        }

        public Builder writeQueuePushTimeout(Duration time) {
            this.writeQueuePushTimeout = time;
            return this;
        }

        public Builder maxPingsOut(int max) {
            this.maxPingsOut = max;
            return this;
        }

        public Builder bufferSize(int size) {
            this.bufferSize = size;
            return this;
        }

        public Builder reconnectBufferSize(long size) {
            this.reconnectBufferSize = size;
            return this;
        }

        public Builder userInfo(String userName, String password) {
            this.username = userName.toCharArray();
            this.password = password.toCharArray();
            return this;
        }

        public Builder userInfo(char[] userName, char[] password) {
            this.username = userName;
            this.password = password;
            return this;
        }

        @Deprecated
        public Builder token(String token) {
            this.tokenSupplier = new DefaultTokenSupplier(token);
            return this;
        }

        public Builder token(char[] token) {
            this.tokenSupplier = new DefaultTokenSupplier(token);
            return this;
        }

        public Builder tokenSupplier(Supplier<char[]> tokenSupplier) {
            this.tokenSupplier = tokenSupplier == null ? new DefaultTokenSupplier() : tokenSupplier;
            return this;
        }

        public Builder authHandler(AuthHandler handler) {
            this.authHandler = handler;
            return this;
        }

        public Builder reconnectDelayHandler(ReconnectDelayHandler handler) {
            this.reconnectDelayHandler = handler;
            return this;
        }

        public Builder errorListener(ErrorListener listener) {
            this.errorListener = listener;
            return this;
        }

        public Builder timeTraceLogger(TimeTraceLogger logger) {
            this.timeTraceLogger = logger;
            return this;
        }

        public Builder connectionListener(ConnectionListener listener) {
            this.connectionListener = listener;
            return this;
        }

        public Builder readListener(ReadListener readListener) {
            this.readListener = readListener;
            return this;
        }

        public Builder statisticsCollector(StatisticsCollector collector) {
            this.statisticsCollector = collector;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.userExecutor = executor;
            return this;
        }

        public Builder scheduledExecutor(ScheduledExecutorService scheduledExecutor) {
            this.userScheduledExecutor = scheduledExecutor;
            return this;
        }

        public Builder connectExecutor(ExecutorService connectExecutor) {
            this.userConnectExecutor = connectExecutor;
            return this;
        }

        public Builder callbackExecutor(ExecutorService callbackExecutor) {
            this.userCallbackExecutor = callbackExecutor;
            return this;
        }

        public Builder connectThreadFactory(ThreadFactory threadFactory) {
            this.userConnectThreadFactory = threadFactory;
            return this;
        }

        public Builder callbackThreadFactory(ThreadFactory threadFactory) {
            this.userCallbackThreadFactory = threadFactory;
            return this;
        }

        public Builder httpRequestInterceptor(Consumer<HttpRequest> interceptor) {
            if (null == this.httpRequestInterceptors) {
                this.httpRequestInterceptors = new ArrayList<Consumer<HttpRequest>>();
            }
            this.httpRequestInterceptors.add(interceptor);
            return this;
        }

        public Builder httpRequestInterceptors(Collection<? extends Consumer<HttpRequest>> interceptors) {
            this.httpRequestInterceptors = new ArrayList<Consumer<HttpRequest>>(interceptors);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder dataPortType(String dataPortClassName) {
            this.dataPortType = dataPortClassName == null ? DEFAULT_DATA_PORT_TYPE : dataPortClassName;
            return this;
        }

        public Builder maxMessagesInOutgoingQueue(int maxMessagesInOutgoingQueue) {
            this.maxMessagesInOutgoingQueue = maxMessagesInOutgoingQueue < 0 ? 5000 : maxMessagesInOutgoingQueue;
            return this;
        }

        public Builder discardMessagesWhenOutgoingQueueFull() {
            this.discardMessagesWhenOutgoingQueueFull = true;
            return this;
        }

        public Builder ignoreDiscoveredServers() {
            this.ignoreDiscoveredServers = true;
            return this;
        }

        public Builder tlsFirst() {
            this.tlsFirst = true;
            return this;
        }

        public Builder useTimeoutException() {
            this.useTimeoutException = true;
            return this;
        }

        public Builder useDispatcherWithExecutor() {
            this.useDispatcherWithExecutor = true;
            return this;
        }

        public Builder dontForceFlushOnRequest() {
            this.forceFlushOnRequest = false;
            return this;
        }

        public Builder serverPool(ServerPool serverPool) {
            this.serverPool = serverPool;
            return this;
        }

        public Builder dispatcherFactory(DispatcherFactory dispatcherFactory) {
            this.dispatcherFactory = dispatcherFactory;
            return this;
        }

        public Builder enableFastFallback() {
            this.enableFastFallback = true;
            return this;
        }

        public Options build() throws IllegalStateException {
            if (this.username != null && this.tokenSupplier.get() != null) {
                throw new IllegalStateException("Options can't have token and username");
            }
            if (this.inboxPrefix == null) {
                this.inboxPrefix = Options.DEFAULT_INBOX_PREFIX;
            }
            boolean checkUrisForSecure = true;
            if (this.natsServerUris.isEmpty()) {
                this.server(Options.DEFAULT_URL);
                checkUrisForSecure = false;
            }
            if (this.sslContext == null) {
                if (this.sslContextFactory != null) {
                    this.sslContext = this.sslContextFactory.createSSLContext(new SSLContextFactoryProperties.Builder().keystore(this.keystore).keystorePassword(this.keystorePassword).truststore(this.truststore).truststorePassword(this.truststorePassword).tlsAlgorithm(this.tlsAlgorithm).build());
                } else {
                    if (this.keystore != null || this.truststore != null) {
                        try {
                            this.sslContext = SSLUtils.createSSLContext(this.keystore, this.keystorePassword, this.truststore, this.truststorePassword, this.tlsAlgorithm);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Unable to create SSL context", e);
                        }
                    }
                    if (!this.useDefaultTls && !this.useTrustAllTls && checkUrisForSecure) {
                        block15: for (int i = 0; this.sslContext == null && i < this.natsServerUris.size(); ++i) {
                            NatsUri natsUri = this.natsServerUris.get(i);
                            switch (natsUri.getScheme()) {
                                case "tls": 
                                case "wss": {
                                    this.useDefaultTls = true;
                                    continue block15;
                                }
                                case "opentls": {
                                    this.useTrustAllTls = true;
                                }
                            }
                        }
                    }
                    if (this.useTrustAllTls) {
                        try {
                            this.sslContext = SSLUtils.createTrustAllTlsContext();
                        }
                        catch (GeneralSecurityException e) {
                            throw new IllegalStateException("Unable to create SSL context", e);
                        }
                    }
                    if (this.useDefaultTls) {
                        try {
                            this.sslContext = SSLContext.getDefault();
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new IllegalStateException("Unable to create default SSL context", e);
                        }
                    }
                }
            }
            if (this.tlsFirst && this.sslContext == null) {
                throw new IllegalStateException("SSL context required for tls handshake first");
            }
            if (this.credentialPath != null) {
                File file = new File(this.credentialPath).getAbsoluteFile();
                this.authHandler = Nats.credentials(file.toString());
            }
            if (this.socketReadTimeoutMillis < 1) {
                this.socketReadTimeoutMillis = 0;
            }
            if (this.socketWriteTimeout != null && this.socketWriteTimeout.toNanos() < 100L) {
                throw new IllegalArgumentException("Socket Write Timeout cannot be less than 100 nanoseconds.");
            }
            if (this.socketSoLinger < 1) {
                this.socketSoLinger = -1;
            }
            if (this.receiveBufferSize < 1) {
                this.receiveBufferSize = -1;
            }
            if (this.sendBufferSize < 1) {
                this.sendBufferSize = -1;
            }
            if (this.errorListener == null) {
                this.errorListener = new ErrorListenerLoggerImpl();
            }
            if (this.timeTraceLogger == null) {
                this.timeTraceLogger = this.traceConnection ? (format, args) -> {
                    String timeStr = DateTimeFormatter.ISO_TIME.format(LocalDateTime.now());
                    System.out.println("[" + timeStr + "] connect trace: " + String.format(format, args));
                } : (f, a) -> {};
            } else {
                this.traceConnection = true;
            }
            return new Options(this);
        }

        public Builder(Options o) {
            if (o == null) {
                throw new IllegalArgumentException("Options cannot be null");
            }
            this.natsServerUris.addAll(o.natsServerUris);
            this.unprocessedServers.addAll(o.unprocessedServers);
            this.noRandomize = o.noRandomize;
            this.noResolveHostnames = o.noResolveHostnames;
            this.subjectValidationType = o.subjectValidationType;
            this.reportNoResponders = o.reportNoResponders;
            this.connectionName = o.connectionName;
            this.verbose = o.verbose;
            this.pedantic = o.pedantic;
            this.sslContext = o.sslContext;
            this.maxReconnect = o.maxReconnect;
            this.reconnectWait = o.reconnectWait;
            this.reconnectJitter = o.reconnectJitter;
            this.reconnectJitterTls = o.reconnectJitterTls;
            this.connectionTimeout = o.connectionTimeout;
            this.socketReadTimeoutMillis = o.socketReadTimeoutMillis;
            this.socketWriteTimeout = o.socketWriteTimeout;
            this.socketSoLinger = o.socketSoLinger;
            this.receiveBufferSize = o.receiveBufferSize;
            this.sendBufferSize = o.sendBufferSize;
            this.pingInterval = o.pingInterval;
            this.requestCleanupInterval = o.requestCleanupInterval;
            this.writeQueuePushTimeout = o.writeQueuePushTimeout;
            this.maxPingsOut = o.maxPingsOut;
            this.reconnectBufferSize = o.reconnectBufferSize;
            this.username = o.username;
            this.password = o.password;
            this.tokenSupplier = o.tokenSupplier;
            this.useOldRequestStyle = o.useOldRequestStyle;
            this.maxControlLine = o.maxControlLine;
            this.bufferSize = o.bufferSize;
            this.noEcho = o.noEcho;
            this.noHeaders = o.noHeaders;
            this.noNoResponders = o.noNoResponders;
            this.clientSideLimitChecks = o.clientSideLimitChecks;
            this.supportUTF8Subjects = o.supportUTF8Subjects;
            this.inboxPrefix = o.inboxPrefix;
            this.traceConnection = o.traceConnection;
            this.maxMessagesInOutgoingQueue = o.maxMessagesInOutgoingQueue;
            this.discardMessagesWhenOutgoingQueueFull = o.discardMessagesWhenOutgoingQueueFull;
            this.authHandler = o.authHandler;
            this.reconnectDelayHandler = o.reconnectDelayHandler;
            this.errorListener = o.errorListener;
            this.timeTraceLogger = o.timeTraceLogger;
            this.connectionListener = o.connectionListener;
            this.readListener = o.readListener;
            this.statisticsCollector = o.statisticsCollector;
            this.dataPortType = o.dataPortType;
            this.trackAdvancedStats = o.trackAdvancedStats;
            this.userExecutor = o.userExecutor;
            this.userScheduledExecutor = o.userScheduledExecutor;
            this.userConnectExecutor = o.userConnectExecutor;
            this.userCallbackExecutor = o.userCallbackExecutor;
            this.userCallbackThreadFactory = o.userCallbackThreadFactory;
            this.userConnectThreadFactory = o.userConnectThreadFactory;
            this.httpRequestInterceptors = o.httpRequestInterceptors;
            this.proxy = o.proxy;
            this.ignoreDiscoveredServers = o.ignoreDiscoveredServers;
            this.tlsFirst = o.tlsFirst;
            this.useTimeoutException = o.useTimeoutException;
            this.useDispatcherWithExecutor = o.useDispatcherWithExecutor;
            this.forceFlushOnRequest = o.forceFlushOnRequest;
            this.serverPool = o.serverPool;
            this.dispatcherFactory = o.dispatcherFactory;
            this.enableFastFallback = o.enableFastFallback;
        }
    }

    static class DefaultTokenSupplier
    implements Supplier<char[]> {
        final char[] token;

        public DefaultTokenSupplier() {
            this.token = null;
        }

        public DefaultTokenSupplier(char[] token) {
            this.token = token == null || token.length == 0 ? null : token;
        }

        public DefaultTokenSupplier(String token) {
            token = Validator.emptyAsNull(token);
            this.token = token == null ? null : token.toCharArray();
        }

        @Override
        public char[] get() {
            return this.token;
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        final String name;
        final AtomicInteger threadNumber;

        public DefaultThreadFactory(String name) {
            this.name = name;
            this.threadNumber = new AtomicInteger(0);
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            String threadName = this.name + ":" + this.threadNumber.incrementAndGet();
            Thread t = new Thread(r, threadName);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    public static enum SubjectValidationType {
        None,
        Lenient,
        Strict;

    }
}

