/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.ObjectLink;
import io.nats.client.api.ObjectMetaOptions;
import io.nats.client.impl.Headers;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ObjectMeta
implements JsonSerializable {
    private final String objectName;
    private final String description;
    private final Headers headers;
    private final Map<String, String> metadata;
    private final ObjectMetaOptions objectMetaOptions;

    private ObjectMeta(Builder b) {
        this.objectName = b.objectName;
        this.description = b.description;
        this.headers = new Headers(b.headers, true);
        this.metadata = Collections.unmodifiableMap(b.metadata);
        this.objectMetaOptions = b.metaOptionsBuilder.build();
    }

    ObjectMeta(JsonValue vObjectMeta) {
        this.objectName = JsonValueUtils.readString(vObjectMeta, "name");
        this.description = JsonValueUtils.readString(vObjectMeta, "description");
        Headers h = new Headers();
        JsonValue hJv = JsonValueUtils.readObject(vObjectMeta, "headers");
        for (String key : hJv.map.keySet()) {
            h.put(key, JsonValueUtils.readStringList(hJv, key));
        }
        this.headers = new Headers(h, true);
        Map<String, String> meta = JsonValueUtils.readStringStringMap(vObjectMeta, "metadata");
        this.metadata = meta == null ? Collections.unmodifiableMap(new HashMap()) : Collections.unmodifiableMap(meta);
        this.objectMetaOptions = new ObjectMetaOptions(JsonValueUtils.readObject(vObjectMeta, "options"));
    }

    @Override
    public @NonNull String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        this.embedJson(sb);
        return JsonUtils.endJson(sb).toString();
    }

    void embedJson(StringBuilder sb) {
        JsonUtils.addField(sb, "name", this.objectName);
        JsonUtils.addField(sb, "description", this.description);
        JsonUtils.addField(sb, "headers", this.headers);
        JsonUtils.addField(sb, "metadata", this.metadata);
        if (this.objectMetaOptions.hasData()) {
            JsonUtils.addField(sb, "options", this.objectMetaOptions);
        }
    }

    public @NonNull String getObjectName() {
        return this.objectName;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public @NonNull Headers getHeaders() {
        return this.headers;
    }

    public @NonNull Map<String, String> getMetadata() {
        return this.metadata;
    }

    public @Nullable ObjectMetaOptions getObjectMetaOptions() {
        return this.objectMetaOptions;
    }

    public static Builder builder(String objectName) {
        return new Builder(objectName);
    }

    public static Builder builder(ObjectMeta om) {
        return new Builder(om);
    }

    public static ObjectMeta objectName(String objectName) {
        return new Builder(objectName).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectMeta that = (ObjectMeta)o;
        if (!this.objectName.equals(that.objectName)) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return this.objectMetaOptions.equals(that.objectMetaOptions);
    }

    public int hashCode() {
        int result = this.objectName.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + this.metadata.hashCode();
        result = 31 * result + this.objectMetaOptions.hashCode();
        return result;
    }

    public String toString() {
        return "ObjectMeta{objectName='" + this.objectName + '\'' + ", description='" + this.description + '\'' + ", headers?" + this.headers.size() + ", metadata?" + this.metadata.size() + ", objectMetaOptions=" + this.objectMetaOptions + '}';
    }

    public static class Builder {
        String objectName;
        String description;
        Headers headers;
        Map<String, String> metadata;
        ObjectMetaOptions.Builder metaOptionsBuilder;

        public Builder(String objectName) {
            this.headers = new Headers();
            this.metadata = new HashMap<String, String>();
            this.metaOptionsBuilder = ObjectMetaOptions.builder();
            this.objectName(objectName);
        }

        public Builder(ObjectMeta om) {
            this.objectName = om.objectName;
            this.description = om.description;
            this.headers = new Headers(om.headers);
            this.metadata = new HashMap<String, String>(om.metadata);
            this.metaOptionsBuilder = ObjectMetaOptions.builder(om.objectMetaOptions);
        }

        public Builder objectName(String name) {
            this.objectName = Validator.validateNotNull(name, "Object Name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder headers(Headers headers) {
            if (headers == null) {
                this.headers.clear();
            } else {
                this.headers = new Headers(headers);
            }
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            if (metadata == null) {
                this.metadata.clear();
            } else {
                this.metadata = metadata;
            }
            return this;
        }

        public Builder options(ObjectMetaOptions objectMetaOptions) {
            this.metaOptionsBuilder = ObjectMetaOptions.builder(objectMetaOptions);
            return this;
        }

        public Builder chunkSize(int chunkSize) {
            this.metaOptionsBuilder.chunkSize(chunkSize);
            return this;
        }

        public Builder link(ObjectLink link) {
            this.metaOptionsBuilder.link(link);
            return this;
        }

        public ObjectMeta build() {
            return new ObjectMeta(this);
        }
    }
}

