/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.ObjectStoreConfiguration;
import io.nats.client.api.Placement;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamInfo;
import io.nats.client.support.JsonValueUtils;
import java.time.Duration;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ObjectStoreStatus {
    private final StreamInfo streamInfo;
    private final ObjectStoreConfiguration config;

    public ObjectStoreStatus(StreamInfo si) {
        this.streamInfo = si;
        this.config = new ObjectStoreConfiguration(this.streamInfo.getConfiguration());
    }

    public @NonNull String getBucketName() {
        return this.config.getBucketName();
    }

    public @Nullable String getDescription() {
        return this.config.getDescription();
    }

    public @NonNull StreamInfo getBackingStreamInfo() {
        return this.streamInfo;
    }

    public @NonNull ObjectStoreConfiguration getConfiguration() {
        return this.config;
    }

    public long getSize() {
        return this.streamInfo.getStreamState().getByteCount();
    }

    public long getMaxBucketSize() {
        return this.config.getMaxBucketSize();
    }

    public boolean isSealed() {
        return this.config.isSealed();
    }

    public @Nullable Duration getTtl() {
        return this.config.getTtl();
    }

    public @NonNull StorageType getStorageType() {
        return this.config.getStorageType();
    }

    public int getReplicas() {
        return this.config.getReplicas();
    }

    public @Nullable Placement getPlacement() {
        return this.config.getPlacement();
    }

    public boolean isCompressed() {
        return this.config.isCompressed();
    }

    public @Nullable Map<String, String> getMetadata() {
        return this.config.getMetadata();
    }

    public @NonNull String getBackingStore() {
        return "JetStream";
    }

    public String toString() {
        JsonValueUtils.MapBuilder mb = new JsonValueUtils.MapBuilder();
        mb.put("size", this.getSize());
        mb.put("isSealed", this.isSealed());
        mb.put("config", this.config);
        return "ObjectStoreStatus" + mb.toJsonValue().toJson();
    }
}

