/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.impl.MessageQueueBase;
import io.nats.client.impl.NatsMessage;
import java.time.Duration;

class ConsumerMessageQueue
extends MessageQueueBase {
    ConsumerMessageQueue() {
    }

    void push(NatsMessage msg) {
        if (this.queue.offer(msg)) {
            this.length.incrementAndGet();
            this.sizeInBytes.addAndGet(msg.getSizeInBytes());
        }
    }

    NatsMessage pop(Duration timeout) throws InterruptedException {
        if (!this.isRunning()) {
            return null;
        }
        NatsMessage msg = this._poll(timeout);
        if (msg == null) {
            return null;
        }
        this.length.decrementAndGet();
        this.sizeInBytes.addAndGet(-msg.getSizeInBytes());
        return msg;
    }
}

