/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.impl.MarkerMessage;
import io.nats.client.impl.NatsMessage;
import java.time.Duration;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

abstract class MessageQueueBase {
    protected static final int PAUSED = 0;
    protected static final int RUNNING = 1;
    protected static final int DRAINING = 2;
    protected final int queueCapacity;
    protected final LinkedBlockingQueue<NatsMessage> queue;
    protected final AtomicLong length;
    protected final AtomicLong sizeInBytes;
    protected final AtomicInteger running;

    MessageQueueBase() {
        this(Integer.MAX_VALUE);
    }

    MessageQueueBase(int queueCapacity) {
        this.queueCapacity = queueCapacity > 0 ? queueCapacity : Integer.MAX_VALUE;
        this.queue = new LinkedBlockingQueue(this.queueCapacity);
        this.length = new AtomicLong(0L);
        this.sizeInBytes = new AtomicLong(0L);
        this.running = new AtomicInteger(1);
    }

    boolean isRunning() {
        return this.running.get() != 0;
    }

    boolean isPaused() {
        return this.running.get() == 0;
    }

    boolean isDraining() {
        return this.running.get() == 2;
    }

    boolean isDrained() {
        return this.running.get() == 2 && this.length.get() == 0L;
    }

    void pause() {
        if (this.running.compareAndSet(1, 0)) {
            this.queue.offer(MarkerMessage.POISON_PILL);
        }
    }

    void drain() {
        if (this.running.compareAndSet(1, 2)) {
            this.queue.offer(MarkerMessage.POISON_PILL);
        }
    }

    void resume() {
        this.running.set(1);
    }

    long queueSize() {
        return this.queue.size();
    }

    long length() {
        return this.length.get();
    }

    long sizeInBytes() {
        return this.sizeInBytes.get();
    }

    NatsMessage _poll(Duration timeout) throws InterruptedException {
        NatsMessage msg = null;
        if (timeout == null || this.isDraining()) {
            msg = this.queue.poll();
        } else {
            long nanos = timeout.toNanos();
            if (nanos < 1L) {
                while (this.isRunning() && (msg = this.queue.poll(3650L, TimeUnit.DAYS)) == null) {
                }
            } else {
                msg = this.queue.poll(nanos, TimeUnit.NANOSECONDS);
            }
        }
        return msg == null || msg == MarkerMessage.POISON_PILL ? null : msg;
    }
}

