/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.ObjectStoreManagement;
import io.nats.client.ObjectStoreOptions;
import io.nats.client.api.ObjectStoreConfiguration;
import io.nats.client.api.ObjectStoreStatus;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStreamManagement;
import io.nats.client.support.NatsObjectStoreUtil;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NatsObjectStoreManagement
implements ObjectStoreManagement {
    private final NatsJetStreamManagement jsm;

    NatsObjectStoreManagement(NatsConnection connection, ObjectStoreOptions oso, NatsJetStreamManagement jsm) throws IOException {
        this.jsm = jsm == null ? new NatsJetStreamManagement(connection, oso == null ? null : oso.getJetStreamOptions()) : jsm;
    }

    @Override
    public ObjectStoreStatus create(ObjectStoreConfiguration config) throws IOException, JetStreamApiException {
        StreamConfiguration sc = config.getBackingConfig();
        return new ObjectStoreStatus(this.jsm.addStream(sc));
    }

    @Override
    public List<String> getBucketNames() throws IOException, JetStreamApiException {
        ArrayList<String> buckets = new ArrayList<String>();
        List<String> names = this.jsm.getStreamNames();
        for (String name : names) {
            if (!name.startsWith("OBJ_")) continue;
            buckets.add(NatsObjectStoreUtil.extractBucketName(name));
        }
        return buckets;
    }

    @Override
    public ObjectStoreStatus getStatus(String bucketName) throws IOException, JetStreamApiException {
        Validator.validateBucketName(bucketName, true);
        return new ObjectStoreStatus(this.jsm.getStreamInfo(NatsObjectStoreUtil.toStreamName(bucketName)));
    }

    @Override
    public List<ObjectStoreStatus> getStatuses() throws IOException, JetStreamApiException {
        List<String> bucketNames = this.getBucketNames();
        ArrayList<ObjectStoreStatus> statuses = new ArrayList<ObjectStoreStatus>();
        for (String name : bucketNames) {
            statuses.add(new ObjectStoreStatus(this.jsm.getStreamInfo(NatsObjectStoreUtil.toStreamName(name))));
        }
        return statuses;
    }

    @Override
    public void delete(String bucketName) throws IOException, JetStreamApiException {
        Validator.validateBucketName(bucketName, true);
        this.jsm.deleteStream(NatsObjectStoreUtil.toStreamName(bucketName));
    }
}

