/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.PullMessageManager;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class PullOrderedMessageManager
extends PullMessageManager {
    protected final ConsumerConfiguration originalCc;
    protected final NatsJetStream js;
    protected final String stream;
    protected final AtomicLong expectedExternalConsumerSeq;
    protected final AtomicReference<String> targetSid;

    protected PullOrderedMessageManager(NatsConnection conn, NatsJetStream js, String stream, SubscribeOptions so, ConsumerConfiguration originalCc, boolean syncMode) {
        super(conn, so, syncMode);
        this.js = js;
        this.stream = stream;
        this.originalCc = originalCc;
        this.expectedExternalConsumerSeq = new AtomicLong(1L);
        this.targetSid = new AtomicReference();
    }

    @Override
    protected void startup(NatsJetStreamSubscription sub) {
        this.expectedExternalConsumerSeq.set(1L);
        super.startup(sub);
        this.targetSid.set(sub.getSID());
    }

    @Override
    protected MessageManager.ManageResult manage(Message msg) {
        if (!msg.getSID().equals(this.targetSid.get())) {
            return MessageManager.ManageResult.STATUS_HANDLED;
        }
        if (msg.isJetStream()) {
            long receivedConsumerSeq = msg.metaData().consumerSequence();
            if (this.expectedExternalConsumerSeq.get() != receivedConsumerSeq) {
                this.targetSid.set(null);
                this.expectedExternalConsumerSeq.set(1L);
                this.resetTracking();
                if (this.pullManagerObserver != null) {
                    this.pullManagerObserver.heartbeatError();
                }
                return MessageManager.ManageResult.STATUS_HANDLED;
            }
            this.trackJsMessage(msg);
            this.expectedExternalConsumerSeq.incrementAndGet();
            return MessageManager.ManageResult.MESSAGE;
        }
        return this.manageStatus(msg);
    }
}

