/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.Encoding;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public class JsonValue
implements JsonSerializable {
    private static final char QUOTE = '\"';
    private static final char COMMA = ',';
    private static final String NULL_STR = "null";
    public static final JsonValue NULL = new JsonValue();
    public static final JsonValue TRUE = new JsonValue(true);
    public static final JsonValue FALSE = new JsonValue(false);
    public static final JsonValue EMPTY_MAP = new JsonValue(Collections.unmodifiableMap(new HashMap()));
    public static final JsonValue EMPTY_ARRAY = new JsonValue(Collections.unmodifiableList(new ArrayList()));
    public final String string;
    public final Boolean bool;
    public final Integer i;
    public final Long l;
    public final Double d;
    public final Float f;
    public final BigDecimal bd;
    public final BigInteger bi;
    public final Map<String, JsonValue> map;
    public final List<JsonValue> array;
    public final Type type;
    public final Object object;
    public final Number number;
    public final List<String> mapOrder;

    public JsonValue() {
        this(null, null, null, null, null, null, null, null, null, null);
    }

    public JsonValue(String string) {
        this(string, null, null, null, null, null, null, null, null, null);
    }

    public JsonValue(char c) {
        this("" + c, null, null, null, null, null, null, null, null, null);
    }

    public JsonValue(Boolean bool) {
        this(null, bool, null, null, null, null, null, null, null, null);
    }

    public JsonValue(int i) {
        this(null, null, i, null, null, null, null, null, null, null);
    }

    public JsonValue(long l) {
        this(null, null, null, l, null, null, null, null, null, null);
    }

    public JsonValue(double d) {
        this(null, null, null, null, d, null, null, null, null, null);
    }

    public JsonValue(float f) {
        this(null, null, null, null, null, Float.valueOf(f), null, null, null, null);
    }

    public JsonValue(BigDecimal bd) {
        this(null, null, null, null, null, null, bd, null, null, null);
    }

    public JsonValue(BigInteger bi) {
        this(null, null, null, null, null, null, null, bi, null, null);
    }

    public JsonValue(Map<String, JsonValue> map) {
        this(null, null, null, null, null, null, null, null, map, null);
    }

    public JsonValue(List<JsonValue> list) {
        this(null, null, null, null, null, null, null, null, null, list);
    }

    public JsonValue(JsonValue[] values) {
        this(null, null, null, null, null, null, null, null, null, values == null ? null : Arrays.asList(values));
    }

    private JsonValue(String string, Boolean bool, Integer i, Long l, Double d, Float f, BigDecimal bd, BigInteger bi, Map<String, JsonValue> map, List<JsonValue> array) {
        this.map = map;
        this.mapOrder = new ArrayList<String>();
        this.array = array;
        this.string = string;
        this.bool = bool;
        this.i = i;
        this.l = l;
        this.d = d;
        this.f = f;
        this.bd = bd;
        this.bi = bi;
        if (i != null) {
            this.type = Type.INTEGER;
            this.number = i;
            this.object = this.number;
        } else if (l != null) {
            this.type = Type.LONG;
            this.number = l;
            this.object = this.number;
        } else if (d != null) {
            this.type = Type.DOUBLE;
            this.number = this.d;
            this.object = this.number;
        } else if (f != null) {
            this.type = Type.FLOAT;
            this.number = this.f;
            this.object = this.number;
        } else if (bd != null) {
            this.type = Type.BIG_DECIMAL;
            this.number = this.bd;
            this.object = this.number;
        } else if (bi != null) {
            this.type = Type.BIG_INTEGER;
            this.number = this.bi;
            this.object = this.number;
        } else {
            this.number = null;
            if (map != null) {
                this.type = Type.MAP;
                this.object = map;
            } else if (string != null) {
                this.type = Type.STRING;
                this.object = string;
            } else if (bool != null) {
                this.type = Type.BOOL;
                this.object = bool;
            } else if (array != null) {
                this.type = Type.ARRAY;
                this.object = array;
            } else {
                this.type = Type.NULL;
                this.object = null;
            }
        }
    }

    public String toString(Class<?> c) {
        return this.toString(c.getSimpleName());
    }

    public String toString(String key) {
        return '\"' + key + '\"' + ":" + this.toJson();
    }

    public String toString() {
        return this.toJson();
    }

    @Override
    public @NonNull JsonValue toJsonValue() {
        return this;
    }

    @Override
    public @NonNull String toJson() {
        switch (this.type) {
            case STRING: {
                return this.valueString(this.string);
            }
            case BOOL: {
                return this.valueString(this.bool);
            }
            case MAP: {
                return this.valueString(this.map);
            }
            case ARRAY: {
                return this.valueString(this.array);
            }
            case INTEGER: {
                return this.i.toString();
            }
            case LONG: {
                return this.l.toString();
            }
            case DOUBLE: {
                return this.d.toString();
            }
            case FLOAT: {
                return this.f.toString();
            }
            case BIG_DECIMAL: {
                return this.bd.toString();
            }
            case BIG_INTEGER: {
                return this.bi.toString();
            }
        }
        return NULL_STR;
    }

    private String valueString(String s) {
        return '\"' + Encoding.jsonEncode(s) + '\"';
    }

    private String valueString(boolean b) {
        return Boolean.toString(b).toLowerCase();
    }

    private String valueString(Map<String, JsonValue> map) {
        StringBuilder sbo = JsonUtils.beginJson();
        if (!this.mapOrder.isEmpty()) {
            for (String key : this.mapOrder) {
                JsonUtils.addField(sbo, key, map.get(key));
            }
        } else {
            for (String key : map.keySet()) {
                JsonUtils.addField(sbo, key, map.get(key));
            }
        }
        return JsonUtils.endJson(sbo).toString();
    }

    private String valueString(List<JsonValue> list) {
        StringBuilder sba = JsonUtils.beginArray();
        for (JsonValue v : list) {
            sba.append(v.toJson());
            sba.append(',');
        }
        return JsonUtils.endArray(sba).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonValue jsonValue = (JsonValue)o;
        if (this.type != jsonValue.type) {
            return false;
        }
        switch (this.type) {
            case STRING: {
                return Objects.equals(this.string, jsonValue.string);
            }
            case BOOL: {
                return Objects.equals(this.bool, jsonValue.bool);
            }
            case INTEGER: {
                return Objects.equals(this.i, jsonValue.i);
            }
            case LONG: {
                return Objects.equals(this.l, jsonValue.l);
            }
            case DOUBLE: {
                return Objects.equals(this.d, jsonValue.d);
            }
            case FLOAT: {
                return Objects.equals(this.f, jsonValue.f);
            }
            case BIG_DECIMAL: {
                return Objects.equals(this.bd, jsonValue.bd);
            }
            case BIG_INTEGER: {
                return Objects.equals(this.bi, jsonValue.bi);
            }
            case MAP: {
                return Objects.equals(this.map, jsonValue.map);
            }
            case ARRAY: {
                return Objects.equals(this.array, jsonValue.array);
            }
            case NULL: {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hc = 0;
        switch (this.type) {
            case STRING: {
                hc = this.string.hashCode();
                break;
            }
            case BOOL: {
                hc = this.bool.hashCode();
                break;
            }
            case INTEGER: {
                hc = this.i.hashCode();
                break;
            }
            case LONG: {
                hc = this.l.hashCode();
                break;
            }
            case DOUBLE: {
                hc = this.d.hashCode();
                break;
            }
            case FLOAT: {
                hc = this.f.hashCode();
                break;
            }
            case BIG_DECIMAL: {
                hc = this.bd.hashCode();
                break;
            }
            case BIG_INTEGER: {
                hc = this.bi.hashCode();
                break;
            }
            case MAP: {
                hc = this.map.hashCode();
                break;
            }
            case ARRAY: {
                hc = this.array.hashCode();
            }
        }
        return 31 * this.type.hashCode() + hc;
    }

    public static enum Type {
        STRING,
        BOOL,
        INTEGER,
        LONG,
        DOUBLE,
        FLOAT,
        BIG_DECIMAL,
        BIG_INTEGER,
        MAP,
        ARRAY,
        NULL;

    }
}

