/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples;

import io.nats.client.impl.Headers;

public class ExampleArgs {
    private String title;
    public String server = "nats://localhost:4222";
    public String subject;
    public String queue;
    public String message;
    public int msgCount = Integer.MIN_VALUE;
    public int msgSize = Integer.MIN_VALUE;
    private boolean msgCountUnlimitedFlag;
    public int subCount = Integer.MIN_VALUE;
    public String stream;
    public String mirror;
    public String consumer;
    public String durable;
    public String deliverSubject;
    public int pullSize = Integer.MIN_VALUE;
    public Headers headers;
    public boolean containedUnknown = false;
    public String bucket;
    public String description;

    public boolean hasHeaders() {
        return this.headers != null && this.headers.size() > 0;
    }

    private ExampleArgs(String title) {
        this.title = title;
    }

    public ExampleArgs(String[] args, Trail trail, String usageString) {
        this.parse(args, trail, usageString);
    }

    public void parse(String[] args, Trail trail, String usageString) {
        try {
            if (args != null) {
                String lastKey = null;
                for (int x = 0; x < args.length; ++x) {
                    String arg = args[x];
                    if (arg.startsWith("-")) {
                        if (++x >= args.length) {
                            ExampleArgs.usageThenExit(usageString);
                        }
                        this.handleKeyedArg(arg, args[x]);
                        lastKey = arg;
                        continue;
                    }
                    if (trail == null) {
                        if (lastKey == null) continue;
                        this.handleKeyedArg(lastKey, arg);
                        continue;
                    }
                    this.handleTrailingArg(trail, arg);
                    lastKey = null;
                }
            }
        }
        catch (RuntimeException e) {
            System.err.println("Exception while processing command line arguments: " + e + "\n");
            ExampleArgs.usageThenExit(usageString);
        }
    }

    private void handleTrailingArg(Trail trail, String arg) {
        if (this.subject == null) {
            this.subject = arg;
        } else if (trail == Trail.MESSAGE) {
            this.message = this.message == null ? arg : this.message + " " + arg;
        } else if (trail == Trail.QUEUE_AND_COUNT) {
            if (this.queue == null) {
                this.queue = arg;
            } else {
                this.msgCount = Integer.parseInt(arg);
            }
        } else {
            this.msgCount = Integer.parseInt(arg);
        }
    }

    private void handleKeyedArg(String key, String value) {
        switch (key) {
            case "-s": {
                this.server = value;
                break;
            }
            case "-sub": {
                this.subject = value;
                break;
            }
            case "-q": {
                this.queue = value;
                break;
            }
            case "-m": {
                if (this.message == null) {
                    this.message = value;
                    break;
                }
                this.message = this.message + " " + value;
                break;
            }
            case "-con": {
                this.consumer = value;
                break;
            }
            case "-strm": {
                this.stream = value;
                break;
            }
            case "-mir": {
                this.mirror = value;
                break;
            }
            case "-pull": {
                this.pullSize = Integer.parseInt(value);
                break;
            }
            case "-mcnt": {
                this.msgCount = Integer.parseInt(value);
                break;
            }
            case "-msize": {
                this.msgSize = Integer.parseInt(value);
                break;
            }
            case "-scnt": {
                this.subCount = Integer.parseInt(value);
                break;
            }
            case "-dur": {
                this.durable = value;
                break;
            }
            case "-buk": {
                this.bucket = value;
                break;
            }
            case "-desc": {
                this.description = value;
                break;
            }
            case "-deliver": {
                this.deliverSubject = value;
                break;
            }
            case "-r": {
                if (this.headers == null) {
                    this.headers = new Headers();
                }
                String[] hdr = value.split(":");
                this.headers.add(hdr[0], hdr[1]);
                break;
            }
            default: {
                this.containedUnknown = true;
            }
        }
    }

    public void displayBanner() {
        if (this.title == null) {
            System.out.println("\nExample");
        } else {
            System.out.format("\n%s Example\n", this.title);
        }
        this._banner("server", this.server);
        this._banner("stream", this.stream);
        this._banner("subject", this.subject);
        this._banner("bucket", this.bucket);
        this._banner("description", this.description);
        this._banner("queue", this.queue);
        this._banner("message", this.message);
        this._banner("mirror", this.mirror);
        this._banner("consumer", this.consumer);
        this._banner("durable", this.durable);
        this._banner("deliver", this.deliverSubject);
        this._banner("msgCount", this.msgCount, this.msgCountUnlimitedFlag);
        this._banner("msgSize", this.msgSize);
        this._banner("subCount", this.subCount);
        this._banner("pullSize", this.pullSize);
        this._banner("Headers", this.headers == null || this.headers.size() == 0 ? Integer.MIN_VALUE : this.headers.size());
        System.out.println();
    }

    private void _banner(String label, String value) {
        if (value != null) {
            System.out.format("  %s: %s\n", label, value);
        }
    }

    private void _banner(String label, int value) {
        this._banner(label, value, false);
    }

    private void _banner(String label, int value, boolean unlimited) {
        if (unlimited && (value == Integer.MAX_VALUE || value < 1)) {
            System.out.format("  %s: Unlimited\n", label);
        } else if (value > Integer.MIN_VALUE) {
            System.out.format("  %s: %s\n", label, value);
        }
    }

    public static Builder builder(String title, String[] args, String usage) {
        return new Builder(title, args, usage);
    }

    private static void usageThenExit(String usageString) {
        if (usageString != null) {
            System.out.println(usageString);
        }
        System.exit(-1);
    }

    public static class Builder {
        private final ExampleArgs ea;
        private final String[] args;
        private final String usage;

        public Builder(String title, String[] args, String usage) {
            this.ea = new ExampleArgs(title);
            this.args = args;
            this.usage = usage;
        }

        public Builder defaultSubject(String subject) {
            this.ea.subject = subject;
            return this;
        }

        public Builder defaultQueue(String queue) {
            this.ea.queue = queue;
            return this;
        }

        public Builder defaultMessage(String message) {
            this.ea.message = message;
            return this;
        }

        public Builder defaultMsgCount(int msgCount) {
            return this.defaultMsgCount(msgCount, false);
        }

        public Builder defaultMsgCount(int msgCount, boolean unlimitedFlag) {
            this.ea.msgCount = msgCount;
            this.ea.msgCountUnlimitedFlag = unlimitedFlag;
            return this;
        }

        public Builder defaultMsgSize(int msgSize) {
            this.ea.msgSize = msgSize;
            return this;
        }

        public Builder defaultSubCount(int subCount) {
            this.ea.subCount = subCount;
            return this;
        }

        public Builder defaultStream(String stream) {
            this.ea.stream = stream;
            return this;
        }

        public Builder defaultMirror(String mirror) {
            this.ea.mirror = mirror;
            return this;
        }

        public Builder defaultDurable(String durable) {
            this.ea.durable = durable;
            return this;
        }

        public Builder defaultBucket(String bucket) {
            this.ea.bucket = bucket;
            return this;
        }

        public Builder defaultDescription(String description) {
            this.ea.description = description;
            return this;
        }

        public Builder defaultDeliverSubject(String deliver) {
            this.ea.deliverSubject = deliver;
            return this;
        }

        public Builder defaultPullSize(int pullSize) {
            this.ea.pullSize = pullSize;
            return this;
        }

        public ExampleArgs build() {
            this.ea.parse(this.args, null, this.usage);
            if (this.ea.containedUnknown && this.usage != null) {
                ExampleArgs.usageThenExit(this.usage);
            }
            this.ea.displayBanner();
            return this.ea;
        }
    }

    public static enum Trail {
        MESSAGE,
        COUNT,
        QUEUE_AND_COUNT;

    }
}

