/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples;

import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.client.NUID;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.impl.ErrorListenerLoggerImpl;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleAuthHandler;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;

public class ExampleUtils {
    public static final ConnectionListener EXAMPLE_CONNECTION_LISTENER = (conn, type) -> System.out.println("Status change " + (Object)((Object)type));
    public static final ErrorListener EXAMPLE_ERROR_LISTENER = new ErrorListenerLoggerImpl();

    public static String getServer(String[] args) {
        if (args.length == 1) {
            return args[0];
        }
        if (args.length == 2 && args[0].equals("-s")) {
            return args[1];
        }
        return "nats://localhost:4222";
    }

    public static Options createExampleOptions(String[] args) {
        String server = ExampleUtils.getServer(args);
        return ExampleUtils.createExampleOptions(server, false, EXAMPLE_ERROR_LISTENER, EXAMPLE_CONNECTION_LISTENER);
    }

    public static Options createExampleOptions(String[] args, boolean allowReconnect) {
        String server = ExampleUtils.getServer(args);
        return ExampleUtils.createExampleOptions(server, allowReconnect, EXAMPLE_ERROR_LISTENER, EXAMPLE_CONNECTION_LISTENER);
    }

    public static Options createExampleOptions(String server) {
        return ExampleUtils.createExampleOptions(server, false, EXAMPLE_ERROR_LISTENER, EXAMPLE_CONNECTION_LISTENER);
    }

    public static Options createExampleOptions(String server, ErrorListener el) {
        return ExampleUtils.createExampleOptions(server, false, el, EXAMPLE_CONNECTION_LISTENER);
    }

    public static Options createExampleOptions(String server, boolean allowReconnect) {
        return ExampleUtils.createExampleOptions(server, allowReconnect, EXAMPLE_ERROR_LISTENER, EXAMPLE_CONNECTION_LISTENER);
    }

    public static Options createExampleOptions(String server, boolean allowReconnect, ErrorListener el, ConnectionListener cl) {
        if (el == null) {
            el = new ErrorListener(){};
        }
        Options.Builder builder = new Options.Builder().server(server).connectionTimeout(Duration.ofSeconds(5L)).pingInterval(Duration.ofSeconds(10L)).reconnectWait(Duration.ofSeconds(1L)).connectionListener(cl).errorListener(el);
        builder = !allowReconnect ? builder.noReconnect() : builder.maxReconnects(-1);
        if (System.getenv("NATS_NKEY") != null && System.getenv("NATS_NKEY") != "") {
            ExampleAuthHandler handler = null;
            try {
                handler = new ExampleAuthHandler(System.getenv("NATS_NKEY"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            builder.authHandler(handler);
        } else if (System.getenv("NATS_CREDS") != null && System.getenv("NATS_CREDS") != "") {
            builder.authHandler(Nats.credentials(System.getenv("NATS_CREDS")));
        }
        return builder.build();
    }

    public static ExampleArgs optionalServer(String[] args, String usageString) {
        ExampleArgs ea = new ExampleArgs(args, null, usageString);
        if (ea.containedUnknown) {
            ExampleUtils.usage(usageString);
        }
        return ea;
    }

    public static ExampleArgs expectSubjectAndMessage(String[] args, String usageString) {
        ExampleArgs ea = new ExampleArgs(args, ExampleArgs.Trail.MESSAGE, usageString);
        if (ea.containedUnknown || ea.message == null) {
            ExampleUtils.usage(usageString);
        }
        return ea;
    }

    public static ExampleArgs expectSubjectAndMsgCount(String[] args, String usageString) {
        ExampleArgs ea = new ExampleArgs(args, ExampleArgs.Trail.COUNT, usageString);
        if (ea.containedUnknown || ea.msgCount < 1) {
            ExampleUtils.usage(usageString);
        }
        return ea;
    }

    public static ExampleArgs expectSubjectQueueAndMsgCount(String[] args, String usageString) {
        ExampleArgs ea = new ExampleArgs(args, ExampleArgs.Trail.COUNT, usageString);
        if (ea.containedUnknown || ea.msgCount < 1) {
            ExampleUtils.usage(usageString);
        }
        return ea;
    }

    public static void sleep(long millis) {
        try {
            if (millis > 0L) {
                Thread.sleep(millis);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleepRandom(long millis) {
        try {
            Thread.sleep(ThreadLocalRandom.current().nextLong(millis));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void usage(String usageString) {
        System.out.println(usageString);
        System.exit(-1);
    }

    public static String uniqueEnough() {
        return NUID.nextGlobal();
    }

    public static String randomString(int length) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length) {
            sb.append(Long.toHexString(ThreadLocalRandom.current().nextLong()));
        }
        return sb.substring(0, length);
    }
}

