/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.autobench;

import io.nats.client.Connection;
import io.nats.client.Options;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AutoBenchmark {
    private final String name;
    private final long messageSize;
    private final long messageCount;
    private final AtomicLong start;
    private long runtimeNanos;
    private Exception exception;

    public AutoBenchmark(String name, long messageCount, long messageSize) {
        this.name = name;
        this.messageCount = messageCount;
        this.messageSize = messageSize;
        this.start = new AtomicLong();
    }

    public abstract void execute(Options var1) throws InterruptedException;

    public String getName() {
        return this.name;
    }

    public String getSubject() {
        return this.generate("sub");
    }

    public String getStream() {
        return this.generate("stream");
    }

    private String generate(String prefix) {
        return prefix + AutoBenchmark.toSafeName(this.getName()) + "x" + this.getMessageCount();
    }

    public static String toSafeName(String text) {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < text.length(); ++x) {
            char c = text.charAt(x);
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '-' && c != '_') continue;
            sb.append(c);
        }
        return sb.toString().trim();
    }

    public long getMessageSize() {
        return this.messageSize;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public byte[] createPayload() {
        return new byte[(int)this.messageSize];
    }

    public long getStart() {
        return this.start.get();
    }

    public void startTiming() {
        this.start.set(System.nanoTime());
    }

    public void endTiming() {
        long end = System.nanoTime();
        this.runtimeNanos = end - this.start.get();
    }

    public void reset() {
        this.runtimeNanos = 0L;
        this.exception = null;
    }

    public void defaultFlush(Connection nc) {
        try {
            nc.flush(Duration.ofSeconds(5L));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getRuntimeNanos() {
        return this.runtimeNanos;
    }

    public void setException(Exception ex) {
        this.exception = ex;
    }

    public Exception getException() {
        return this.exception;
    }

    public void getFutureSafely(CompletableFuture<Void> future) {
        try {
            future.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void beforePrintFirstOfKind() {
    }

    public void afterPrintLastOfKind() {
    }

    public void printResult() {
        if (this.runtimeNanos == 0L) {
            System.out.printf("%-26s %18s\n", this.name, "no data from test run");
            return;
        }
        if (this.exception != null) {
            String message = this.exception.getMessage();
            if (message == null) {
                message = this.exception.getClass().getCanonicalName();
            }
            System.out.printf("%-26s %12s Exception: %12s\n", this.getName(), NumberFormat.getIntegerInstance().format(this.messageCount), message);
            return;
        }
        double messagesPerSecond = 1.0E9 * (double)this.messageCount / (double)this.runtimeNanos;
        double bytesPerSecond = 1.0E9 * (double)(this.messageCount * this.messageSize) / (double)this.runtimeNanos;
        System.out.printf("%-26s %12s %18s msg/s %12s/s\n", this.name, NumberFormat.getIntegerInstance().format(this.messageCount), NumberFormat.getIntegerInstance().format((long)messagesPerSecond), AutoBenchmark.humanBytes(bytesPerSecond));
    }

    public static String humanBytes(double bytes) {
        int base = 1024;
        String[] pre = new String[]{"k", "m", "g", "t", "p", "e"};
        String post = "b";
        if (bytes < (double)base) {
            return String.format("%.2f b", bytes);
        }
        int exp = (int)(Math.log(bytes) / Math.log(base));
        int index = exp - 1;
        String units = pre[index] + post;
        return String.format("%.2f %s", bytes / Math.pow(base, exp), units);
    }
}

