/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.chaosTestApp;

import io.nats.client.ConsumeOptions;
import io.nats.client.ConsumerContext;
import io.nats.client.JetStreamApiException;
import io.nats.client.MessageConsumer;
import io.nats.client.OrderedConsumerContext;
import io.nats.client.StreamContext;
import io.nats.client.api.OrderedConsumerConfiguration;
import io.nats.examples.chaosTestApp.ConnectableConsumer;
import io.nats.examples.chaosTestApp.Output;
import io.nats.examples.chaosTestApp.support.CommandLine;
import io.nats.examples.chaosTestApp.support.ConsumerKind;
import java.io.IOException;

public class SimpleConsumer
extends ConnectableConsumer {
    final StreamContext sc;
    final ConsumerContext cc;
    final OrderedConsumerContext occ;
    final MessageConsumer mc;

    public SimpleConsumer(CommandLine cmd, ConsumerKind consumerKind, int batchSize, long expiresIn) throws IOException, InterruptedException, JetStreamApiException {
        super(cmd, "sc", consumerKind);
        this.sc = this.nc.getStreamContext(cmd.stream);
        ConsumeOptions co = ((ConsumeOptions.Builder)ConsumeOptions.builder().batchSize(batchSize).expiresIn(expiresIn)).build();
        if (consumerKind == ConsumerKind.Ordered) {
            OrderedConsumerConfiguration ocConfig = new OrderedConsumerConfiguration().filterSubjects(cmd.subject);
            this.cc = null;
            this.occ = this.sc.createOrderedConsumer(ocConfig);
            this.mc = this.occ.consume(co, this.handler);
        } else {
            this.occ = null;
            this.cc = this.sc.createOrUpdateConsumer(this.newCreateConsumer().build());
            this.mc = this.cc.consume(co, this.handler);
        }
        Output.controlMessage(this.label, this.mc.getConsumerName());
    }

    @Override
    public void refreshInfo() {
        this.updateLabel(this.mc.getConsumerName());
    }
}

