/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.chaosTestApp.support;

import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.client.Options;
import io.nats.examples.chaosTestApp.Output;
import io.nats.examples.chaosTestApp.support.CommandLineConsumer;
import java.util.ArrayList;
import java.util.List;

public class CommandLine {
    public final String[] servers;
    public final String stream;
    public final String subject;
    public final String logdir;
    public final long runtime;
    public final long pubjitter;
    public final boolean create;
    public final boolean r3;
    public final boolean publish;
    public final boolean debug;
    public final boolean work;
    public final Output.Screen uiScreen;
    public final List<CommandLineConsumer> commandLineConsumers;

    private void usage() {
        System.out.println("----------------------------------------------------------------------------------------------------\nAPP COMMAND LINE\n----------------------------------------------------------------------------------------------------\n--servers <natsServerUrl>[,<natsServerUrl>]*\n  * i.e. --servers nats://localhost:4000,nats://localhost:4001,nats://localhost:4002\n  * not supplied uses \"nats://localhost:4222\"\n--stream <stream name>\n  * not supplied uses \"app-stream\"\n--subject <subject>\n  * not supplied uses \"app-subject\"\n--runtime <>m|<>s|<>ms|<>\n  * not supplied or zero or negative infinite  * m minute, s second ms millseconds no suffix milliseonds\n--debug\n  * show the debug window\n--work\n  * work the work window\n--screen <left|center|console> console is default\n--simple <ephemeral|durable|ordered>,batchSize,expiresInMs\n--simple <ephemeral|durable|ordered> batchSize expiresInMs\n  * Simple Consumer.\n--fetch,<ephemeral|durable> batchSize expiresInMs\n  * Simple Fetch Consumer.\n--push,<ephemeral|durable|ordered>\n  * Push Consumer.\n*** One or more consumers is required.\n--create\n  * (Re)create the stream.\n--r3\n  * Make the stream R3 when (Re)create the stream.\n--publish\n  * Turns on publishing.\n--pubjitter\n  * publish jitter in milliseconds, amount of time to pause between publish\n  * not supplied uses 50ms\n--logdir\n  * Directory to log to. Only logs if supplied\n----------------------------------------------------------------------------------------------------\n");
    }

    public Options makeManagmentOptions() {
        return this.makeOptions((conn, event) -> {}, new ErrorListener(){}, 0);
    }

    public Options makeOptions(ConnectionListener cl, ErrorListener el) {
        return this.makeOptions(cl, el, -1);
    }

    public Options makeOptions(ConnectionListener cl, ErrorListener el, int maxReconnects) {
        return new Options.Builder().servers(this.servers).connectionListener(cl).errorListener(el).maxReconnects(maxReconnects).build();
    }

    private void append(StringBuilder sb, String label, Object value, boolean test) {
        if (test) {
            sb.append("--").append(label).append(" ").append(value).append(" ");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Chaos Test App Config ");
        this.append(sb, "servers", String.join((CharSequence)",", this.servers), true);
        this.append(sb, "stream", this.stream, true);
        this.append(sb, "subject", this.subject, true);
        this.append(sb, "logdir", this.logdir, this.logdir != null);
        this.append(sb, "runtime", this.runtime, true);
        this.append(sb, "create", this.create, this.create);
        this.append(sb, "R3", this.r3, this.r3);
        this.append(sb, "publish", this.publish, this.publish);
        this.append(sb, "pubjitter", this.pubjitter, this.publish);
        this.append(sb, "debug", this.debug, this.debug);
        this.append(sb, "work", this.work, this.work);
        this.append(sb, "screen", (Object)this.uiScreen, true);
        for (CommandLineConsumer cc : this.commandLineConsumers) {
            this.append(sb, "consumer", cc, true);
        }
        return sb.toString().trim();
    }

    public CommandLine(String[] args) {
        try {
            String[] _servers = new String[]{"nats://localhost:4222"};
            String _stream = "app-stream";
            String _subject = "app-subject";
            String _logdir = null;
            long _runtime = -1L;
            long _publishJitter = 50L;
            boolean _debug = false;
            boolean _create = false;
            boolean _r3 = false;
            boolean _publish = false;
            boolean _work = false;
            Output.Screen _uiScreen = Output.Screen.Console;
            ArrayList<CommandLineConsumer> _commandLineConsumers = new ArrayList<CommandLineConsumer>();
            if (args != null && args.length > 0) {
                try {
                    block37: for (int x = 0; x < args.length; ++x) {
                        String arg = args[x].trim();
                        if (arg.isEmpty()) continue;
                        switch (arg) {
                            case "--servers": {
                                _servers = this.asString(args[++x]).split(",");
                                continue block37;
                            }
                            case "--stream": {
                                _stream = this.asString(args[++x]);
                                continue block37;
                            }
                            case "--subject": {
                                _subject = this.asString(args[++x]);
                                continue block37;
                            }
                            case "--logdir": {
                                _logdir = this.asString(args[++x]);
                                continue block37;
                            }
                            case "--runtime": {
                                _runtime = (long)this.asNumber("runtime", args[++x], -1) * 1000L;
                                continue block37;
                            }
                            case "--pubjitter": {
                                _publishJitter = this.asNumber("pubjitter", args[++x], -1);
                                continue block37;
                            }
                            case "--create": {
                                _create = true;
                                continue block37;
                            }
                            case "--r3": {
                                _r3 = true;
                                continue block37;
                            }
                            case "--publish": {
                                _publish = true;
                                continue block37;
                            }
                            case "--debug": {
                                _debug = true;
                                continue block37;
                            }
                            case "--work": {
                                _work = true;
                                continue block37;
                            }
                            case "--screen": {
                                String screen = this.asString(args[++x]).toLowerCase();
                                if (screen.equals("left")) {
                                    _uiScreen = Output.Screen.Left;
                                    continue block37;
                                }
                                if (screen.equals("center")) {
                                    _uiScreen = Output.Screen.Main;
                                    continue block37;
                                }
                                throw new IllegalArgumentException("Unknown Screen");
                            }
                            case "--simple": 
                            case "--fetch": {
                                String temp = args[++x];
                                if (temp.contains(",")) {
                                    String[] split = temp.split(",");
                                    _commandLineConsumers.add(new CommandLineConsumer(arg.substring(2), split[0], this.asNumber("batchSize", split[1], -1), this.asNumber("expiresInMs", split[2], -1)));
                                    continue block37;
                                }
                                _commandLineConsumers.add(new CommandLineConsumer(arg.substring(2), temp, this.asNumber("batchSize", args[++x], -1), this.asNumber("expiresInMs", args[++x], -1)));
                                continue block37;
                            }
                            case "--push": {
                                _commandLineConsumers.add(new CommandLineConsumer(args[++x]));
                                continue block37;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown argument: " + arg);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Exception while parsing, most likely missing an argument value.");
                }
            }
            if (!_create && !_publish && _commandLineConsumers.isEmpty()) {
                throw new IllegalArgumentException("Consumer commands are required if not creating or publishing");
            }
            this.servers = _servers;
            this.stream = _stream;
            this.subject = _subject;
            this.logdir = _logdir;
            this.runtime = _runtime;
            this.create = _create;
            this.r3 = _r3;
            this.publish = _publish;
            this.pubjitter = _publishJitter;
            this.debug = _debug;
            this.work = _work;
            this.uiScreen = _uiScreen;
            this.commandLineConsumers = _commandLineConsumers;
        }
        catch (RuntimeException e) {
            this.usage();
            throw e;
        }
    }

    private String asString(String val) {
        return val.trim();
    }

    private int asNumber(String name, String val, int upper) {
        int v = Integer.parseInt(val);
        if (upper == -2 && v < 1) {
            return Integer.MAX_VALUE;
        }
        if (upper > 0 && v > upper) {
            throw new IllegalArgumentException("Value for " + name + " cannot exceed " + upper);
        }
        return v;
    }

    private int asNumber(String name, String val, int lower, int upper) {
        int v = Integer.parseInt(val);
        if (v < lower) {
            throw new IllegalArgumentException("Value for " + name + " cannot be less than " + lower);
        }
        if (v > upper) {
            throw new IllegalArgumentException("Value for " + name + " cannot exceed " + upper);
        }
        return v;
    }
}

