/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.api.PublishAck;
import io.nats.client.impl.NatsMessage;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.nio.charset.StandardCharsets;
import java.time.Duration;

public class NatsJsPubVersusCorePub {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPubVersusCorePub [-s server] [-strm stream] [-sub subject]\n\nDefault Values:\n   [-strm] js-or-core-stream\n   [-sub]  js-or-core-subject\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Publish JetStream Versus Core", args, usageString).defaultStream("js-or-core-stream").defaultSubject("js-or-core-subject").build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server));){
            JetStream js = nc.jetStream();
            NatsJsUtils.createStreamExitWhenExists(nc, exArgs.stream, exArgs.subject);
            nc.publish(exArgs.subject, "regular-message".getBytes(StandardCharsets.UTF_8));
            Message msg = NatsMessage.builder().subject(exArgs.subject).data("js-message", StandardCharsets.UTF_8).build();
            PublishAck pa = js.publish(msg);
            System.out.println(pa);
            JetStreamSubscription sub = js.subscribe(exArgs.subject);
            nc.flush(Duration.ofSeconds(5L));
            msg = sub.nextMessage(Duration.ofSeconds(1L));
            msg.ack();
            System.out.println("Received Data: " + new String(msg.getData()) + "\n          " + msg.metaData());
            msg = sub.nextMessage(Duration.ofSeconds(1L));
            msg.ack();
            System.out.println("Received Data: " + new String(msg.getData()) + "\n          " + msg.metaData());
            nc.jetStreamManagement().deleteStream(exArgs.stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

