/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.Nats;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.PublishAck;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class NatsJsPushSubAsyncQueueDurable {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPushSubAsyncQueueDurable [-s server] [-strm stream] [-sub subject] [-q queue] [-dur durable] [-mcnt msgCount] [-scnt subCount]\n\nDefault Values:\n   [-strm stream]   qdur-stream\n   [-sub subject]   qdur-subject\n   [-q queue]       qdur-queue\n   [-dur durable]   qdur-durable\n   [-mcnt msgCount] 100\n   [-scnt subCount] 5\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Push Subscribe, Durable Consumer, Queue", args, usageString).defaultStream("qdur-stream").defaultSubject("qdur-subject").defaultQueue("qdur-queue").defaultDurable("qdur-durable").defaultMsgCount(100).defaultSubCount(5).build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server, true));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createStreamExitWhenExists(jsm, exArgs.stream, exArgs.subject);
            JetStream js = nc.jetStream();
            System.out.println();
            PushSubscribeOptions pso = ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().durable(exArgs.durable)).build();
            AtomicInteger allReceived = new AtomicInteger();
            ArrayList<JsQueueSubscriber> subscribers = new ArrayList<JsQueueSubscriber>();
            Dispatcher d = nc.createDispatcher();
            for (int id = 1; id <= exArgs.subCount; ++id) {
                JsQueueSubscriber qs = new JsQueueSubscriber(id, allReceived);
                subscribers.add(qs);
                js.subscribe(exArgs.subject, exArgs.queue, d, qs, false, pso);
            }
            nc.flush(Duration.ofSeconds(1L));
            Thread pubThread = new Thread(new JsPublisher(js, exArgs));
            pubThread.start();
            pubThread.join();
            for (long waited = 0L; waited < 60000L && allReceived.get() < exArgs.msgCount; waited += 100L) {
                Thread.sleep(100L);
            }
            for (JsQueueSubscriber qs : subscribers) {
                qs.report();
            }
            System.out.println();
            jsm.deleteStream(exArgs.stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class JsQueueSubscriber
    implements MessageHandler {
        int id;
        int thisReceived;
        List<String> datas;
        AtomicInteger allReceived;

        public JsQueueSubscriber(int id, AtomicInteger allReceived) {
            this.id = id;
            this.thisReceived = 0;
            this.datas = new ArrayList<String>();
            this.allReceived = allReceived;
        }

        public void report() {
            System.out.printf("Sub # %d handled %d messages.\n", this.id, this.thisReceived);
        }

        @Override
        public void onMessage(Message msg) throws InterruptedException {
            ++this.thisReceived;
            this.allReceived.incrementAndGet();
            String data = new String(msg.getData(), StandardCharsets.US_ASCII);
            this.datas.add(data);
            System.out.printf("QS # %d message # %d %s\n", this.id, this.thisReceived, data);
            msg.ack();
        }
    }

    static class JsPublisher
    implements Runnable {
        JetStream js;
        ExampleArgs exArgs;

        public JsPublisher(JetStream js, ExampleArgs exArgs) {
            this.js = js;
            this.exArgs = exArgs;
        }

        @Override
        public void run() {
            for (int x = 1; x <= this.exArgs.msgCount; ++x) {
                try {
                    PublishAck publishAck = this.js.publish(this.exArgs.subject, ("Data # " + x).getBytes(StandardCharsets.US_ASCII));
                    continue;
                }
                catch (JetStreamApiException | IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        }
    }
}

