/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.nio.charset.StandardCharsets;
import java.time.Duration;

public class NatsJsPushSubBindDurable {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPushSubBindDurable [-s server] [-strm stream] [-sub subject] [-mcnt msgCount] [-dur durable] [-deliver deliver]\n\nDefault Values:\n   [-strm]    example-stream\n   [-sub]     example-subject\n   [-dur]     bind-durable\n   [-deliver] bind-deliver\n   [-mcnt]    0\n\nRun Notes:\n   - make sure you have created and published to the stream and subject, maybe using the NatsJsPub example\n   - msg_count < 1 will just loop until there are no more messages\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Push Subscription Binding With Durable", args, usageString).defaultStream("example-stream").defaultSubject("example-subject").defaultDurable("bind-durable").defaultDeliverSubject("bind-deliver").defaultMsgCount(0, true).build();
        int count = exArgs.msgCount < 1 ? Integer.MAX_VALUE : exArgs.msgCount;
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server, true));){
            NatsJsUtils.exitIfStreamNotExists(nc, exArgs.stream);
            ConsumerConfiguration cc = ConsumerConfiguration.builder().durable(exArgs.durable).deliverSubject(exArgs.deliverSubject).build();
            nc.jetStreamManagement().addOrUpdateConsumer(exArgs.stream, cc);
            JetStream js = nc.jetStream();
            PushSubscribeOptions so = PushSubscribeOptions.bind(exArgs.stream, exArgs.durable);
            JetStreamSubscription sub = js.subscribe(exArgs.subject, so);
            nc.flush(Duration.ofSeconds(5L));
            int red = 0;
            Message msg = sub.nextMessage(Duration.ofSeconds(1L));
            while (msg != null) {
                System.out.println("\nMessage Received:");
                if (msg.hasHeaders()) {
                    System.out.println("  Headers:");
                    for (String key : msg.getHeaders().keySet()) {
                        for (String value : msg.getHeaders().get(key)) {
                            System.out.printf("    %s: %s\n", key, value);
                        }
                    }
                }
                System.out.printf("  Subject: %s\n  Data: %s\n", msg.getSubject(), new String(msg.getData(), StandardCharsets.UTF_8));
                System.out.println("  " + msg.metaData());
                msg.ack();
                ++red;
                if (--count == 0) {
                    msg = null;
                    continue;
                }
                msg = sub.nextMessage(1000L);
            }
            System.out.println("\n" + red + " message(s) were received.\n");
            sub.unsubscribe();
            nc.flush(Duration.ofSeconds(5L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

