/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.Subscription;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.time.Duration;

public class NatsJsPushSubDeliverSubject {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPushSubDeliverSubject [-s server] [-strm stream] [-sub subject-prefix] [-deliver deliver-prefix]\n\nDefault Values:\n   [-strm]    ds-stream\n   [-sub]     ds-subject-\n   [-deliver] ds-target-\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Push Subscribe With Deliver Subject", args, usageString).defaultStream("ds-stream").defaultSubject("ds-subject-").defaultDeliverSubject("ds-target-").build();
        String subjectNoAck = exArgs.subject + "noack";
        String subjectAck = exArgs.subject + "ack";
        String deliverNoAck = exArgs.deliverSubject + "noack";
        String deliverAck = exArgs.deliverSubject + "ack";
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createStreamExitWhenExists(jsm, exArgs.stream, subjectNoAck, subjectAck);
            JetStream js = nc.jetStream();
            ConsumerConfiguration cc = ConsumerConfiguration.builder().ackPolicy(AckPolicy.None).ackWait(Duration.ofSeconds(1L)).build();
            PushSubscribeOptions pso = ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().deliverSubject(deliverNoAck).configuration(cc)).build();
            JetStreamSubscription jsSub = js.subscribe(subjectNoAck, pso);
            nc.flush(Duration.ofSeconds(5L));
            Subscription coreSub = nc.subscribe(deliverNoAck);
            NatsJsUtils.publish(js, subjectNoAck, "A", 1);
            Message msg = jsSub.nextMessage(Duration.ofSeconds(1L));
            NatsJsPushSubDeliverSubject.printMessage("\nNoAck 4. Read w/JetStream sub", msg);
            msg = coreSub.nextMessage(Duration.ofSeconds(1L));
            NatsJsPushSubDeliverSubject.printMessage("NoAck 5. Read w/core sub", msg);
            ExampleUtils.sleep(1100L);
            msg = coreSub.nextMessage(Duration.ofSeconds(1L));
            NatsJsPushSubDeliverSubject.printMessage("NoAck 6. Read w/core sub.\nAck Policy is none so no replay even though message was not Ack'd.\nmessage should be null", msg);
            cc = ConsumerConfiguration.builder().ackPolicy(AckPolicy.Explicit).ackWait(Duration.ofSeconds(1L)).build();
            pso = ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().deliverSubject(deliverAck).configuration(cc)).build();
            jsSub = js.subscribe(subjectAck, pso);
            nc.flush(Duration.ofSeconds(5L));
            coreSub = nc.subscribe(deliverAck);
            NatsJsUtils.publish(js, subjectAck, "B", 1);
            msg = jsSub.nextMessage(Duration.ofSeconds(1L));
            NatsJsPushSubDeliverSubject.printMessage("\nAck 4. Read w/JetStream sub", msg);
            msg = coreSub.nextMessage(Duration.ofSeconds(1L));
            NatsJsPushSubDeliverSubject.printMessage("Ack 5. Read w/core sub", msg);
            ExampleUtils.sleep(1100L);
            msg = coreSub.nextMessage(Duration.ofSeconds(1L));
            msg.ack();
            NatsJsPushSubDeliverSubject.printMessage("Ack 6. Read w/core sub.\nWasn't Ack'd after step 'Ack 5.' so message was replayed.", msg);
            ExampleUtils.sleep(1100L);
            msg = coreSub.nextMessage(Duration.ofSeconds(1L));
            NatsJsPushSubDeliverSubject.printMessage("Ack 7. Read w/core sub.\nMessage received by core sub in step 'Ack 6.' was JetStream so it was Ack'd and therefore not replayed.\nMessage should be null", msg);
            jsm.deleteStream(exArgs.stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printMessage(String label, Message msg) {
        System.out.println(label);
        if (msg == null) {
            System.out.println("  Message: null");
        } else {
            System.out.println("  Message: " + msg);
            System.out.println("  JetStream: " + msg.isJetStream());
            System.out.println("  Meta: " + msg.metaData());
        }
        System.out.println();
    }
}

