/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.PublishAck;
import io.nats.client.api.StorageType;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class NatsJsPushSubQueueDurable {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPushSubQueueDurable [-s server] [-strm stream] [-sub subject] [-q queue] [-dur durable] [-mcnt msgCount] [-scnt subCount]\n\nDefault Values:\n   [-strm stream]   qdur-stream\n   [-sub subject]   qdur-subject\n   [-q queue]       qdur-queue\n   [-dur durable]   qdur-durable\n   [-mcnt msgCount] 100\n   [-scnt subCount] 5\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Push Subscribe, Durable Consumer, Queue", args, usageString).defaultStream("qdur-stream").defaultSubject("qdur-subject").defaultQueue("qdur-queue").defaultDurable("qdur-durable").defaultMsgCount(10000).defaultSubCount(5).build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server, true));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createOrReplaceStream(jsm, exArgs.stream, StorageType.Memory, exArgs.subject);
            JetStream js = nc.jetStream();
            System.out.println();
            PushSubscribeOptions pso = ConsumerConfiguration.builder().durable(exArgs.durable).deliverGroup(exArgs.queue).buildPushSubscribeOptions();
            AtomicInteger allReceived = new AtomicInteger();
            ArrayList<JsQueueSubscriber> subscribers = new ArrayList<JsQueueSubscriber>();
            ArrayList<Thread> subThreads = new ArrayList<Thread>();
            int readCount = exArgs.msgCount / exArgs.subCount;
            System.out.println("Each of the " + exArgs.msgCount + " queue subscriptions will read about " + readCount + " messages.");
            for (int id = 1; id <= exArgs.subCount; ++id) {
                JetStreamSubscription sub = js.subscribe(exArgs.subject, exArgs.queue, pso);
                JsQueueSubscriber qs = new JsQueueSubscriber(id, exArgs, js, sub, allReceived);
                subscribers.add(qs);
                Thread t = new Thread(qs);
                subThreads.add(t);
                t.start();
            }
            nc.flush(Duration.ofSeconds(1L));
            Thread pubThread = new Thread(new JsPublisher(js, exArgs));
            pubThread.start();
            pubThread.join();
            for (Thread t : subThreads) {
                t.join();
            }
            for (JsQueueSubscriber qs : subscribers) {
                qs.report();
            }
            System.out.println();
            jsm.deleteStream(exArgs.stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class JsQueueSubscriber
    implements Runnable {
        int id;
        int thisReceived;
        List<String> datas;
        ExampleArgs exArgs;
        JetStream js;
        JetStreamSubscription sub;
        AtomicInteger allReceived;

        public JsQueueSubscriber(int id, ExampleArgs exArgs, JetStream js, JetStreamSubscription sub, AtomicInteger allReceived) {
            this.id = id;
            this.thisReceived = 0;
            this.datas = new ArrayList<String>();
            this.exArgs = exArgs;
            this.js = js;
            this.sub = sub;
            this.allReceived = allReceived;
        }

        public void report() {
            System.out.printf("Sub # %d handled %d messages.\n", this.id, this.thisReceived);
        }

        @Override
        public void run() {
            while (this.allReceived.get() < this.exArgs.msgCount) {
                try {
                    Message msg = this.sub.nextMessage(Duration.ofMillis(500L));
                    while (msg != null) {
                        ++this.thisReceived;
                        this.allReceived.incrementAndGet();
                        String data = new String(msg.getData(), StandardCharsets.US_ASCII);
                        this.datas.add(data);
                        System.out.printf("QS # %d message # %d %s\n", this.id, this.thisReceived, data);
                        msg.ack();
                        msg = this.sub.nextMessage(Duration.ofMillis(500L));
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            System.out.printf("QS # %d completed.\n", this.id);
        }
    }

    static class JsPublisher
    implements Runnable {
        JetStream js;
        ExampleArgs exArgs;

        public JsPublisher(JetStream js, ExampleArgs exArgs) {
            this.js = js;
            this.exArgs = exArgs;
        }

        @Override
        public void run() {
            for (int x = 1; x <= this.exArgs.msgCount; ++x) {
                try {
                    PublishAck publishAck = this.js.publish(this.exArgs.subject, ("Data # " + x).getBytes(StandardCharsets.US_ASCII));
                    continue;
                }
                catch (JetStreamApiException | IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        }
    }
}

