/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream.simple;

import io.nats.client.Connection;
import io.nats.client.ConsumerContext;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.MessageConsumer;
import io.nats.client.MessageHandler;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.StreamContext;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.examples.jetstream.NatsJsUtils;
import io.nats.examples.jetstream.ResilientPublisher;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class MessageConsumerExample {
    private static final String STREAM = "consume-stream";
    private static final String SUBJECT = "consume-subject";
    private static final String CONSUMER_NAME = "consume-consumer";
    private static final String MESSAGE_PREFIX = "consume";
    private static final int STOP_COUNT = 500;
    private static final int REPORT_EVERY = 100;
    private static final String SERVER = "nats://localhost:4222";

    public static void main(String[] args) {
        Options options = Options.builder().server(SERVER).build();
        try (Connection nc = Nats.connect(options);){
            ConsumerContext consumerContext;
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createOrReplaceStream(jsm, STREAM, SUBJECT);
            System.out.println("Starting publish...");
            ResilientPublisher publisher = new ResilientPublisher(nc, jsm, STREAM, SUBJECT).basicDataPrefix(MESSAGE_PREFIX).jitter(10L);
            Thread pubThread = new Thread(publisher);
            pubThread.start();
            try {
                StreamContext streamContext = nc.getStreamContext(STREAM);
                streamContext.createOrUpdateConsumer(ConsumerConfiguration.builder().durable(CONSUMER_NAME).build());
                consumerContext = streamContext.getConsumerContext(CONSUMER_NAME);
            }
            catch (JetStreamApiException | IOException e) {
                if (nc != null) {
                    if (var3_4 != null) {
                        try {
                            nc.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        nc.close();
                    }
                }
                return;
            }
            CountDownLatch latch = new CountDownLatch(1);
            AtomicInteger atomicCount = new AtomicInteger();
            long start = System.nanoTime();
            MessageHandler handler = msg -> {
                msg.ack();
                int count = atomicCount.incrementAndGet();
                if (count % 100 == 0) {
                    MessageConsumerExample.report("Handler", start, count);
                }
                if (count == 500) {
                    latch.countDown();
                }
            };
            try (MessageConsumer consumer = consumerContext.consume(handler);){
                latch.await();
                System.out.println("Stop the consumer...");
                consumer.stop();
                while (!consumer.isFinished()) {
                    Thread.sleep(10L);
                }
            }
            catch (JetStreamApiException | IOException e) {
                System.err.println("Exception should be handled properly, just exiting here.");
                System.exit(-1);
            }
            catch (Exception e) {
                System.err.println("Exception should be handled properly, just exiting here.");
                System.exit(-1);
            }
            MessageConsumerExample.report("Final", start, atomicCount.get());
            publisher.stop();
            pubThread.join();
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
    }

    private static void report(String label, long start, int count) {
        long ms = (System.nanoTime() - start) / 1000000L;
        System.out.println(label + ": Received " + count + " messages in " + ms + "ms.");
    }
}

