/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream.simple;

import io.nats.client.Connection;
import io.nats.client.ConsumeOptions;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.MessageConsumer;
import io.nats.client.MessageHandler;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.OrderedConsumerContext;
import io.nats.client.StreamContext;
import io.nats.client.api.OrderedConsumerConfiguration;
import io.nats.client.api.StorageType;
import io.nats.client.impl.ErrorListenerConsoleImpl;
import io.nats.examples.jetstream.NatsJsUtils;
import io.nats.examples.jetstream.ResilientPublisher;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class OrderedMessageConsumerExample {
    private static final String STREAM = "ordered-stream";
    private static final String SUBJECT = "ordered-subject";
    private static final String CONSUMER_PREFIX = "prefix";
    private static final String MESSAGE_PREFIX = "ordered";
    private static final int STOP_COUNT = 1000000;
    private static final int REPORT_EVERY = 500;
    private static final String SERVER = "nats://localhost:4222";

    public static void main(String[] args) {
        Options options = Options.builder().server(SERVER).connectionListener((c, e) -> System.out.println(e.name())).errorListener(new ErrorListenerConsoleImpl()).build();
        try (Connection nc = Nats.connect(options);){
            OrderedConsumerContext orderedConsumerContext;
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createOrReplaceStream(jsm, STREAM, StorageType.File, SUBJECT);
            System.out.println("Starting publish...");
            ResilientPublisher publisher = new ResilientPublisher(nc, jsm, STREAM, SUBJECT).basicDataPrefix(MESSAGE_PREFIX).jitter(10L);
            Thread pubThread = new Thread(publisher);
            pubThread.start();
            try {
                OrderedConsumerConfiguration ocConfig = new OrderedConsumerConfiguration().consumerNamePrefix(CONSUMER_PREFIX).filterSubjects(SUBJECT);
                StreamContext streamContext = nc.getStreamContext(STREAM);
                orderedConsumerContext = streamContext.createOrderedConsumer(ocConfig);
            }
            catch (JetStreamApiException | IOException e2) {
                if (nc != null) {
                    if (var3_4 != null) {
                        try {
                            nc.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        nc.close();
                    }
                }
                return;
            }
            CountDownLatch latch = new CountDownLatch(1);
            AtomicInteger atomicCount = new AtomicInteger();
            AtomicLong nextExpectedSequence = new AtomicLong(0L);
            long start = System.nanoTime();
            MessageHandler handler = msg -> {
                if (msg.metaData().streamSequence() != nextExpectedSequence.incrementAndGet()) {
                    System.out.println("MESSAGE RECEIVED OUT OF ORDER!");
                    System.exit(-1);
                }
                msg.ack();
                int count = atomicCount.incrementAndGet();
                if (count % 500 == 0) {
                    OrderedMessageConsumerExample.report("Handler", start, count);
                }
                if (count == 1000000) {
                    latch.countDown();
                }
            };
            ConsumeOptions consumeOptions = ((ConsumeOptions.Builder)ConsumeOptions.builder().expiresIn(1000L)).build();
            try (MessageConsumer consumer = orderedConsumerContext.consume(consumeOptions, handler);){
                latch.await();
                System.out.println("Stop the consumer...");
                consumer.stop();
                while (!consumer.isFinished()) {
                    Thread.sleep(10L);
                }
            }
            catch (JetStreamApiException | IOException e3) {
                System.err.println("Exception should be handled properly, just exiting here.");
                System.exit(-1);
            }
            catch (Exception e4) {
                System.err.println("Exception should be handled properly, just exiting here.");
                System.exit(-1);
            }
            OrderedMessageConsumerExample.report("Final", start, atomicCount.get());
            publisher.stop();
            pubThread.join();
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
    }

    private static void report(String label, long start, int count) {
        long ms = (System.nanoTime() - start) / 1000000L;
        System.out.println(label + ": Received " + count + " messages in " + ms + "ms.");
    }
}

