/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.natsIoDoc;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Message;
import io.nats.client.Nats;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;

public class QueueGroupsMixedSubscribers {
    public static void main(String[] args) {
        try (Connection nc = Nats.connect("nats://localhost:4222");){
            Dispatcher dService1 = nc.createDispatcher(msg -> {
                byte[] response = QueueGroupsMixedSubscribers.calculateResponse(1, msg);
                nc.publish(msg.getReplyTo(), response);
            });
            dService1.subscribe("api.calculate", "api-workers-queue");
            Dispatcher dService2 = nc.createDispatcher(msg -> {
                byte[] response = QueueGroupsMixedSubscribers.calculateResponse(2, msg);
                nc.publish(msg.getReplyTo(), response);
            });
            dService2.subscribe("api.calculate", "api-workers-queue");
            Dispatcher dService3 = nc.createDispatcher(msg -> {
                byte[] response = QueueGroupsMixedSubscribers.calculateResponse(3, msg);
                nc.publish(msg.getReplyTo(), response);
            });
            dService3.subscribe("api.calculate", "api-workers-queue");
            for (int x = 0; x < 10; ++x) {
                Message m = nc.request("api.calculate", null, Duration.ofMillis(500L));
                if (m == null) {
                    System.out.println(x + ") No Response");
                    continue;
                }
                System.out.println(x + ") " + new String(m.getData()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static byte[] calculateResponse(int i, Message msg) {
        return ("Result from service instance " + i).getBytes(StandardCharsets.UTF_8);
    }
}

