/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.natsIoDoc;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Message;
import io.nats.client.Nats;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestReplyMultipleResponders {
    public static void main(String[] args) {
        try (Connection nc = Nats.connect("nats://localhost:4222");){
            Message m;
            Dispatcher dService1 = nc.createDispatcher(msg -> {
                byte[] response = RequestReplyMultipleResponders.calculateResponse(1, msg);
                nc.publish(msg.getReplyTo(), response);
            });
            dService1.subscribe("service");
            Dispatcher dService2 = nc.createDispatcher(msg -> {
                byte[] response = RequestReplyMultipleResponders.calculateResponse(2, msg);
                nc.publish(msg.getReplyTo(), response);
            });
            dService2.subscribe("service");
            CompletableFuture<Message> responseFuture = nc.request("service", null);
            try {
                m = responseFuture.get(500L, TimeUnit.MILLISECONDS);
                System.out.println("1) " + new String(m.getData()));
            }
            catch (CancellationException | ExecutionException | TimeoutException e) {
                System.out.println("1) No Response");
            }
            m = nc.request("service", null, Duration.ofMillis(500L));
            if (m == null) {
                System.out.println("2) No Response");
            } else {
                System.out.println("2) " + new String(m.getData()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static byte[] calculateResponse(int i, Message msg) {
        return ("Result from service instance " + i).getBytes(StandardCharsets.UTF_8);
    }
}

