/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.natsIoDoc;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.Nats;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestReplyTimeout {
    public static void main(String[] args) {
        try (Connection nc = Nats.connect("nats://localhost:4222");){
            Message m;
            CompletableFuture<Message> responseFuture = nc.request("service", null);
            try {
                m = responseFuture.get(500L, TimeUnit.MILLISECONDS);
                System.out.println("1) Response: " + new String(m.getData()));
            }
            catch (CancellationException | ExecutionException | TimeoutException e) {
                System.out.println("1) No Response: " + e);
            }
            m = nc.request("service", null, Duration.ofMillis(500L));
            if (m == null) {
                System.out.println("2) No Response");
            } else {
                System.out.println("2) Response: " + new String(m.getData()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

