/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.service;

import io.nats.client.Connection;
import io.nats.client.ErrorListener;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.service.Discovery;
import io.nats.service.Endpoint;
import io.nats.service.Group;
import io.nats.service.InfoResponse;
import io.nats.service.PingResponse;
import io.nats.service.Service;
import io.nats.service.ServiceBuilder;
import io.nats.service.ServiceEndpoint;
import io.nats.service.ServiceMessage;
import io.nats.service.StatsResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;

public class ServiceExample {
    public static void main(String[] args) throws IOException {
        Options options = new Options.Builder().server("nats://localhost:4222").errorListener(new ErrorListener(){}).build();
        try (Connection nc = Nats.connect(options);){
            Endpoint epEcho = Endpoint.builder().name("EchoEndpoint").subject("echo").build();
            Group sortGroup = new Group("sort");
            ServiceEndpoint seEcho1 = ServiceEndpoint.builder().endpoint(epEcho).handler(msg -> ServiceExample.handleEchoMessage(nc, msg, "S1E")).statsDataSupplier(new ExampleStatsDataSupplier()).build();
            ServiceEndpoint seEcho2 = ServiceEndpoint.builder().endpoint(epEcho).handler(msg -> ServiceExample.handleEchoMessage(nc, msg, "S2E")).build();
            ServiceEndpoint seSort1A = ServiceEndpoint.builder().group(sortGroup).endpointName("SortEndpointAscending").endpointSubject("ascending").handler(msg -> ServiceExample.handleSortAscending(nc, msg, "S1A")).build();
            Endpoint endSortD = new Endpoint("SortEndpointDescending", "descending");
            ServiceEndpoint seSort1D = ServiceEndpoint.builder().group(sortGroup).endpoint(endSortD).handler(msg -> ServiceExample.handlerSortDescending(nc, msg, "S1D")).build();
            Service service1 = new ServiceBuilder().connection(nc).name("Service1").description("Service1 Description").version("0.0.1").addServiceEndpoint(seEcho1).addServiceEndpoint(seSort1A).addServiceEndpoint(seSort1D).build();
            Service service2 = new ServiceBuilder().connection(nc).name("Service2").version("0.0.1").addServiceEndpoint(seEcho2).build();
            System.out.println("\n" + service1);
            System.out.println("\n" + service2);
            CompletableFuture<Boolean> serviceStoppedFuture1 = service1.startService();
            CompletableFuture<Boolean> serviceStoppedFuture2 = service2.startService();
            System.out.println();
            String request = null;
            for (int x = 1; x <= 9; ++x) {
                request = ServiceExample.randomText();
                String subject = "echo";
                CompletableFuture<Message> reply = nc.request(subject, request.getBytes());
                String response = new String(reply.get().getData());
                System.out.println(x + ". Called " + subject + " with [" + request + "] Received " + response);
            }
            String subject = "sort.ascending";
            CompletableFuture<Message> reply = nc.request(subject, request.getBytes());
            String response = new String(reply.get().getData());
            System.out.println("1. Called " + subject + " with [" + request + "] Received " + response);
            subject = "sort.descending";
            reply = nc.request(subject, request.getBytes());
            response = new String(reply.get().getData());
            System.out.println("1. Called " + subject + " with [" + request + "] Received " + response);
            Discovery discovery = new Discovery(nc, 1000L, 3);
            List<PingResponse> pingResponses = discovery.ping();
            ServiceExample.printDiscovery("Ping", "[All]", pingResponses);
            pingResponses = discovery.ping("Service1");
            ServiceExample.printDiscovery("Ping", "Service1", pingResponses);
            pingResponses = discovery.ping("Service2");
            ServiceExample.printDiscovery("Ping", "Service2", pingResponses);
            List<InfoResponse> infoResponses = discovery.info();
            ServiceExample.printDiscovery("Info", "[All]", infoResponses);
            infoResponses = discovery.info("Service1");
            ServiceExample.printDiscovery("Info", "Service1", infoResponses);
            infoResponses = discovery.info("Service2");
            ServiceExample.printDiscovery("Info", "Service2", infoResponses);
            List<StatsResponse> statsResponseList = discovery.stats();
            ServiceExample.printDiscovery("Stats", "[All]", statsResponseList);
            statsResponseList = discovery.stats("Service1");
            ServiceExample.printDiscovery("Stats", "Service1", statsResponseList);
            statsResponseList = discovery.stats("Service2");
            ServiceExample.printDiscovery("Stats", "Service2", statsResponseList);
            service1.stop();
            service2.stop();
            System.out.println("\nService 1 stopped ? " + serviceStoppedFuture1.get(1L, TimeUnit.SECONDS));
            System.out.println("Service 2 stopped ? " + serviceStoppedFuture2.get(2L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static JsonValue replyBody(String label, byte[] data, String handlerId) {
        return JsonValueUtils.mapBuilder().put(label, new String(data)).put("hid", handlerId).toJsonValue();
    }

    private static void handlerSortDescending(Connection nc, ServiceMessage smsg, String handlerId) {
        byte[] data = smsg.getData();
        Arrays.sort(data);
        int len = data.length;
        byte[] descending = new byte[len];
        for (int x = 0; x < len; ++x) {
            descending[x] = data[len - x - 1];
        }
        smsg.respond(nc, ServiceExample.replyBody("sort_descending", descending, handlerId));
    }

    private static void handleSortAscending(Connection nc, ServiceMessage smsg, String handlerId) {
        byte[] ascending = smsg.getData();
        Arrays.sort(ascending);
        smsg.respond(nc, ServiceExample.replyBody("sort_ascending", ascending, handlerId));
    }

    private static void handleEchoMessage(Connection nc, ServiceMessage smsg, String handlerId) {
        smsg.respond(nc, ServiceExample.replyBody("echo", smsg.getData(), handlerId));
    }

    private static void printDiscovery(String action, String label, List objects) {
        System.out.println("\n" + action + " " + label);
        for (Object o : objects) {
            System.out.println("  " + o);
        }
    }

    static String randomText() {
        return Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.nanoTime());
    }

    static class ExampleStatsDataSupplier
    implements Supplier<JsonValue> {
        int x = 0;

        ExampleStatsDataSupplier() {
        }

        @Override
        public JsonValue get() {
            ++this.x;
            return new ExampleStatsData("s-" + this.hashCode(), this.x).toJsonValue();
        }
    }

    static class ExampleStatsData
    implements JsonSerializable {
        public String sData;
        public int iData;

        public ExampleStatsData(String sData, int iData) {
            this.sData = sData;
            this.iData = iData;
        }

        @Override
        public @NonNull String toJson() {
            return this.toJsonValue().toJson();
        }

        @Override
        public @NonNull JsonValue toJsonValue() {
            HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
            map.put("sdata", new JsonValue(this.sData));
            map.put("idata", new JsonValue(this.iData));
            return new JsonValue(map);
        }

        public String toString() {
            return this.toJsonValue().toString(this.getClass());
        }
    }
}

