/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.aries.util;

import java.util.Objects;

public class AttachmentKey<T> {
    private final String name;
    private final Class<T> type;

    public AttachmentKey(Class<T> type) {
        this(type.getName(), type);
    }

    public AttachmentKey(String name, Class<T> type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentKey other = (AttachmentKey)obj;
        return this.type.equals(other.type) && this.name.equals(this.name);
    }

    public String toString() {
        String cname = this.type.getName();
        if (cname.equals(this.name)) {
            return String.format("[type=%s]", cname);
        }
        return String.format("[name=%s,type=%s]", this.name, cname);
    }
}

