/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.bitcoin;

import io.nessus.AbstractWallet;
import io.nessus.RpcClientSupport;
import io.nessus.Wallet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;

public class BitcoinAddress
extends RpcClientSupport
implements Wallet.Address {
    private final AbstractWallet wallet;
    private final String address;
    private final boolean watchOnly;
    private final List<String> addrLabels;

    public BitcoinAddress(AbstractWallet wallet, String address, List<String> labels) {
        super(wallet.getRpcClient());
        this.wallet = wallet;
        this.address = address;
        this.watchOnly = this.getPrivKey() == null;
        this.addrLabels = Collections.unmodifiableList(new ArrayList<String>(labels));
    }

    public String getPrivKey() {
        String privKey = null;
        try {
            privKey = this.client.dumpPrivKey(this.address);
        }
        catch (BitcoinRPCException bitcoinRPCException) {
            // empty catch block
        }
        return privKey;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isWatchOnly() {
        return this.watchOnly;
    }

    public List<String> getLabels() {
        return Collections.unmodifiableList(this.addrLabels);
    }

    public Wallet.Address setLabels(List<String> labels) {
        return this.wallet.updateAddress((Wallet.Address)this, labels);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Wallet.Address)) {
            return false;
        }
        Wallet.Address other = (Wallet.Address)obj;
        return this.address.equals(other.getAddress());
    }

    public String toString() {
        return String.format("[addr=%s, ro=%b, labels=%s]", this.address, this.watchOnly, this.addrLabels);
    }
}

