/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateUtils {
    private static ThreadLocal<SimpleDateFormat> tstampAssociation = new ThreadLocal();
    private static ThreadLocal<SimpleDateFormat> dateAssociation = new ThreadLocal();

    public static String format(Date tstamp) {
        return DateUtils.getTimestampFormat().format(tstamp);
    }

    public static String format(Date tstamp, boolean dateOnly) {
        SimpleDateFormat sdf = dateOnly ? DateUtils.getDateFormat() : DateUtils.getTimestampFormat();
        return sdf.format(tstamp);
    }

    public static Date parse(String tstr) {
        try {
            if (tstr.contains(" ")) {
                return DateUtils.getTimestampFormat().parse(tstr);
            }
            return DateUtils.getDateFormat().parse(tstr);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static long elapsedTime(Date startTime) {
        return DateUtils.elapsedTime(startTime, new Date(), TimeUnit.MILLISECONDS);
    }

    public static long elapsedTime(Date startTime, TimeUnit unit) {
        return DateUtils.elapsedTime(startTime, new Date(), unit);
    }

    public static long elapsedTime(Date startTime, Date endTime) {
        return DateUtils.elapsedTime(startTime, endTime, TimeUnit.MILLISECONDS);
    }

    public static long elapsedTime(Date startTime, Date endTime, TimeUnit unit) {
        long elapsed = endTime.getTime() - startTime.getTime();
        return elapsed / unit.toMillis(1L);
    }

    public static String elapsedTimeString(Date startTime) {
        return DateUtils.elapsedTimeString(startTime, new Date());
    }

    public static String elapsedTimeString(Date startTime, Date endTime) {
        return DateUtils.elapsedTimeString(DateUtils.elapsedTime(startTime, endTime, TimeUnit.MILLISECONDS));
    }

    public static String elapsedTimeString(Long millis) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
        long hours = seconds / 3600L;
        long mins = (seconds - hours * 3600L) / 60L;
        long secs = (seconds - hours * 3600L) % 60L;
        return String.format("%02d:%02d:%02d", hours, mins, secs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getTimestampFormat() {
        ThreadLocal<SimpleDateFormat> threadLocal = tstampAssociation;
        synchronized (threadLocal) {
            SimpleDateFormat format = tstampAssociation.get();
            if (format == null) {
                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                tstampAssociation.set(format);
            }
            return format;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getDateFormat() {
        ThreadLocal<SimpleDateFormat> threadLocal = dateAssociation;
        synchronized (threadLocal) {
            SimpleDateFormat format = dateAssociation.get();
            if (format == null) {
                format = new SimpleDateFormat("yyyy-MM-dd");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                dateAssociation.set(format);
            }
            return format;
        }
    }
}

