/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HttpRequest {
    private HttpRequest() {
    }

    public static HttpRequestBuilder get(String url) {
        return new HttpRequestBuilder(url, "GET");
    }

    public static HttpRequestBuilder post(String url) {
        return new HttpRequestBuilder(url, "POST");
    }

    public static HttpRequestBuilder put(String url) {
        return new HttpRequestBuilder(url, "PUT");
    }

    public static HttpRequestBuilder delete(String url) {
        return new HttpRequestBuilder(url, "DELETE");
    }

    public static HttpRequestBuilder options(String url) {
        return new HttpRequestBuilder(url, "OPTIONS");
    }

    public static class HttpResponse {
        private int statusCode;
        private String body;
        private Map<String, String> headers = new HashMap<String, String>();

        public int getStatusCode() {
            return this.statusCode;
        }

        void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public String getBody() {
            return this.body;
        }

        void setBody(String body) {
            this.body = body;
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(this.headers);
        }

        public String getHeader(String headerName) {
            return this.headers.get(headerName);
        }

        void addHeader(String header, String value) {
            this.headers.put(header, value);
        }

        public String toString() {
            return "HttpResponse{statusCode=" + this.statusCode + ", body='" + this.body + '\'' + ", headers=" + this.headers + '}';
        }
    }

    public static final class HttpRequestBuilder {
        private String requestUrl;
        private String method;
        private String content;
        private boolean followRedirects = true;
        private boolean throwExceptionOnFailure = true;
        private Map<String, String> headers = new HashMap<String, String>();
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        private long timeout = 10000L;

        public HttpRequestBuilder(String url, String method) {
            this.requestUrl = url;
            this.method = method;
        }

        public HttpRequestBuilder content(String value) {
            this.content = value;
            return this;
        }

        public HttpRequestBuilder followRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public HttpRequestBuilder header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public HttpRequestBuilder throwExceptionOnFailure(boolean value) {
            this.throwExceptionOnFailure = value;
            return this;
        }

        public HttpRequestBuilder timeout(long value) {
            this.timeUnit = TimeUnit.MILLISECONDS;
            this.timeout = value;
            return this;
        }

        public HttpRequestBuilder timeout(long value, TimeUnit unit) {
            this.timeout = value;
            this.timeUnit = unit;
            return this;
        }

        public HttpResponse getResponse() throws TimeoutException, IOException, ExecutionException {
            Callable<HttpResponse> task = new Callable<HttpResponse>(){

                @Override
                public HttpResponse call() throws Exception {
                    URL url = new URL(requestUrl);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setDoInput(true);
                    conn.setRequestMethod(method);
                    conn.setInstanceFollowRedirects(followRedirects);
                    Set headerNames = headers.keySet();
                    for (String headerName : headerNames) {
                        conn.setRequestProperty(headerName, (String)headers.get(headerName));
                    }
                    if (method.equals("POST") || method.equals("PUT")) {
                        conn.setDoOutput(true);
                    }
                    if (content != null && !content.isEmpty()) {
                        OutputStream outputStream = conn.getOutputStream();
                        outputStream.write(content.getBytes("UTF-8"));
                        outputStream.flush();
                        outputStream.close();
                    }
                    return this.processResponse(conn);
                }
            };
            return this.executeRequest(task, this.timeout, this.timeUnit);
        }

        private HttpResponse executeRequest(Callable<HttpResponse> task, long timeout, TimeUnit unit) throws TimeoutException, IOException, ExecutionException {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<HttpResponse> result = executor.submit(task);
            try {
                HttpResponse httpResponse = result.get(timeout, unit);
                return httpResponse;
            }
            catch (TimeoutException e) {
                result.cancel(true);
                throw e;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                throw e;
            }
            finally {
                executor.shutdownNow();
                try {
                    executor.awaitTermination(timeout, unit);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private String read(InputStream in) throws IOException {
            int b;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            return out.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private HttpResponse processResponse(HttpURLConnection conn) {
            HttpResponse response = new HttpResponse();
            try {
                InputStream err;
                int responseCode = conn.getResponseCode();
                response.setStatusCode(responseCode);
                Map<String, List<String>> headerFields = conn.getHeaderFields();
                for (String headerName : headerFields.keySet()) {
                    response.addHeader(headerName, conn.getHeaderField(headerName));
                }
                if (this.throwExceptionOnFailure && responseCode != 200 && (err = conn.getErrorStream()) != null) {
                    try {
                        response.setBody(this.read(err));
                        HttpResponse httpResponse = response;
                        return httpResponse;
                    }
                    finally {
                        err.close();
                    }
                }
                try (InputStream in = conn.getInputStream();){
                    response.setBody(this.read(in));
                    return response;
                }
            }
            catch (FileNotFoundException e) {
                response.setStatusCode(404);
                return response;
            }
            catch (IOException e) {
                Pattern pattern = Pattern.compile(".*?([0-9]{3}).*");
                Matcher matcher = pattern.matcher(e.getMessage());
                if (!matcher.matches()) return response;
                response.setStatusCode(Integer.parseInt(matcher.group(1)));
            }
            return response;
        }
    }
}

