/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.nessus.common.AssertArg;
import io.nessus.common.Config;
import io.nessus.common.Parameters;
import io.nessus.common.service.Service;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.LogManager;
import org.slf4j.bridge.SLF4JBridgeHandler;

@JsonSerialize(using=ConfigSerializer.class)
public class BasicConfig
implements Config {
    private final Map<String, Service> services = new LinkedHashMap<String, Service>();
    private final Parameters params;

    public BasicConfig(URL cfgurl) throws IOException {
        AssertArg.notNull(cfgurl, "Null cfgurl");
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        Config cfg = (Config)mapper.readValue(cfgurl, BasicConfig.class);
        this.params = cfg.getParameters();
    }

    @JsonCreator
    public BasicConfig(Map<String, ? extends Object> params) {
        this.params = new Parameters(params);
    }

    public BasicConfig(Parameters params) {
        this.params = new Parameters(params);
    }

    @Override
    public Parameters getParameters() {
        return new Parameters(this.params);
    }

    @Override
    public <T> T getParameter(String name, Class<T> type) {
        return (T)this.params.get(name, type);
    }

    @Override
    public <T> T getParameter(String name, T defaultValue) {
        return this.params.get(name, defaultValue);
    }

    @Override
    public <T> T putParameter(String name, T value) {
        return this.params.put(name, value);
    }

    @Override
    public <T extends Service> void addService(T service) {
        this.services.put(service.getType(), service);
    }

    @Override
    public <T extends Service> T getService(Class<T> type) {
        Service result = this.services.get(type.getName());
        if (result == null) {
            for (Service srv : this.services.values()) {
                if (!type.isAssignableFrom(srv.getClass())) continue;
                result = srv;
                break;
            }
        }
        return (T)result;
    }

    @Override
    public void initServices() {
        this.services.values().forEach(srv -> srv.init(this));
    }

    public int hashCode() {
        return this.params.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Config)) {
            return false;
        }
        Config other = (Config)obj;
        return this.params.equals(other.getParameters());
    }

    public String toString() {
        return this.params.toString();
    }

    static {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.install();
    }

    public static class ConfigSerializer
    extends JsonSerializer<Config> {
        public void serialize(Config value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            Map<String, Object> map = value.getParameters().toMap();
            jgen.writeObject(map);
        }
    }
}

