/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common;

import io.nessus.common.AssertState;
import io.nessus.common.Config;
import io.nessus.common.service.LogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class LogSupport {
    protected final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    private LogService logService;

    public abstract Config getConfig();

    public void logError(Throwable th) {
        this.log(Level.ERROR, th, null, new Object[0]);
    }

    public void logError(Throwable th, String msg) {
        this.log(Level.ERROR, th, msg, new Object[0]);
    }

    public void logError(String msg, Object ... args) {
        this.log(Level.ERROR, msg, args);
    }

    public void logWarn(String msg, Object ... args) {
        this.log(Level.WARN, msg, args);
    }

    public void logInfo() {
        this.logInfo(" ", new Object[0]);
    }

    public void logInfo(String msg, Object ... args) {
        this.log(Level.INFO, msg, args);
    }

    public void logDebug(String msg, Object ... args) {
        this.log(Level.DEBUG, msg, args);
    }

    public void logTrace(String msg, Object ... args) {
        this.log(Level.TRACE, msg, args);
    }

    public void log(Level level, String msg, Object ... args) {
        this.log(level, null, msg, args);
    }

    public void log(Level level, Throwable th, String msg, Object ... args) {
        this.getLogService().log(this.LOG, level, th, msg, args);
    }

    public boolean isEnabled(Level level) {
        if (level == Level.ERROR) {
            return this.LOG.isErrorEnabled();
        }
        if (level == Level.WARN) {
            return this.LOG.isWarnEnabled();
        }
        if (level == Level.INFO) {
            return this.LOG.isInfoEnabled();
        }
        if (level == Level.DEBUG) {
            return this.LOG.isDebugEnabled();
        }
        return this.LOG.isTraceEnabled();
    }

    private LogService getLogService() {
        if (this.logService == null) {
            this.logService = this.getConfig().getService(LogService.class);
            AssertState.notNull(this.logService, "No LogService registered");
            this.logService.init(this.getConfig());
        }
        return this.logService;
    }
}

