/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.impl;

import io.nessus.cmd.CmdLineClient;
import io.nessus.cmd.CmdLineException;
import io.nessus.cmd.CmdLineTimeoutException;
import io.nessus.ipfs.IPFSClient;
import io.nessus.ipfs.IPFSException;
import io.nessus.ipfs.IPFSTimeoutException;
import io.nessus.ipfs.MerkleNotFoundException;
import io.nessus.utils.AssertState;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdLineIPFSClient
extends CmdLineClient
implements IPFSClient {
    static final Logger LOG = LoggerFactory.getLogger(CmdLineIPFSClient.class);
    final String[] opts;

    public CmdLineIPFSClient() {
        String host = System.getenv("IPFS_API_HOST");
        if (host != null) {
            String port = System.getenv("IPFS_API_PORT");
            port = port != null ? port : "5001";
            this.opts = new String[]{String.format("--api=/ip4/%s/tcp/%s", host, port)};
        } else {
            this.opts = null;
        }
    }

    @Override
    public String add(Path path, boolean recursive) {
        String cmd = recursive ? "add -r" : "add";
        String res = this.execIPFS(this.concat(cmd, new Object[]{path}));
        String[] toks = this.split(res);
        AssertState.assertEquals((Object)"added", (Object)toks[0]);
        return toks[1];
    }

    @Override
    public String cat(String cid) {
        return this.execIPFS(this.concat("cat", new Object[]{cid}));
    }

    @Override
    public String get(String cid, Path outdir) {
        return this.execIPFS(this.concat("get", new Object[]{"-o " + outdir, cid}));
    }

    @Override
    public String get(String cid, Path outdir, Long timeout, TimeUnit unit) {
        return this.execIPFS(this.concat("get", new Object[]{"-o " + outdir, cid}), timeout, unit);
    }

    @Override
    public String version() {
        return this.execIPFS(this.concat("version", null));
    }

    private String execIPFS(String cmdLine) {
        return this.execIPFS(cmdLine, null, null);
    }

    private String execIPFS(String cmdLine, Long timeout, TimeUnit unit) {
        try {
            return this.exec(cmdLine, timeout, unit);
        }
        catch (CmdLineTimeoutException ex) {
            throw new IPFSTimeoutException(cmdLine, ex);
        }
        catch (CmdLineException ex) {
            Throwable cause = ex.getCause();
            if (cause != null && "Error: merkledag: not found".equals(cause.getMessage())) {
                cause = new MerkleNotFoundException(cmdLine);
            }
            throw new IPFSException(cmdLine, cause);
        }
    }

    private String concat(String cmd, Object[] args) {
        StringBuffer line = new StringBuffer("ipfs");
        for (String opt : this.opts != null ? this.opts : new String[]{}) {
            line.append(" " + opt);
        }
        line.append(" " + cmd);
        for (Object arg : args != null ? args : new String[]{}) {
            line.append(" " + arg);
        }
        return line.toString();
    }

    private String[] split(String result) {
        return result.split(" ");
    }
}

