/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.impl;

import io.nessus.AbstractWallet;
import io.nessus.Blockchain;
import io.nessus.Network;
import io.nessus.RpcClientSupport;
import io.nessus.Tx;
import io.nessus.TxOutput;
import io.nessus.UTXO;
import io.nessus.Wallet;
import io.nessus.cipher.AESCipher;
import io.nessus.cipher.ECIESCipher;
import io.nessus.ipfs.ContentManager;
import io.nessus.ipfs.FHandle;
import io.nessus.ipfs.IPFSClient;
import io.nessus.ipfs.IPFSException;
import io.nessus.ipfs.IPFSTimeoutException;
import io.nessus.ipfs.MerkleNotFoundException;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import io.nessus.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;

public class DefaultContentManager
implements ContentManager {
    public static final int DEFAULT_IPFS_ATTEMPTS = 30;
    public static final long DEFAULT_IPFS_TIMEOUT = 10000L;
    public static final int DEFAULT_IPFS_THREADS = 12;
    static final Logger LOG = LoggerFactory.getLogger(DefaultContentManager.class);
    protected final Blockchain blockchain;
    protected final Network network;
    protected final Wallet wallet;
    protected final HValues hvals;
    protected final IPFSClient ipfs;
    protected final BCData bcdata;
    protected final Path rootPath;
    final ExecutorService executorService;
    private final IPFSFileCache filecache = new IPFSFileCache();
    private final long ipfsTimeout;
    private final int ipfsAttempts;
    private final int ipfsThreads;

    public DefaultContentManager(IPFSClient ipfs, Blockchain blockchain) {
        this(ipfs, blockchain, 10000L, 30, 12);
    }

    public DefaultContentManager(IPFSClient ipfs, Blockchain blockchain, Long timeout, Integer attepts, Integer threads) {
        this.blockchain = blockchain;
        this.ipfs = ipfs;
        this.network = blockchain.getNetwork();
        this.wallet = blockchain.getWallet();
        this.rootPath = Paths.get(System.getProperty("user.home"), ".fman");
        this.rootPath.toFile().mkdirs();
        this.hvals = this.getHeaderValues();
        this.bcdata = new BCData(this.hvals);
        this.ipfsTimeout = timeout != null ? timeout : 10000L;
        this.ipfsAttempts = attepts != null ? attepts : 30;
        this.ipfsThreads = threads != null ? threads : 12;
        LOG.info("DefaultContentManager[timeout={}, attempts={}, threads={}]", new Object[]{this.ipfsTimeout, this.ipfsAttempts, this.ipfsThreads});
        this.executorService = Executors.newFixedThreadPool(this.ipfsThreads, new ThreadFactory(){
            AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable run) {
                return new Thread(run, "ipfs-pool-" + this.count.incrementAndGet());
            }
        });
    }

    public long getIPFSTimeout() {
        return this.ipfsTimeout;
    }

    public int getIPFSAttempts() {
        return this.ipfsAttempts;
    }

    public int getIPFSThreads() {
        return this.ipfsThreads;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    @Override
    public Blockchain getBlockchain() {
        return this.blockchain;
    }

    @Override
    public IPFSClient getIPFSClient() {
        return this.ipfs;
    }

    @Override
    public PublicKey register(Wallet.Address addr) throws GeneralSecurityException {
        this.assertArgumentHasLabel(addr);
        this.assertArgumentHasPrivateKey(addr);
        this.assertArgumentNoChangeAddress(addr);
        PublicKey pubKey = this.findRegistation(addr);
        if (pubKey != null) {
            return pubKey;
        }
        KeyPair keyPair = this.getECKeyPair(addr);
        pubKey = keyPair.getPublic();
        byte[] keyBytes = pubKey.getEncoded();
        byte[] data = this.bcdata.createPubKeyData(keyBytes);
        BigDecimal dustAmount = this.network.getDustThreshold();
        BigDecimal dataAmount = dustAmount.multiply(BigDecimal.TEN);
        BigDecimal spendAmount = dataAmount.add(this.network.getMinDataAmount());
        String label = (String)addr.getLabels().get(0);
        List utxos = this.wallet.selectUnspent(label, this.addFee(spendAmount));
        BigDecimal utxosAmount = this.getUTXOAmount(utxos);
        Wallet.Address changeAddr = this.wallet.getChangeAddress(label);
        BigDecimal changeAmount = utxosAmount.subtract(this.addFee(spendAmount));
        ArrayList<TxOutput> outputs = new ArrayList<TxOutput>();
        if (dustAmount.compareTo(changeAmount) < 0) {
            outputs.add(new TxOutput(changeAddr.getAddress(), changeAmount));
        }
        outputs.add(new TxOutput(addr.getAddress(), dataAmount, data));
        Tx tx = new Tx.TxBuilder().unspentInputs(utxos).outputs(outputs).build();
        String txId = this.wallet.sendTx(tx);
        LOG.info("PubKey register: {} => Tx {}", (Object)addr, (Object)txId);
        tx = this.wallet.getTransaction(txId);
        int vout = tx.outputs().size() - 2;
        TxOutput dataOut = (TxOutput)tx.outputs().get(vout);
        AssertState.assertEquals((Object)addr.getAddress(), (Object)dataOut.getAddress());
        AssertState.assertEquals((Object)dataAmount, (Object)dataOut.getAmount());
        LOG.info("Lock unspent: {} {}", (Object)txId, (Object)vout);
        BitcoindRpcClient client = this.getRpcClient();
        client.lockUnspent(false, txId, vout);
        LOG.info("Redeem change: {}", (Object)changeAmount);
        ((AbstractWallet)this.wallet).redeemChange(label, addr);
        return pubKey;
    }

    @Override
    public FHandle add(Wallet.Address owner, InputStream input, Path path) throws IOException, GeneralSecurityException {
        AssertArgument.assertNotNull((Object)input, (String)"Null input");
        this.assertArgumentHasPrivateKey(owner);
        PublicKey pubKey = this.findRegistation(owner);
        AssertArgument.assertTrue((Boolean)(pubKey != null ? 1 : 0), (String)("Cannot obtain encryption key for: " + owner));
        Path plainPath = this.assertPlainPath(owner, path);
        LOG.info("Start IPFS Add: {} {}", (Object)owner, (Object)path);
        plainPath.getParent().toFile().mkdirs();
        Files.copy(input, plainPath, StandardCopyOption.REPLACE_EXISTING);
        URL furl = plainPath.toFile().toURI().toURL();
        FHandle fhandle = new FHandle.FHBuilder(furl).owner(owner).path(path).build();
        LOG.info("IPFS encrypt: {}", (Object)fhandle);
        fhandle = this.encrypt(fhandle, pubKey);
        LOG.info("IPFS add: {}", (Object)fhandle);
        Path auxPath = Paths.get(fhandle.getURL().getPath(), new String[0]);
        String cid = this.ipfs.addSingle(auxPath);
        Path cryptPath = this.getCryptPath(owner).resolve(cid);
        Path tmpPath = Paths.get(fhandle.getURL().getPath(), new String[0]);
        Files.move(tmpPath, cryptPath, StandardCopyOption.REPLACE_EXISTING);
        furl = cryptPath.toUri().toURL();
        fhandle = new FHandle.FHBuilder(fhandle).url(furl).cid(cid).build();
        LOG.info("IPFS record: {}", (Object)fhandle);
        fhandle = this.recordFileData(fhandle, owner, owner);
        fhandle = new FHandle.FHBuilder(fhandle).available(true).build();
        LOG.info("Done IPFS Add: {}", (Object)fhandle);
        return fhandle;
    }

    @Override
    public FHandle get(Wallet.Address owner, String cid, Path path, Long timeout) throws IOException, GeneralSecurityException {
        this.assertArgumentHasPrivateKey(owner);
        Path plainPath = this.assertPlainPath(owner, path);
        LOG.info("Start IPFS Get: {} {}", (Object)owner, (Object)path);
        FHandle fhandle = this.ipfsGet(cid, timeout);
        LOG.info("IPFS decrypt: {}", (Object)fhandle);
        fhandle = this.decrypt(fhandle, owner, path);
        plainPath.getParent().toFile().mkdirs();
        Path tmpPath = Paths.get(fhandle.getURL().getPath(), new String[0]);
        Files.move(tmpPath, plainPath, StandardCopyOption.REPLACE_EXISTING);
        URL furl = plainPath.toFile().toURI().toURL();
        fhandle = new FHandle.FHBuilder(furl).owner(owner).path(path).build();
        LOG.info("Done IPFS Get: {}", (Object)fhandle);
        return fhandle;
    }

    @Override
    public FHandle send(Wallet.Address owner, String cid, Wallet.Address target, Long timeout) throws IOException, GeneralSecurityException {
        this.assertArgumentHasLabel(owner);
        this.assertArgumentHasPrivateKey(owner);
        this.assertArgumentNoChangeAddress(owner);
        PublicKey pubKey = this.findRegistation(target);
        AssertArgument.assertTrue((Boolean)(pubKey != null ? 1 : 0), (String)("Cannot obtain encryption key for: " + target));
        LOG.info("Start IPFS Send: {} {}", (Object)owner, (Object)cid);
        FHandle fhandle = this.ipfsGet(cid, timeout);
        LOG.info("IPFS decrypt: {}", (Object)fhandle);
        fhandle = this.decrypt(fhandle, owner, null);
        fhandle = new FHandle.FHBuilder(fhandle).owner(target).cid(null).build();
        LOG.info("IPFS encrypt: {}", (Object)fhandle);
        fhandle = this.encrypt(fhandle, pubKey);
        LOG.info("IPFS add: {}", (Object)fhandle);
        Path tmpPath = Paths.get(fhandle.getURL().getPath(), new String[0]);
        cid = this.ipfs.addSingle(tmpPath);
        Path cryptPath = this.getCryptPath(target).resolve(cid);
        Files.move(tmpPath, cryptPath, StandardCopyOption.REPLACE_EXISTING);
        URL furl = cryptPath.toUri().toURL();
        fhandle = new FHandle.FHBuilder(fhandle).url(furl).cid(cid).build();
        LOG.info("IPFS record: {}", (Object)fhandle);
        fhandle = this.recordFileData(fhandle, owner, target);
        LOG.info("Done IPFS Send: {}", (Object)fhandle);
        return fhandle;
    }

    @Override
    public PublicKey findRegistation(Wallet.Address addr) {
        PublicKey pubKey = null;
        List<UTXO> locked = this.listLockedAndUnlockedUnspent(addr, true, false);
        List<UTXO> allUnspent = this.listLockedAndUnlockedUnspent(addr, true, true);
        for (UTXO utxo : allUnspent) {
            String txId = utxo.getTxId();
            Tx tx = this.wallet.getTransaction(txId);
            pubKey = this.getPubKeyFromTx(utxo, addr);
            if (pubKey == null) continue;
            if (locked.contains(utxo) || addr.getPrivKey() == null) break;
            int vout = tx.outputs().size() - 2;
            TxOutput dataOut = (TxOutput)tx.outputs().get(vout);
            AssertState.assertEquals((Object)addr.getAddress(), (Object)dataOut.getAddress());
            LOG.info("Lock unspent: {} {}", (Object)txId, (Object)vout);
            this.wallet.lockUnspent(utxo, false);
            break;
        }
        return pubKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FHandle> findIPFSContent(Wallet.Address addr, Long timeout) throws IOException {
        ArrayList<FHandle> unspentFHandles = new ArrayList<FHandle>();
        IPFSFileCache iPFSFileCache = this.filecache;
        synchronized (iPFSFileCache) {
            List<UTXO> locked = this.listLockedAndUnlockedUnspent(addr, true, false);
            List<UTXO> unspent = this.listLockedAndUnlockedUnspent(addr, true, true);
            for (UTXO utxo : unspent) {
                String txId = utxo.getTxId();
                Tx tx = this.wallet.getTransaction(txId);
                FHandle fhandle = this.getFHandleFromTx(utxo, addr);
                if (fhandle == null) continue;
                unspentFHandles.add(fhandle);
                if (locked.contains(utxo) || addr.getPrivKey() == null) continue;
                int vout = tx.outputs().size() - 2;
                TxOutput dataOut = (TxOutput)tx.outputs().get(vout);
                AssertState.assertEquals((Object)addr.getAddress(), (Object)dataOut.getAddress());
                LOG.info("Lock unspent: {} {}", (Object)txId, (Object)vout);
                this.wallet.lockUnspent(utxo, false);
            }
            List cids = unspentFHandles.stream().map(fh -> fh.getCid()).collect(Collectors.toList());
            for (String cid : new HashSet<String>(this.filecache.keySet())) {
                FHandle aux = this.filecache.get(cid);
                if (!addr.equals(aux.getOwner()) || cids.contains(aux.getCid())) continue;
                this.filecache.remove(cid);
            }
        }
        timeout = timeout != null ? timeout : this.ipfsTimeout;
        List<FHandle> results = this.ipfsGetAsync(unspentFHandles, timeout);
        return results;
    }

    @Override
    public List<FHandle> findLocalContent(Wallet.Address owner) throws IOException {
        return this.findLocalContent(owner, this.getPlainPath(owner), new ArrayList<FHandle>());
    }

    private List<FHandle> findLocalContent(Wallet.Address owner, Path fullPath, List<FHandle> fhandles) throws IOException {
        if (fullPath.toFile().isDirectory()) {
            for (String child : fullPath.toFile().list()) {
                this.findLocalContent(owner, fullPath.resolve(child), fhandles);
            }
        }
        if (fullPath.toFile().isFile()) {
            Path relPath = this.getPlainPath(owner).relativize(fullPath);
            URL furl = fullPath.toUri().toURL();
            FHandle fhandle = new FHandle.FHBuilder(furl).available(true).path(relPath).owner(owner).build();
            fhandles.add(fhandle);
        }
        return fhandles;
    }

    @Override
    public InputStream getLocalContent(Wallet.Address owner, Path path) throws IOException {
        Path plainPath = this.assertPlainPath(owner, path);
        if (!plainPath.toFile().isFile()) {
            return null;
        }
        return new FileInputStream(plainPath.toFile());
    }

    @Override
    public boolean deleteLocalContent(Wallet.Address owner, Path path) throws IOException {
        Path plainPath = this.assertPlainPath(owner, path);
        if (plainPath.toFile().isDirectory()) {
            for (String child : plainPath.toFile().list()) {
                this.deleteLocalContent(owner, path.resolve(child));
            }
        }
        if (plainPath.toFile().isFile()) {
            return plainPath.toFile().delete();
        }
        return false;
    }

    protected BitcoindRpcClient getRpcClient() {
        return ((RpcClientSupport)this.blockchain).getRpcClient();
    }

    protected HValues getHeaderValues() {
        return new HValues("DAT", "1.0");
    }

    Path getPlainPath(Wallet.Address owner) {
        Path path = this.rootPath.resolve("plain").resolve(owner.getAddress());
        path.toFile().mkdirs();
        return path;
    }

    Path getCryptPath(Wallet.Address owner) {
        Path path = this.rootPath.resolve("crypt").resolve(owner.getAddress());
        path.toFile().mkdirs();
        return path;
    }

    Path getTempPath() {
        Path tmpPath = this.rootPath.resolve("tmp");
        tmpPath.toFile().mkdirs();
        return tmpPath;
    }

    Path createTempFile() throws IOException {
        return Files.createTempFile(this.getTempPath(), "", "", new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FHandle ipfsGet(String cid, Long timeout) throws IOException, IPFSTimeoutException {
        Path tmpPath;
        FHandle fhandle;
        IPFSFileCache iPFSFileCache = this.filecache;
        synchronized (iPFSFileCache) {
            fhandle = this.filecache.get(cid);
            if (fhandle != null && !fhandle.isMissing()) {
                return fhandle;
            }
            if (fhandle == null) {
                fhandle = new FHandle.FHBuilder(cid).build();
                this.filecache.put(fhandle);
            }
        }
        long before = System.currentTimeMillis();
        try {
            Future<Path> future = this.ipfs.get(cid, this.getTempPath());
            timeout = timeout != null ? timeout : this.ipfsTimeout;
            tmpPath = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IPFSException) {
                throw (IPFSException)cause;
            }
            throw new IPFSException(ex);
        }
        catch (TimeoutException ex) {
            throw new IPFSTimeoutException(ex);
        }
        finally {
            long elapsed = System.currentTimeMillis() - before;
            fhandle = new FHandle.FHBuilder(fhandle).elapsed(elapsed).build();
            this.filecache.put(fhandle);
        }
        AssertState.assertTrue((Boolean)tmpPath.toFile().exists(), (String)("Cannot obtain file from: " + tmpPath));
        long elapsed = System.currentTimeMillis() - before;
        fhandle = new FHandle.FHBuilder(fhandle).url(tmpPath.toUri().toURL()).elapsed(elapsed).available(true).build();
        try (FileReader fr = new FileReader(tmpPath.toFile());){
            BufferedReader br = new BufferedReader(fr);
            FHeader header = FHeader.read(this.hvals, br);
            Wallet.Address addr = this.getAddress(header.owner);
            AssertState.assertNotNull((Object)addr, (String)("Address unknown to this wallet: " + header.owner));
            LOG.debug("IPFS token: {} => {}", (Object)cid, (Object)header.token);
            fhandle = new FHandle.FHBuilder(fhandle).owner(this.getAddress(header.owner)).secretToken(header.token).path(header.path).build();
        }
        Path cryptPath = this.getCryptPath(fhandle.getOwner()).resolve(cid);
        Files.move(tmpPath, cryptPath, StandardCopyOption.REPLACE_EXISTING);
        fhandle = new FHandle.FHBuilder(fhandle).url(cryptPath.toUri().toURL()).build();
        LOG.info("IPFS found: {}", (Object)fhandle);
        this.filecache.put(fhandle);
        return fhandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FHandle> ipfsGetAsync(final List<FHandle> fhandles, final long timeout) throws IOException {
        List<FHandle> results;
        IPFSFileCache iPFSFileCache = this.filecache;
        synchronized (iPFSFileCache) {
            for (FHandle fhaux : fhandles) {
                String cid = fhaux.getCid();
                FHandle fhc = this.filecache.get(cid);
                if (fhc != null) continue;
                fhc = new FHandle.FHBuilder(fhaux).elapsed(0L).build();
                LOG.info("IPFS submit: {}", (Object)fhc);
                this.filecache.put(fhc);
            }
        }
        Future<List<FHandle>> future = this.executorService.submit(new Callable<List<FHandle>>(){

            @Override
            public List<FHandle> call() throws Exception {
                List missing = DefaultContentManager.this.getMissingFHandles(fhandles);
                while (!missing.isEmpty()) {
                    for (FHandle fh : missing) {
                        if (!fh.setScheduled(true)) continue;
                        AsyncGetCallable callable = new AsyncGetCallable(fh, timeout);
                        DefaultContentManager.this.executorService.submit(callable);
                    }
                    Thread.sleep(500L);
                    missing = DefaultContentManager.this.getMissingFHandles(fhandles);
                }
                return DefaultContentManager.this.getCurrentFHandles(fhandles);
            }
        });
        try {
            results = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IllegalStateException(ex);
        }
        catch (TimeoutException ex) {
            results = this.getCurrentFHandles(fhandles);
        }
        return results;
    }

    private List<FHandle> getMissingFHandles(List<FHandle> fhandles) {
        List<FHandle> result = this.getCurrentFHandles(fhandles).stream().filter(fh -> fh.isMissing()).collect(Collectors.toList());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FHandle> getCurrentFHandles(List<FHandle> fhandles) {
        IPFSFileCache iPFSFileCache = this.filecache;
        synchronized (iPFSFileCache) {
            List<FHandle> result = fhandles.stream().map(fh -> fh.getCid()).map(cid -> this.filecache.get((String)cid)).collect(Collectors.toList());
            return result;
        }
    }

    private FHandle recordFileData(FHandle fhandle, Wallet.Address fromAddr, Wallet.Address toAddr) throws GeneralSecurityException {
        AssertArgument.assertTrue((Boolean)fhandle.isEncrypted(), (String)("File not encrypted: " + fhandle));
        byte[] data = this.bcdata.createFileData(fhandle);
        BigDecimal dustAmount = this.network.getDustThreshold();
        BigDecimal dataAmount = dustAmount.multiply(BigDecimal.TEN);
        BigDecimal spendAmount = dataAmount.add(this.network.getMinDataAmount());
        String label = (String)fromAddr.getLabels().get(0);
        List utxos = this.wallet.selectUnspent(label, this.addFee(spendAmount));
        BigDecimal utxosAmount = this.getUTXOAmount(utxos);
        Wallet.Address changeAddr = this.wallet.getChangeAddress(label);
        BigDecimal changeAmount = utxosAmount.subtract(this.addFee(spendAmount));
        ArrayList<TxOutput> outputs = new ArrayList<TxOutput>();
        if (dustAmount.compareTo(changeAmount) < 0) {
            outputs.add(new TxOutput(changeAddr.getAddress(), changeAmount));
        }
        outputs.add(new TxOutput(toAddr.getAddress(), dataAmount, data));
        Tx tx = new Tx.TxBuilder().unspentInputs(utxos).outputs(outputs).build();
        String txId = this.wallet.sendTx(tx);
        if (toAddr.getPrivKey() != null) {
            tx = this.wallet.getTransaction(txId);
            int vout = tx.outputs().size() - 2;
            TxOutput dataOut = (TxOutput)tx.outputs().get(vout);
            AssertState.assertEquals((Object)toAddr.getAddress(), (Object)dataOut.getAddress());
            AssertState.assertEquals((Object)dataAmount, (Object)dataOut.getAmount());
            LOG.info("Lock unspent: {} {}", (Object)txId, (Object)vout);
            BitcoindRpcClient client = this.getRpcClient();
            client.lockUnspent(false, txId, vout);
        }
        LOG.info("Redeem change: {}", (Object)changeAmount);
        ((AbstractWallet)this.wallet).redeemChange(label, fromAddr);
        fhandle = new FHandle.FHBuilder(fhandle).txId(txId).build();
        return fhandle;
    }

    private Wallet.Address getAddress(String rawAddr) {
        Wallet.Address addrs = this.wallet.findAddress(rawAddr);
        AssertState.assertNotNull((Object)addrs, (String)("Address not known to this wallet: " + rawAddr));
        return addrs;
    }

    private SecretKey getAESKey(byte[] token) {
        String encoded = Base64.getEncoder().encodeToString(token);
        return new AESCipher().decodeSecretKey(encoded);
    }

    private KeyPair getECKeyPair(Wallet.Address addr) throws GeneralSecurityException {
        this.assertArgumentHasPrivateKey(addr);
        byte[] rawKey = Base64.getDecoder().decode(addr.getPrivKey());
        byte[] seed = Arrays.reverse((byte[])rawKey);
        ECIESCipher cipher = new ECIESCipher();
        KeyPair keyPair = cipher.generateKeyPair(seed);
        return keyPair;
    }

    private BigDecimal addFee(BigDecimal amount) {
        return amount.add(this.network.estimateFee());
    }

    private BigDecimal getUTXOAmount(List<UTXO> utxos) {
        BigDecimal result = BigDecimal.ZERO;
        for (UTXO utxo : utxos) {
            result = result.add(utxo.getAmount());
        }
        return result;
    }

    private FHandle encrypt(FHandle fhandle, PublicKey pubKey) throws IOException, GeneralSecurityException {
        AssertArgument.assertTrue((Boolean)(!fhandle.isEncrypted() ? 1 : 0), (String)("File already encrypted: " + fhandle));
        AESCipher acipher = new AESCipher();
        SecretKey secKey = acipher.getSecretKey();
        ECIESCipher cipher = new ECIESCipher();
        byte[] encKey = cipher.encrypt(pubKey, secKey.getEncoded());
        String secToken = Base64.getEncoder().encodeToString(encKey);
        fhandle = new FHandle.FHBuilder(fhandle).secretToken(secToken).cid(null).build();
        File tmpFile = this.createTempFile().toFile();
        try (FileWriter fw = new FileWriter(tmpFile);){
            this.writeHeader(fhandle, fw);
            try (InputStream ins = fhandle.getURL().openStream();){
                InputStream encrypted = acipher.encrypt(secKey, ins);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                StreamUtils.copyStream((InputStream)encrypted, (OutputStream)baos);
                String base64Encoded = Base64.getEncoder().encodeToString(baos.toByteArray());
                fw.write(base64Encoded);
            }
        }
        return new FHandle.FHBuilder(fhandle).url(tmpFile.toURI().toURL()).build();
    }

    private FHandle decrypt(FHandle fhandle, Wallet.Address owner, Path destPath) throws IOException, GeneralSecurityException {
        FHeader header;
        Path cryptPath = this.getCryptPath(fhandle.getOwner()).resolve(fhandle.getCid());
        AssertState.assertTrue((Boolean)cryptPath.toFile().exists(), (String)("Cannot obtain file: " + cryptPath));
        destPath = destPath != null ? destPath : fhandle.getPath();
        AssertArgument.assertTrue((Boolean)(!destPath.isAbsolute() ? 1 : 0), (String)("Given path must be relative: " + destPath));
        try (FileReader fr = new FileReader(cryptPath.toFile());){
            header = FHeader.read(this.hvals, fr);
            AssertState.assertEquals((Object)this.hvals.VERSION_STRING, (Object)header.version);
        }
        fr = new FileReader(cryptPath.toFile());
        var7_6 = null;
        try {
            for (int i = 0; i < header.length; ++i) {
                fr.read();
            }
            ECIESCipher cipher = new ECIESCipher();
            KeyPair keyPair = this.getECKeyPair(owner);
            PrivateKey privKey = keyPair.getPrivate();
            byte[] encToken = Base64.getDecoder().decode(header.token);
            byte[] token = cipher.decrypt(privKey, encToken);
            SecretKey secKey = this.getAESKey(token);
            String base64Encoded = new BufferedReader(fr).readLine();
            byte[] encBytes = Base64.getDecoder().decode(base64Encoded);
            ByteArrayInputStream ins = new ByteArrayInputStream(encBytes);
            InputStream decrypted = new AESCipher().decrypt(secKey, (InputStream)ins);
            Path tmpFile = this.createTempFile();
            Files.copy(decrypted, tmpFile, StandardCopyOption.REPLACE_EXISTING);
            FHandle fHandle = new FHandle.FHBuilder(fhandle).url(tmpFile.toUri().toURL()).secretToken(null).path(destPath).build();
            return fHandle;
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        finally {
            if (fr != null) {
                if (var7_6 != null) {
                    try {
                        fr.close();
                    }
                    catch (Throwable throwable) {
                        var7_6.addSuppressed(throwable);
                    }
                } else {
                    fr.close();
                }
            }
        }
    }

    public PublicKey getPubKeyFromTx(UTXO utxo, Wallet.Address addr) {
        AssertArgument.assertNotNull((Object)utxo, (String)"Null utxo");
        Tx tx = this.wallet.getTransaction(utxo.getTxId());
        if (!this.isOurs(tx)) {
            return null;
        }
        PublicKey pubKey = null;
        List outs = tx.outputs();
        TxOutput out0 = (TxOutput)outs.get(outs.size() - 2);
        TxOutput out1 = (TxOutput)outs.get(outs.size() - 1);
        byte[] txdata = out1.getData();
        final byte[] keyBytes = this.bcdata.extractPubKeyData(txdata);
        Wallet.Address outAddr = this.wallet.findAddress(out0.getAddress());
        if (keyBytes != null && outAddr != null) {
            String encKey = Base64.getEncoder().encodeToString(keyBytes);
            LOG.info("PubKey Tx: {} => {} => {}", new Object[]{tx.txId(), outAddr, encKey});
            if (addr != null && !addr.equals(outAddr)) {
                return null;
            }
            pubKey = new PublicKey(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getFormat() {
                    return "X.509";
                }

                @Override
                public byte[] getEncoded() {
                    return keyBytes;
                }

                @Override
                public String getAlgorithm() {
                    return "EC";
                }
            };
        }
        return pubKey;
    }

    public FHandle getFHandleFromTx(UTXO utxo, Wallet.Address addr) {
        AssertArgument.assertNotNull((Object)utxo, (String)"Null utxo");
        Tx tx = this.wallet.getTransaction(utxo.getTxId());
        if (!this.isOurs(tx)) {
            return null;
        }
        FHandle fhandle = null;
        List outs = tx.outputs();
        TxOutput out0 = (TxOutput)outs.get(outs.size() - 2);
        TxOutput out1 = (TxOutput)outs.get(outs.size() - 1);
        byte[] txdata = out1.getData();
        byte[] hashBytes = this.bcdata.extractFileData(txdata);
        Wallet.Address outAddr = this.wallet.findAddress(out0.getAddress());
        if (hashBytes != null && outAddr != null) {
            String cid = new String(hashBytes);
            LOG.debug("File Tx: {} => {}", (Object)tx.txId(), (Object)cid);
            if (addr != null && !addr.equals(outAddr)) {
                return null;
            }
            fhandle = new FHandle.FHBuilder(cid).txId(tx.txId()).owner(addr).build();
        }
        return fhandle;
    }

    private List<UTXO> listLockedAndUnlockedUnspent(Wallet.Address addr, boolean locked, boolean unlocked) {
        ArrayList<UTXO> result = new ArrayList<UTXO>();
        if (unlocked) {
            result.addAll(this.wallet.listUnspent(java.util.Arrays.asList(addr)));
        }
        if (locked) {
            result.addAll(this.wallet.listLockUnspent(java.util.Arrays.asList(addr)));
        }
        return result;
    }

    private boolean isOurs(Tx tx) {
        List outs = tx.outputs();
        if (outs.size() < 2) {
            return false;
        }
        TxOutput out0 = (TxOutput)outs.get(outs.size() - 2);
        TxOutput out1 = (TxOutput)outs.get(outs.size() - 1);
        Wallet.Address addr = this.wallet.findAddress(out0.getAddress());
        if (addr == null) {
            return false;
        }
        if (out1.getData() == null) {
            return false;
        }
        byte[] txdata = out1.getData();
        return this.bcdata.isOurs(txdata);
    }

    private FHeader writeHeader(FHandle fhandle, Writer pw) throws GeneralSecurityException, IOException {
        String owner = fhandle.getOwner().getAddress();
        String base64Token = fhandle.getSecretToken();
        LOG.debug("IPFS token: {}", (Object)base64Token);
        FHeader header = new FHeader(this.hvals.VERSION_STRING, fhandle.getPath(), owner, base64Token, -1);
        header.write(this.hvals, pw);
        return header;
    }

    private void assertArgumentHasPrivateKey(Wallet.Address addr) {
        AssertArgument.assertNotNull((Object)addr.getPrivKey(), (String)("Wallet does not control private key for: " + addr));
    }

    private void assertArgumentHasLabel(Wallet.Address addr) {
        AssertArgument.assertTrue((Boolean)(!addr.getLabels().isEmpty() ? 1 : 0), (String)("Address has no label: " + addr));
    }

    private void assertArgumentNoChangeAddress(Wallet.Address addr) {
        AssertArgument.assertTrue((Boolean)(!addr.getLabels().contains("(change)") ? 1 : 0), (String)("Cannot use change address: " + addr));
    }

    private Path assertPlainPath(Wallet.Address owner, Path path) {
        AssertArgument.assertTrue((Boolean)(path != null && !path.isAbsolute() ? 1 : 0), (String)("Not a relative path: " + path));
        return this.getPlainPath(owner).resolve(path);
    }

    static class BCData {
        static final byte OP_PUB_KEY = 16;
        static final byte OP_FILE_DATA = 32;
        static final byte OP_RETURN = 106;
        final String OP_PREFIX;

        BCData(HValues hvals) {
            this.OP_PREFIX = hvals.PREFIX;
        }

        byte[] createPubKeyData(byte[] pubKey) {
            return this.buffer((byte)16, pubKey.length + 1).put((byte)pubKey.length).put(pubKey).array();
        }

        byte[] extractPubKeyData(byte[] txdata) {
            if (this.extractOpCode(txdata) != 16) {
                return null;
            }
            byte[] data = this.extractData(txdata);
            byte len = data[0];
            data = java.util.Arrays.copyOfRange(data, 1, 1 + len);
            return data;
        }

        byte[] createFileData(FHandle fhandle) {
            byte[] fid = fhandle.getCid().getBytes();
            return this.buffer((byte)32, fid.length + 1).put((byte)fid.length).put(fid).array();
        }

        byte[] extractFileData(byte[] txdata) {
            if (this.extractOpCode(txdata) != 32) {
                return null;
            }
            byte[] data = this.extractData(txdata);
            byte len = data[0];
            data = java.util.Arrays.copyOfRange(data, 1, 1 + len);
            return data;
        }

        boolean isOurs(byte[] txdata) {
            byte[] prefix = this.OP_PREFIX.getBytes();
            if (txdata[0] != 106) {
                return false;
            }
            if (txdata[1] != txdata.length - 2) {
                return false;
            }
            byte[] aux = java.util.Arrays.copyOfRange(txdata, 2, 2 + prefix.length);
            return java.util.Arrays.equals(prefix, aux);
        }

        byte extractOpCode(byte[] txdata) {
            if (!this.isOurs(txdata)) {
                return -1;
            }
            byte[] prefix = this.OP_PREFIX.getBytes();
            byte opcode = txdata[prefix.length + 2];
            return opcode;
        }

        private byte[] extractData(byte[] txdata) {
            if (!this.isOurs(txdata)) {
                return null;
            }
            byte[] prefix = this.OP_PREFIX.getBytes();
            return java.util.Arrays.copyOfRange(txdata, 2 + prefix.length + 1, txdata.length);
        }

        private ByteBuffer buffer(byte op, int dlength) {
            byte[] prefix = this.OP_PREFIX.getBytes();
            ByteBuffer buffer = ByteBuffer.allocate(prefix.length + 1 + dlength);
            buffer.put(prefix);
            buffer.put(op);
            return buffer;
        }
    }

    static class FHeader {
        final String version;
        final Path path;
        final String owner;
        final String token;
        final int length;

        FHeader(String version, Path path, String owner, String token, int length) {
            this.version = version;
            this.path = path;
            this.owner = owner;
            this.token = token;
            this.length = length;
        }

        static FHeader read(HValues hvals, Reader rd) throws IOException {
            BufferedReader br = new BufferedReader(rd);
            String line = br.readLine();
            AssertState.assertTrue((Boolean)line.startsWith(hvals.VERSION_STRING), (String)("Invalid version: " + line));
            String version = line;
            Path path = null;
            String owner = null;
            String token = null;
            int length = line.length() + 1;
            while (line != null) {
                line = br.readLine();
                if (line == null) continue;
                length += line.length() + 1;
                if (line.startsWith("Path: ")) {
                    path = Paths.get(line.substring(6), new String[0]);
                    continue;
                }
                if (line.startsWith("Owner: ")) {
                    owner = line.substring(7);
                    continue;
                }
                if (line.startsWith("Token: ")) {
                    token = line.substring(7);
                    continue;
                }
                if (!line.startsWith(hvals.FILE_HEADER_END)) continue;
                line = null;
            }
            return new FHeader(version, path, owner, token, length);
        }

        void write(HValues hvals, Writer wr) {
            PrintWriter pw = new PrintWriter(wr);
            pw.println(hvals.VERSION_STRING);
            pw.println(String.format("Path: %s", this.path));
            pw.println(String.format("Owner: %s", this.owner));
            pw.println(String.format("Token: %s", this.token));
            pw.println(hvals.FILE_HEADER_END);
        }
    }

    static class IPFSFileCache {
        private final Map<String, FHandle> filecache = Collections.synchronizedMap(new LinkedHashMap());

        IPFSFileCache() {
        }

        Set<String> keySet() {
            return this.filecache.keySet();
        }

        FHandle get(String cid) {
            return this.filecache.get(cid);
        }

        FHandle put(FHandle fhandle) {
            String cid = fhandle.getCid();
            AssertArgument.assertNotNull((Object)cid, (String)"Null cid");
            LOG.debug("Cache put: {}", (Object)fhandle);
            return this.filecache.put(cid, fhandle);
        }

        FHandle remove(String cid) {
            LOG.debug("Cache remove: {}", (Object)cid);
            return this.filecache.remove(cid);
        }
    }

    class AsyncGetCallable
    implements Callable<FHandle> {
        final long timeout;
        final FHandle fhandle;

        AsyncGetCallable(FHandle fhandle, Long timeout) {
            AssertArgument.assertNotNull((Object)fhandle, (String)"Null fhandle");
            AssertArgument.assertTrue((Boolean)fhandle.isScheduled(), (String)"Not scheduled");
            this.timeout = timeout != null ? timeout : DefaultContentManager.this.ipfsTimeout;
            this.fhandle = fhandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FHandle call() throws Exception {
            String cid = this.fhandle.getCid();
            int attempt = this.fhandle.getAttempt() + 1;
            FHandle fhres = new FHandle.FHBuilder(this.fhandle).attempt(attempt).build();
            DefaultContentManager.this.filecache.put(fhres);
            LOG.info("{}: {}", (Object)this.logPrefix("attempt", attempt), (Object)fhres);
            try {
                fhres = DefaultContentManager.this.ipfsGet(cid, this.timeout);
            }
            catch (IPFSException ex) {
                fhres = this.processIPFSException(fhres, ex);
            }
            finally {
                fhres.setScheduled(false);
                DefaultContentManager.this.filecache.put(fhres);
            }
            return fhres;
        }

        private FHandle processIPFSException(FHandle fhres, IPFSException ex) throws InterruptedException {
            fhres = DefaultContentManager.this.filecache.get(fhres.getCid());
            int attempt = fhres.getAttempt();
            if (ex instanceof IPFSTimeoutException) {
                if (DefaultContentManager.this.ipfsAttempts <= attempt) {
                    fhres = new FHandle.FHBuilder(fhres).expired(true).build();
                }
                LOG.info("{}: {}", (Object)this.logPrefix("timeout", attempt), (Object)fhres);
            } else if (ex instanceof MerkleNotFoundException) {
                fhres = new FHandle.FHBuilder(fhres).expired(true).build();
                LOG.warn("{}: {}", (Object)this.logPrefix("no merkle", attempt), (Object)fhres);
            } else {
                fhres = new FHandle.FHBuilder(fhres).expired(true).build();
                LOG.error("{}: {}", (Object)this.logPrefix("error", attempt), (Object)fhres);
            }
            return fhres;
        }

        private String logPrefix(String action, int attempt) {
            String trdName = Thread.currentThread().getName();
            return String.format("IPFS %s [%s] [%d/%d]", action, trdName, attempt, DefaultContentManager.this.ipfsAttempts);
        }
    }

    public static class HValues {
        public final String PREFIX;
        public final String VERSION;
        public final String VERSION_STRING;
        public final String FILE_HEADER_END;

        public HValues(String prefix, String version) {
            this.PREFIX = prefix;
            this.VERSION = version;
            this.VERSION_STRING = this.PREFIX + "-Version: " + this.VERSION;
            this.FILE_HEADER_END = this.PREFIX + "_HEADER_END";
        }
    }
}

