/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.weka;

public final class AssertState {
    private AssertState() {
    }

    public static <T> T isNull(T value) {
        return AssertState.isNull(value, "Not null: " + value);
    }

    public static <T> T isNull(T value, String message) {
        if (value != null) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static <T> T notNull(T value) {
        return AssertState.notNull(value, "Null value");
    }

    public static <T> T notNull(T value, String message) {
        if (value == null) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static Boolean isTrue(Boolean value) {
        return AssertState.isTrue(value, "Not true");
    }

    public static Boolean isTrue(Boolean value, String message) {
        if (!Boolean.valueOf(value).booleanValue()) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static Boolean isFalse(Boolean value) {
        return AssertState.isFalse(value, "Not false");
    }

    public static Boolean isFalse(Boolean value, String message) {
        if (Boolean.valueOf(value).booleanValue()) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static <T> T isEqual(T exp, T was) {
        return AssertState.isEqual(exp, was, exp + " != " + was);
    }

    public static <T> T isEqual(T exp, T was, String message) {
        AssertState.notNull(exp, message);
        AssertState.notNull(was, message);
        AssertState.isTrue(exp.equals(was), message);
        return was;
    }

    public static <T> T isSame(T exp, T was) {
        return AssertState.isSame(exp, was, exp + " != " + was);
    }

    public static <T> T isSame(T exp, T was, String message) {
        AssertState.notNull(exp, message);
        AssertState.notNull(was, message);
        AssertState.isTrue(exp == was, message);
        return was;
    }
}

