/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.weka.utils;

import io.nessus.weka.AssertArg;
import io.nessus.weka.AssertState;
import io.nessus.weka.UncheckedException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.converters.ArffLoader;
import weka.core.converters.CSVLoader;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;

public class DatasetUtils {
    private DatasetUtils() {
    }

    public static Instances read(URL url) {
        return DatasetUtils.readInternal(url);
    }

    public static Instances read(Path inpath) {
        return DatasetUtils.readInternal(inpath);
    }

    public static Instances read(String inpath) {
        return DatasetUtils.readInternal(Paths.get(inpath, new String[0]));
    }

    public static Instances read(InputStream input) {
        return DatasetUtils.readInternal(input);
    }

    public static void write(Instances instances, Path outpath) {
        DatasetUtils.writeInternal(instances, outpath);
    }

    public static Instances applyFilter(Instances instances, String filterSpec) {
        return DatasetUtils.applyFilter(instances, new OperatorSpec(filterSpec));
    }

    public static Instances applyFilter(Instances instances, String name, String[] options) {
        return DatasetUtils.applyFilter(instances, new OperatorSpec(name, options));
    }

    public static Instances applyFilter(Instances instances, OperatorSpec spec) {
        try {
            Filter filter = DatasetUtils.loadInstance(spec.getName(), Filter.class);
            filter.setOptions(spec.getOptions());
            filter.setInputFormat(instances);
            instances = Filter.useFilter((Instances)instances, (Filter)filter);
            return instances;
        }
        catch (Exception ex) {
            throw UncheckedException.create(ex);
        }
    }

    public static Classifier buildClassifier(Instances instances, String classifierSpec) {
        return DatasetUtils.buildClassifier(instances, new OperatorSpec(classifierSpec));
    }

    public static Classifier buildClassifier(Instances instances, String name, String[] options) {
        return DatasetUtils.buildClassifier(instances, new OperatorSpec(name, options));
    }

    public static Classifier buildClassifier(Instances instances, OperatorSpec spec) {
        try {
            Classifier classifier = DatasetUtils.loadInstance(spec.getName(), Classifier.class);
            ((OptionHandler)classifier).setOptions(spec.getOptions());
            classifier.buildClassifier(instances);
            return classifier;
        }
        catch (Exception ex) {
            throw UncheckedException.create(ex);
        }
    }

    private static Instances readInternal(Path inpath) {
        try {
            Instances instances = null;
            String fileName = inpath.getFileName().toString();
            if (instances == null && fileName.endsWith(".csv")) {
                try (FileInputStream input = new FileInputStream(inpath.toFile());){
                    instances = DatasetUtils.readInternal(input);
                }
            } else {
                ConverterUtils.DataSource source = new ConverterUtils.DataSource(inpath.toString());
                instances = source.getDataSet();
            }
            return instances;
        }
        catch (Exception ex) {
            throw UncheckedException.create(ex);
        }
    }

    private static Instances readInternal(URL url) {
        String externalForm = url.toExternalForm();
        if (externalForm.startsWith("file:")) {
            Path inpath = Paths.get(url.getPath(), new String[0]);
            return DatasetUtils.read(inpath);
        }
        try {
            ConverterUtils.DataSource source = new ConverterUtils.DataSource(externalForm);
            return source.getDataSet();
        }
        catch (Exception ex) {
            throw UncheckedException.create(ex);
        }
    }

    private static Instances readInternal(InputStream input) {
        Instances instances;
        block19: {
            instances = null;
            try {
                input = new BufferedInputStream(input);
                input.mark(10240);
                try {
                    ArffLoader loader = new ArffLoader();
                    loader.setSource(input);
                    loader.getStructure();
                    instances = loader.getDataSet();
                }
                catch (IOException ex) {
                    String exmsg = ex.getMessage();
                    if (!exmsg.contains("Unable to determine structure as arff")) {
                        throw ex;
                    }
                    input.reset();
                }
                if (instances != null) break block19;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(baos));
                try (BufferedReader br = new BufferedReader(new InputStreamReader(input));){
                    String line = br.readLine();
                    while (line != null) {
                        if (!line.startsWith("#")) {
                            bw.write(line);
                            bw.newLine();
                        }
                        line = br.readLine();
                    }
                    bw.flush();
                }
                input = new ByteArrayInputStream(baos.toByteArray());
                CSVLoader loader = new CSVLoader();
                loader.setSource(input);
                instances = loader.getDataSet();
            }
            catch (Exception ex) {
                throw UncheckedException.create(ex);
            }
        }
        return instances;
    }

    private static void writeInternal(Instances instances, Path outpath) {
        try {
            ConverterUtils.DataSink.write((String)outpath.toString(), (Instances)instances);
        }
        catch (Exception ex) {
            throw UncheckedException.create(ex);
        }
    }

    private static <T> T loadInstance(String name, Class<T> type) {
        List<String> packages = Arrays.asList("weka.filters.supervised.attribute", "weka.filters.supervised.instance", "weka.filters.unsupervised.attribute", "weka.filters.unsupervised.instance", "weka.filters", "weka.classifiers.bayes", "weka.classifiers.functions", "weka.classifiers.lazy", "weka.classifiers.rules", "weka.classifiers.trees", "weka.classifiers");
        ArrayList instances = new ArrayList();
        for (String packageName : packages) {
            ClassLoader loader = type.getClassLoader();
            try {
                Class<?> clazz = loader.loadClass(packageName + "." + name);
                Object filter = clazz.newInstance();
                instances.add(filter);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {}
        }
        List fqnames = instances.stream().map(f -> f.getClass().getName()).collect(Collectors.toList());
        AssertState.isFalse(fqnames.isEmpty(), "Cannot obtain " + type.getSimpleName() + " for name: " + name);
        AssertState.isEqual(1, fqnames.size(), "Ambiguous " + type.getSimpleName() + " name: " + fqnames);
        return (T)instances.get(0);
    }

    public static class OperatorSpec {
        private final String name;
        private final String[] options;

        public OperatorSpec(String spec) {
            this(OperatorSpec.name(spec), OperatorSpec.options(spec));
        }

        public OperatorSpec(String name, String options) {
            this(name, OperatorSpec.optionsNotNull(options).split(" "));
        }

        public OperatorSpec(String name, String[] options) {
            AssertArg.notNull(name, "Null name");
            AssertArg.notNull(options, "Null options");
            this.name = name;
            this.options = options;
        }

        public String getName() {
            return this.name;
        }

        public String[] getOptions() {
            return this.options;
        }

        private static String name(String spec) {
            int idx = spec.indexOf(" ");
            return idx > 0 ? spec.substring(0, idx) : spec;
        }

        private static String options(String spec) {
            int idx = spec.indexOf(" ");
            return idx > 0 ? spec.substring(idx + 1) : "";
        }

        private static String optionsNotNull(String options) {
            return options != null ? options : "";
        }

        public String toString() {
            return this.name + " " + Arrays.asList(this.options);
        }
    }
}

