/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DuplexChannel;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicStreamAddress;
import io.netty.incubator.codec.quic.QuicStreamChannelConfig;
import io.netty.incubator.codec.quic.QuicStreamPriority;
import io.netty.incubator.codec.quic.QuicStreamType;
import java.net.SocketAddress;

public interface QuicStreamChannel
extends DuplexChannel {
    public static final ChannelFutureListener SHUTDOWN_OUTPUT = f -> ((QuicStreamChannel)f.channel()).shutdownOutput();

    default public ChannelFuture bind(SocketAddress socketAddress) {
        return this.pipeline().bind(socketAddress);
    }

    default public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.pipeline().connect(remoteAddress);
    }

    default public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.pipeline().connect(remoteAddress, localAddress);
    }

    default public ChannelFuture disconnect() {
        return this.pipeline().disconnect();
    }

    default public ChannelFuture close() {
        return this.pipeline().close();
    }

    default public ChannelFuture deregister() {
        return this.pipeline().deregister();
    }

    default public ChannelFuture bind(SocketAddress localAddress, ChannelPromise channelPromise) {
        return this.pipeline().bind(localAddress, channelPromise);
    }

    default public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise channelPromise) {
        return this.pipeline().connect(remoteAddress, channelPromise);
    }

    default public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise channelPromise) {
        return this.pipeline().connect(remoteAddress, localAddress, channelPromise);
    }

    default public ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.pipeline().disconnect(channelPromise);
    }

    default public ChannelFuture close(ChannelPromise channelPromise) {
        return this.pipeline().close(channelPromise);
    }

    default public ChannelFuture deregister(ChannelPromise channelPromise) {
        return this.pipeline().deregister(channelPromise);
    }

    default public ChannelFuture write(Object msg) {
        return this.pipeline().write(msg);
    }

    default public ChannelFuture write(Object msg, ChannelPromise channelPromise) {
        return this.pipeline().write(msg, channelPromise);
    }

    default public ChannelFuture writeAndFlush(Object msg, ChannelPromise channelPromise) {
        return this.pipeline().writeAndFlush(msg, channelPromise);
    }

    default public ChannelFuture writeAndFlush(Object msg) {
        return this.pipeline().writeAndFlush(msg);
    }

    default public ChannelPromise newPromise() {
        return this.pipeline().newPromise();
    }

    default public ChannelProgressivePromise newProgressivePromise() {
        return this.pipeline().newProgressivePromise();
    }

    default public ChannelFuture newSucceededFuture() {
        return this.pipeline().newSucceededFuture();
    }

    default public ChannelFuture newFailedFuture(Throwable cause) {
        return this.pipeline().newFailedFuture(cause);
    }

    default public ChannelPromise voidPromise() {
        return this.pipeline().voidPromise();
    }

    default public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    default public ChannelFuture shutdownInput(ChannelPromise promise) {
        return this.shutdownInput(0, promise);
    }

    default public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    default public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    default public ChannelFuture shutdown(int error) {
        return this.shutdown(error, this.newPromise());
    }

    public ChannelFuture shutdown(int var1, ChannelPromise var2);

    default public ChannelFuture shutdownInput(int error) {
        return this.shutdownInput(error, this.newPromise());
    }

    public ChannelFuture shutdownInput(int var1, ChannelPromise var2);

    default public ChannelFuture shutdownOutput(int error) {
        return this.shutdownOutput(error, this.newPromise());
    }

    public ChannelFuture shutdownOutput(int var1, ChannelPromise var2);

    public QuicStreamAddress localAddress();

    public QuicStreamAddress remoteAddress();

    public boolean isLocalCreated();

    public QuicStreamType type();

    public long streamId();

    public QuicStreamPriority priority();

    default public ChannelFuture updatePriority(QuicStreamPriority priority) {
        return this.updatePriority(priority, this.newPromise());
    }

    public ChannelFuture updatePriority(QuicStreamPriority var1, ChannelPromise var2);

    public QuicChannel parent();

    public QuicStreamChannel read();

    public QuicStreamChannel flush();

    public QuicStreamChannelConfig config();
}

