/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollSocketChannelConfig;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class EpollSocketChannel
extends AbstractEpollChannel
implements SocketChannel {
    private final EpollSocketChannelConfig config = new EpollSocketChannelConfig(this);
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;

    EpollSocketChannel(Channel parent, int fd) {
        super(parent, fd, 1, true);
    }

    public EpollSocketChannel() {
        super(1);
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollSocketUnsafe();
    }

    @Override
    protected SocketAddress localAddress0() {
        return Native.localAddress(this.fd);
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return Native.remoteAddress(this.fd);
    }

    @Override
    protected void doBind(SocketAddress local) throws Exception {
        InetSocketAddress localAddress = (InetSocketAddress)local;
        Native.bind(this.fd, localAddress.getAddress(), localAddress.getPort());
    }

    private void setEpollOut() {
        if ((this.flags & 2) == 0) {
            this.flags |= 2;
            ((EpollEventLoop)this.eventLoop()).modify(this);
        }
    }

    private void clearEpollOut() {
        if ((this.flags & 2) != 0) {
            this.flags &= 0xFFFFFFFD;
            ((EpollEventLoop)this.eventLoop()).modify(this);
        }
    }

    private int doWriteBytes(ByteBuf buf, int readable) throws Exception {
        int localFlushedAmount;
        int readerIndex = buf.readerIndex();
        if (buf.nioBufferCount() == 1) {
            if (buf.hasMemoryAddress()) {
                localFlushedAmount = Native.writeAddress(this.fd, buf.memoryAddress(), readerIndex, buf.writerIndex());
            } else {
                ByteBuffer nioBuf = buf.internalNioBuffer(readerIndex, readable);
                localFlushedAmount = Native.write(this.fd, nioBuf, nioBuf.position(), nioBuf.limit());
            }
        } else {
            ByteBuffer[] nioBufs = buf.nioBuffers();
            localFlushedAmount = (int)Native.writev(this.fd, nioBufs, 0, nioBufs.length);
        }
        if (localFlushedAmount > 0) {
            buf.readerIndex(readerIndex + localFlushedAmount);
        }
        return localFlushedAmount;
    }

    private void writeBytesMultiple(ChannelOutboundBuffer in, int msgCount, ByteBuffer[] nioBuffers) throws IOException {
        int nioBufferCnt = in.nioBufferCount();
        long expectedWrittenBytes = in.nioBufferSize();
        long localWrittenBytes = Native.writev(this.fd, nioBuffers, 0, nioBufferCnt);
        if (localWrittenBytes < expectedWrittenBytes) {
            this.setEpollOut();
            for (int i = msgCount; i > 0; --i) {
                ByteBuf buf = (ByteBuf)in.current();
                int readerIndex = buf.readerIndex();
                int readableBytes = buf.writerIndex() - readerIndex;
                if ((long)readableBytes < localWrittenBytes) {
                    in.remove();
                    localWrittenBytes -= (long)readableBytes;
                    continue;
                }
                if ((long)readableBytes > localWrittenBytes) {
                    buf.readerIndex(readerIndex + (int)localWrittenBytes);
                    in.progress(localWrittenBytes);
                } else {
                    in.remove();
                }
                break;
            }
        } else {
            for (int i = msgCount; i > 0; --i) {
                in.remove();
            }
        }
    }

    private long doWriteFileRegion(DefaultFileRegion region, long count) throws Exception {
        return Native.sendfile(this.fd, region, region.transfered(), count);
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        block7: {
            Object msg;
            while (true) {
                ByteBuffer[] nioBuffers;
                int msgCount;
                if ((msgCount = in.size()) == 0) {
                    this.clearEpollOut();
                    break block7;
                }
                if (msgCount > 1 && (nioBuffers = in.nioBuffers()) != null) {
                    this.writeBytesMultiple(in, msgCount, nioBuffers);
                    continue;
                }
                msg = in.current();
                if (msg instanceof ByteBuf) {
                    ByteBuf buf = (ByteBuf)msg;
                    int readableBytes = buf.readableBytes();
                    if (readableBytes == 0) {
                        in.remove();
                        continue;
                    }
                    int expected = buf.readableBytes();
                    int localFlushedAmount = this.doWriteBytes(buf, expected);
                    in.progress(localFlushedAmount);
                    if (localFlushedAmount < expected) {
                        this.setEpollOut();
                        break block7;
                    }
                    if (buf.isReadable()) continue;
                    in.remove();
                    continue;
                }
                if (!(msg instanceof DefaultFileRegion)) break;
                DefaultFileRegion region = (DefaultFileRegion)msg;
                long expected = region.count() - region.position();
                long localFlushedAmount = this.doWriteFileRegion(region, expected);
                in.progress(localFlushedAmount);
                if (localFlushedAmount < expected) {
                    this.setEpollOut();
                    break block7;
                }
                if (region.transfered() < region.count()) continue;
                in.remove();
            }
            throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg));
        }
    }

    @Override
    public EpollSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.outputShutdown || !this.isActive();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(final ChannelPromise promise) {
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            try {
                Native.shutdown(this.fd, false, true);
                this.outputShutdown = true;
                promise.setSuccess();
            }
            catch (Throwable t) {
                promise.setFailure(t);
            }
        } else {
            loop.execute(new Runnable(){

                @Override
                public void run() {
                    EpollSocketChannel.this.shutdownOutput(promise);
                }
            });
        }
        return promise;
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    final class EpollSocketUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        private RecvByteBufAllocator.Handle allocHandle;

        EpollSocketUnsafe() {
        }

        @Override
        public void write(Object msg, ChannelPromise promise) {
            ByteBuf buf;
            if (msg instanceof ByteBuf && !(buf = (ByteBuf)msg).isDirect()) {
                int readable = buf.readableBytes();
                ByteBuf dst = EpollSocketChannel.this.alloc().directBuffer(readable);
                dst.writeBytes(buf, buf.readerIndex(), readable);
                buf.release();
                msg = dst;
            }
            super.write(msg, promise);
        }

        private void closeOnRead(ChannelPipeline pipeline) {
            EpollSocketChannel.this.inputShutdown = true;
            if (EpollSocketChannel.this.isOpen()) {
                if (Boolean.TRUE.equals(EpollSocketChannel.this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                    EpollSocketChannel.this.clearEpollIn();
                    pipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                } else {
                    this.close(this.voidPromise());
                }
            }
        }

        private boolean handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean close) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    this.readPending = false;
                    pipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            pipeline.fireChannelReadComplete();
            pipeline.fireExceptionCaught(cause);
            if (close || cause instanceof IOException) {
                this.closeOnRead(pipeline);
                return true;
            }
            return false;
        }

        @Override
        public void connect(final SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
                return;
            }
            try {
                if (EpollSocketChannel.this.connectPromise != null) {
                    throw new IllegalStateException("connection attempt already made");
                }
                boolean wasActive = EpollSocketChannel.this.isActive();
                if (this.doConnect((InetSocketAddress)remoteAddress, (InetSocketAddress)localAddress)) {
                    this.fulfillConnectPromise(promise, wasActive);
                } else {
                    EpollSocketChannel.this.connectPromise = promise;
                    EpollSocketChannel.this.requestedRemoteAddress = remoteAddress;
                    int connectTimeoutMillis = EpollSocketChannel.this.config().getConnectTimeoutMillis();
                    if (connectTimeoutMillis > 0) {
                        EpollSocketChannel.this.connectTimeoutFuture = EpollSocketChannel.this.eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ChannelPromise connectPromise = EpollSocketChannel.this.connectPromise;
                                ConnectTimeoutException cause = new ConnectTimeoutException("connection timed out: " + remoteAddress);
                                if (connectPromise != null && connectPromise.tryFailure(cause)) {
                                    EpollSocketUnsafe.this.close(EpollSocketUnsafe.this.voidPromise());
                                }
                            }
                        }, (long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
                    }
                    promise.addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isCancelled()) {
                                if (EpollSocketChannel.this.connectTimeoutFuture != null) {
                                    EpollSocketChannel.this.connectTimeoutFuture.cancel(false);
                                }
                                EpollSocketChannel.this.connectPromise = null;
                                EpollSocketUnsafe.this.close(EpollSocketUnsafe.this.voidPromise());
                            }
                        }
                    });
                }
            }
            catch (Throwable t2) {
                ConnectException t2;
                if (t2 instanceof ConnectException) {
                    ConnectException newT = new ConnectException(t2.getMessage() + ": " + remoteAddress);
                    newT.setStackTrace(t2.getStackTrace());
                    t2 = newT;
                }
                this.closeIfClosed();
                promise.tryFailure(t2);
            }
        }

        private void fulfillConnectPromise(ChannelPromise promise, boolean wasActive) {
            if (promise == null) {
                return;
            }
            EpollSocketChannel.this.active = true;
            boolean promiseSet = promise.trySuccess();
            if (!wasActive && EpollSocketChannel.this.isActive()) {
                EpollSocketChannel.this.pipeline().fireChannelActive();
            }
            if (!promiseSet) {
                this.close(this.voidPromise());
            }
        }

        private void fulfillConnectPromise(ChannelPromise promise, Throwable cause) {
            if (promise == null) {
                // empty if block
            }
            promise.tryFailure(cause);
            this.closeIfClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishConnect() {
            assert (EpollSocketChannel.this.eventLoop().inEventLoop());
            try {
                boolean wasActive = EpollSocketChannel.this.isActive();
                this.doFinishConnect();
                this.fulfillConnectPromise(EpollSocketChannel.this.connectPromise, wasActive);
            }
            catch (Throwable t2) {
                ConnectException t2;
                if (t2 instanceof ConnectException) {
                    ConnectException newT = new ConnectException(t2.getMessage() + ": " + EpollSocketChannel.this.requestedRemoteAddress);
                    newT.setStackTrace(t2.getStackTrace());
                    t2 = newT;
                }
                this.fulfillConnectPromise(EpollSocketChannel.this.connectPromise, t2);
            }
            finally {
                if (EpollSocketChannel.this.connectTimeoutFuture != null) {
                    EpollSocketChannel.this.connectTimeoutFuture.cancel(false);
                }
                EpollSocketChannel.this.connectPromise = null;
            }
        }

        @Override
        void epollOutReady() {
            if (EpollSocketChannel.this.connectPromise != null) {
                this.finishConnect();
            } else {
                super.epollOutReady();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doConnect(InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws Exception {
            if (localAddress != null) {
                Native.bind(EpollSocketChannel.this.fd, localAddress.getAddress(), localAddress.getPort());
            }
            boolean success = false;
            try {
                boolean connected = Native.connect(EpollSocketChannel.this.fd, remoteAddress.getAddress(), remoteAddress.getPort());
                if (!connected) {
                    EpollSocketChannel.this.setEpollOut();
                }
                success = true;
                boolean bl = connected;
                return bl;
            }
            finally {
                if (!success) {
                    EpollSocketChannel.this.doClose();
                }
            }
        }

        private void doFinishConnect() throws Exception {
            Native.finishConnect(EpollSocketChannel.this.fd);
            EpollSocketChannel.this.clearEpollOut();
        }

        private int doReadBytes(ByteBuf byteBuf) throws Exception {
            int localReadAmount;
            int writerIndex = byteBuf.writerIndex();
            if (byteBuf.hasMemoryAddress()) {
                localReadAmount = Native.readAddress(EpollSocketChannel.this.fd, byteBuf.memoryAddress(), writerIndex, byteBuf.capacity());
            } else {
                ByteBuffer buf = byteBuf.internalNioBuffer(writerIndex, byteBuf.writableBytes());
                localReadAmount = Native.read(EpollSocketChannel.this.fd, buf, buf.position(), buf.limit());
            }
            if (localReadAmount > 0) {
                byteBuf.writerIndex(writerIndex + localReadAmount);
            }
            return localReadAmount;
        }

        @Override
        void epollRdHupReady() {
            if (EpollSocketChannel.this.isActive()) {
                this.epollInReady();
            } else {
                this.closeOnRead(EpollSocketChannel.this.pipeline());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void epollInReady() {
            EpollSocketChannelConfig config = EpollSocketChannel.this.config();
            ChannelPipeline pipeline = EpollSocketChannel.this.pipeline();
            ByteBufAllocator allocator = config.getAllocator();
            RecvByteBufAllocator.Handle allocHandle = this.allocHandle;
            if (allocHandle == null) {
                this.allocHandle = allocHandle = config.getRecvByteBufAllocator().newHandle();
            }
            ByteBuf byteBuf = null;
            boolean close = false;
            try {
                int writable;
                int localReadAmount;
                int byteBufCapacity = allocHandle.guess();
                int totalReadAmount = 0;
                do {
                    byteBuf = allocator.directBuffer(byteBufCapacity);
                    writable = byteBuf.writableBytes();
                    localReadAmount = this.doReadBytes(byteBuf);
                    if (localReadAmount <= 0) {
                        byteBuf.release();
                        close = localReadAmount < 0;
                        break;
                    }
                    this.readPending = false;
                    pipeline.fireChannelRead(byteBuf);
                    byteBuf = null;
                    if (totalReadAmount >= Integer.MAX_VALUE - localReadAmount) {
                        allocHandle.record(totalReadAmount);
                        totalReadAmount = localReadAmount;
                        continue;
                    }
                    totalReadAmount += localReadAmount;
                } while (localReadAmount >= writable);
                pipeline.fireChannelReadComplete();
                allocHandle.record(totalReadAmount);
                if (close) {
                    this.closeOnRead(pipeline);
                    close = false;
                }
            }
            catch (Throwable t) {
                boolean closed = this.handleReadException(pipeline, byteBuf, t, close);
                if (!closed) {
                    EpollSocketChannel.this.eventLoop().execute(new Runnable(){

                        @Override
                        public void run() {
                            EpollSocketUnsafe.this.epollInReady();
                        }
                    });
                }
            }
            finally {
                if (!config.isAutoRead() && !this.readPending) {
                    EpollSocketChannel.this.clearEpollIn();
                }
            }
        }
    }
}

