/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerInvoker;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelProgressivePromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.PausableChannelEventExecutor;
import io.netty.channel.SucceededChannelFuture;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakHint;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.PausableEventExecutor;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

abstract class AbstractChannelHandlerContext
implements ChannelHandlerContext,
ResourceLeakHint {
    static final int MASK_HANDLER_ADDED = 1;
    static final int MASK_HANDLER_REMOVED = 2;
    private static final int MASK_EXCEPTION_CAUGHT = 4;
    private static final int MASK_CHANNEL_REGISTERED = 8;
    private static final int MASK_CHANNEL_UNREGISTERED = 16;
    private static final int MASK_CHANNEL_ACTIVE = 32;
    private static final int MASK_CHANNEL_INACTIVE = 64;
    private static final int MASK_CHANNEL_READ = 128;
    private static final int MASK_CHANNEL_READ_COMPLETE = 256;
    private static final int MASK_CHANNEL_WRITABILITY_CHANGED = 512;
    private static final int MASK_USER_EVENT_TRIGGERED = 1024;
    private static final int MASK_BIND = 2048;
    private static final int MASK_CONNECT = 4096;
    private static final int MASK_DISCONNECT = 8192;
    private static final int MASK_CLOSE = 16384;
    private static final int MASK_DEREGISTER = 32768;
    private static final int MASK_READ = 65536;
    private static final int MASK_WRITE = 131072;
    private static final int MASK_FLUSH = 262144;
    private static final int MASKGROUP_INBOUND = 2044;
    private static final int MASKGROUP_OUTBOUND = 522240;
    private static final FastThreadLocal<WeakHashMap<Class<?>, Integer>> skipFlagsCache = new FastThreadLocal<WeakHashMap<Class<?>, Integer>>(){

        @Override
        protected WeakHashMap<Class<?>, Integer> initialValue() throws Exception {
            return new WeakHashMap();
        }
    };
    private static final AtomicReferenceFieldUpdater<AbstractChannelHandlerContext, PausableChannelEventExecutor> WRAPPED_EVENTEXECUTOR_UPDATER;
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private final AbstractChannel channel;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    boolean invokedThisChannelRead;
    private volatile boolean invokedNextChannelRead;
    private volatile boolean invokedPrevRead;
    private boolean removed;
    final int skipFlags;
    final ChannelHandlerInvoker invoker;
    private ChannelFuture succeededFuture;
    volatile Runnable invokeChannelReadCompleteTask;
    volatile Runnable invokeReadTask;
    volatile Runnable invokeFlushTask;
    volatile Runnable invokeChannelWritableStateChangedTask;
    private volatile PausableChannelEventExecutor wrappedEventLoop;

    static int skipFlags(ChannelHandler handler) {
        int flagsVal;
        Class<?> handlerType;
        WeakHashMap<Class<?>, Integer> cache = skipFlagsCache.get();
        Integer flags = cache.get(handlerType = handler.getClass());
        if (flags != null) {
            flagsVal = flags;
        } else {
            flagsVal = AbstractChannelHandlerContext.skipFlags0(handlerType);
            cache.put(handlerType, flagsVal);
        }
        return flagsVal;
    }

    static int skipFlags0(Class<? extends ChannelHandler> handlerType) {
        int flags = 0;
        try {
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "handlerAdded", new Class[0])) {
                flags |= 1;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "handlerRemoved", new Class[0])) {
                flags |= 2;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "exceptionCaught", Throwable.class)) {
                flags |= 4;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "channelRegistered", new Class[0])) {
                flags |= 8;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "channelUnregistered", new Class[0])) {
                flags |= 0x10;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "channelActive", new Class[0])) {
                flags |= 0x20;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "channelInactive", new Class[0])) {
                flags |= 0x40;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "channelRead", Object.class)) {
                flags |= 0x80;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "channelReadComplete", new Class[0])) {
                flags |= 0x100;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "channelWritabilityChanged", new Class[0])) {
                flags |= 0x200;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "userEventTriggered", Object.class)) {
                flags |= 0x400;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "bind", SocketAddress.class, ChannelPromise.class)) {
                flags |= 0x800;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "connect", SocketAddress.class, SocketAddress.class, ChannelPromise.class)) {
                flags |= 0x1000;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "disconnect", ChannelPromise.class)) {
                flags |= 0x2000;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "close", ChannelPromise.class)) {
                flags |= 0x4000;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "deregister", ChannelPromise.class)) {
                flags |= 0x8000;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "read", new Class[0])) {
                flags |= 0x10000;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "write", Object.class, ChannelPromise.class)) {
                flags |= 0x20000;
            }
            if (AbstractChannelHandlerContext.isSkippable(handlerType, "flush", new Class[0])) {
                flags |= 0x40000;
            }
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
        }
        return flags;
    }

    private static boolean isSkippable(Class<?> handlerType, String methodName, Class<?> ... paramTypes) throws Exception {
        Class[] newParamTypes = new Class[paramTypes.length + 1];
        newParamTypes[0] = ChannelHandlerContext.class;
        System.arraycopy(paramTypes, 0, newParamTypes, 1, paramTypes.length);
        return handlerType.getMethod(methodName, newParamTypes).isAnnotationPresent(ChannelHandler.Skip.class);
    }

    AbstractChannelHandlerContext(DefaultChannelPipeline pipeline, ChannelHandlerInvoker invoker, String name, int skipFlags) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.channel = pipeline.channel;
        this.pipeline = pipeline;
        this.name = name;
        this.invoker = invoker;
        this.skipFlags = skipFlags;
    }

    @Override
    public final Channel channel() {
        return this.channel;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public final EventExecutor executor() {
        if (this.invoker == null) {
            return this.channel().eventLoop();
        }
        return this.wrappedEventLoop();
    }

    @Override
    public final ChannelHandlerInvoker invoker() {
        if (this.invoker == null) {
            return this.channel().eventLoop().asInvoker();
        }
        return this.wrappedEventLoop();
    }

    private PausableChannelEventExecutor wrappedEventLoop() {
        PausableChannelEventExecutor wrapped = this.wrappedEventLoop;
        if (wrapped == null && !WRAPPED_EVENTEXECUTOR_UPDATER.compareAndSet(this, null, wrapped = new PausableChannelEventExecutor0())) {
            return this.wrappedEventLoop;
        }
        return wrapped;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.channel.attr(key);
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> key) {
        return this.channel.hasAttr(key);
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invoker().invokeChannelRegistered(next);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invoker().invokeChannelUnregistered(next);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invoker().invokeChannelActive(next);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invoker().invokeChannelInactive(next);
        return this;
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invoker().invokeExceptionCaught(next, cause);
        return this;
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object event) {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invoker().invokeUserEventTriggered(next, event);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object msg) {
        AbstractChannelHandlerContext next = this.findContextInbound();
        ReferenceCountUtil.touch(msg, next);
        this.invokedNextChannelRead = true;
        next.invoker().invokeChannelRead(next, msg);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        if (this.invokedNextChannelRead || !this.invokedThisChannelRead) {
            this.invokedNextChannelRead = false;
            this.invokedPrevRead = false;
            AbstractChannelHandlerContext next = this.findContextInbound();
            next.invoker().invokeChannelReadComplete(next);
            return this;
        }
        if (this.invokedPrevRead && !this.channel().config().isAutoRead()) {
            this.read();
        } else {
            this.invokedPrevRead = false;
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invoker().invokeChannelWritabilityChanged(next);
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.bind(localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connect(remoteAddress, localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public ChannelFuture deregister() {
        return this.deregister(this.newPromise());
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invoker().invokeBind(next, localAddress, promise);
        return promise;
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.connect(remoteAddress, null, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invoker().invokeConnect(next, remoteAddress, localAddress, promise);
        return promise;
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        if (!this.channel().metadata().hasDisconnect()) {
            return this.close(promise);
        }
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invoker().invokeDisconnect(next, promise);
        return promise;
    }

    @Override
    public ChannelFuture close(ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invoker().invokeClose(next, promise);
        return promise;
    }

    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invoker().invokeDeregister(next, promise);
        return promise;
    }

    @Override
    public ChannelHandlerContext read() {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        this.invokedPrevRead = true;
        next.invoker().invokeRead(next);
        return this;
    }

    @Override
    public ChannelFuture write(Object msg) {
        return this.write(msg, this.newPromise());
    }

    @Override
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        ReferenceCountUtil.touch(msg, next);
        next.invoker().invokeWrite(next, msg, promise);
        return promise;
    }

    @Override
    public ChannelHandlerContext flush() {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invoker().invokeFlush(next);
        return this;
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        ReferenceCountUtil.touch(msg, next);
        next.invoker().invokeWrite(next, msg, promise);
        next = this.findContextOutbound();
        next.invoker().invokeFlush(next);
        return promise;
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, this.newPromise());
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        ChannelFuture succeededFuture = this.succeededFuture;
        if (succeededFuture == null) {
            this.succeededFuture = succeededFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return succeededFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable cause) {
        return new FailedChannelFuture(this.channel(), this.executor(), cause);
    }

    private AbstractChannelHandlerContext findContextInbound() {
        AbstractChannelHandlerContext ctx = this;
        do {
            ctx = ctx.next;
        } while ((ctx.skipFlags & 0x7FC) == 2044);
        return ctx;
    }

    private AbstractChannelHandlerContext findContextOutbound() {
        AbstractChannelHandlerContext ctx = this;
        do {
            ctx = ctx.prev;
        } while ((ctx.skipFlags & 0x7F800) == 522240);
        return ctx;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel.voidPromise();
    }

    void setRemoved() {
        this.removed = true;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public String toHintString() {
        return '\'' + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + '(' + this.name + ", " + this.channel + ')';
    }

    static {
        AtomicReferenceFieldUpdater<AbstractChannelHandlerContext, Object> updater = PlatformDependent.newAtomicReferenceFieldUpdater(AbstractChannelHandlerContext.class, "wrappedEventLoop");
        if (updater == null) {
            updater = AtomicReferenceFieldUpdater.newUpdater(AbstractChannelHandlerContext.class, PausableChannelEventExecutor.class, "wrappedEventLoop");
        }
        WRAPPED_EVENTEXECUTOR_UPDATER = updater;
    }

    private final class PausableChannelEventExecutor0
    extends PausableChannelEventExecutor {
        private PausableChannelEventExecutor0() {
        }

        @Override
        public void rejectNewTasks() {
            ((PausableEventExecutor)((Object)this.channel().eventLoop())).rejectNewTasks();
        }

        @Override
        public void acceptNewTasks() {
            ((PausableEventExecutor)((Object)this.channel().eventLoop())).acceptNewTasks();
        }

        @Override
        public boolean isAcceptingNewTasks() {
            return ((PausableEventExecutor)((Object)this.channel().eventLoop())).isAcceptingNewTasks();
        }

        @Override
        public Channel channel() {
            return AbstractChannelHandlerContext.this.channel();
        }

        @Override
        public EventExecutor unwrap() {
            return this.unwrapInvoker().executor();
        }

        @Override
        public ChannelHandlerInvoker unwrapInvoker() {
            return AbstractChannelHandlerContext.this.invoker;
        }
    }
}

